/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.janelia.saalfeldlab.n5.universe.metadata.MetadataUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMultiScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.coordinateTransformations.CoordinateTransformation;

public class MultiscalesAdapter
implements JsonDeserializer<OmeNgffMultiScaleMetadata>,
JsonSerializer<OmeNgffMultiScaleMetadata> {
    @Override
    public OmeNgffMultiScaleMetadata deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            return null;
        }
        JsonObject jobj = json.getAsJsonObject();
        if (!jobj.has("axes") && !jobj.has("datasets")) {
            return null;
        }
        String name = MetadataUtils.getStringNullable(jobj.get("name"));
        String type = MetadataUtils.getStringNullable(jobj.get("type"));
        String version = jobj.get("version").getAsString();
        Axis[] axes = (Axis[])context.deserialize(jobj.get("axes"), (Type)((Object)Axis[].class));
        OmeNgffMultiScaleMetadata.OmeNgffDataset[] datasets = (OmeNgffMultiScaleMetadata.OmeNgffDataset[])context.deserialize(jobj.get("datasets"), (Type)((Object)OmeNgffMultiScaleMetadata.OmeNgffDataset[].class));
        CoordinateTransformation[] coordinateTransformations = (CoordinateTransformation[])context.deserialize(jobj.get("coordinateTransformations"), (Type)((Object)CoordinateTransformation[].class));
        OmeNgffMultiScaleMetadata.OmeNgffDownsamplingMetadata metadata = (OmeNgffMultiScaleMetadata.OmeNgffDownsamplingMetadata)context.deserialize(jobj.get("metadata"), (Type)((Object)OmeNgffMultiScaleMetadata.OmeNgffDownsamplingMetadata.class));
        return new OmeNgffMultiScaleMetadata(axes.length, "", name, type, version, axes, datasets, null, coordinateTransformations, metadata, false);
    }

    @Override
    public JsonElement serialize(OmeNgffMultiScaleMetadata src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty("name", src.name);
        obj.addProperty("type", src.type);
        obj.addProperty("version", src.version);
        obj.add("axes", context.serialize(src.axes));
        obj.add("datasets", context.serialize(src.datasets));
        if (src.coordinateTransformations != null) {
            if (src.coordinateTransformations.length == 0) {
                obj.add("coordinateTransformations", context.serialize(new JsonArray()));
            } else {
                obj.add("coordinateTransformations", context.serialize(src.coordinateTransformations));
            }
        } else {
            obj.add("coordinateTransformations", context.serialize(new JsonArray()));
        }
        if (src.metadata != null) {
            obj.add("metadata", context.serialize(src.metadata));
        }
        return obj;
    }
}

