/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.canonical;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Optional;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.GsonUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.AbstractMetadataTemplateParser;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.SpatialMetadataCanonical;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.CalibratedSpatialTransform;

public class SpatialMetadataTemplateCanonical
extends AbstractMetadataTemplateParser<SpatialMetadataCanonical> {
    public SpatialMetadataTemplateCanonical(Gson gson, String translation) {
        super(gson, translation);
    }

    @Override
    public Optional<SpatialMetadataCanonical> parse(Gson gson, JsonElement elem) {
        try {
            String path = GsonUtils.readAttribute(elem, "path", String.class, gson);
            CalibratedSpatialTransform transform = GsonUtils.readAttribute(elem, "spatialTransform", CalibratedSpatialTransform.class, gson);
            Axis[] axes = GsonUtils.readAttribute(elem, "axes", Axis[].class, gson);
            Optional<DatasetAttributes> attributes = AbstractMetadataTemplateParser.datasetAttributes(gson, elem.getAsJsonObject());
            if (attributes.isPresent()) {
                return Optional.of(new SpatialMetadataCanonical(path, transform, axes));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    @Override
    public Optional<SpatialMetadataCanonical> parseFromMap(Gson gson, HashMap<String, JsonElement> attributeMap) {
        return AbstractMetadataTemplateParser.parseFromMap(gson, attributeMap, (g, e) -> this.parse(gson, (JsonElement)e));
    }
}

