/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.canonical;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.thisptr.jackson.jq.BuiltinFunctionLoader;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.Strings;
import net.thisptr.jackson.jq.path.Path;
import org.janelia.saalfeldlab.n5.Bzip2Compression;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.GzipCompression;
import org.janelia.saalfeldlab.n5.Lz4Compression;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.XzCompression;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.container.ContainerMetadataNode;
import org.janelia.saalfeldlab.n5.universe.metadata.ColorMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.IntColorMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.RGBAColorMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMultichannelMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMultiscaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalSpatialDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalSpatialMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.MultiChannelMetadataCanonical;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.MultiResolutionSpatialMetadataCanonical;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.SpatialMetadataCanonical;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.ParametrizedTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.SequenceSpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.SpatialTransform;
import org.janelia.saalfeldlab.n5.universe.translation.JqUtils;

public class CanonicalMetadataParser
implements N5MetadataParser<CanonicalMetadata> {
    protected Gson gson;
    protected ContainerMetadataNode root;
    protected Predicate<CanonicalMetadata> filter;

    public CanonicalMetadataParser() {
        this(x -> true);
    }

    public CanonicalMetadataParser(Predicate<CanonicalMetadata> filter) {
        this.filter = filter;
    }

    public void setFilter(Predicate<CanonicalMetadata> filter) {
        this.filter = filter;
    }

    @Deprecated
    public CanonicalMetadataParser(N5Reader n5, String n5Tree, String translation) {
        this.gson = JqUtils.buildGson(n5);
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    @Deprecated
    protected void setup(N5Reader n5) {
        this.setGson(JqUtils.buildGson(n5));
        this.root = ContainerMetadataNode.build(n5, this.gson);
        this.root.addPathsRecursive();
    }

    @Override
    public Optional<CanonicalMetadata> parseMetadata(N5Reader n5, N5TreeNode node) {
        String path = node.getPath();
        DatasetAttributes attrs = null;
        SpatialMetadataCanonical spatial = null;
        MultiResolutionSpatialMetadataCanonical multiscale = null;
        MultiChannelMetadataCanonical multichannel = null;
        CanonicalDatasetMetadata.IntensityLimits intensityLimits = null;
        ColorMetadata color = null;
        try {
            attrs = n5.getDatasetAttributes(path);
            spatial = n5.getAttribute(path, "spatialTransform", SpatialMetadataCanonical.class);
            multiscale = n5.getAttribute(path, "multiscales", MultiResolutionSpatialMetadataCanonical.class);
            multichannel = n5.getAttribute(path, "multichannel", MultiChannelMetadataCanonical.class);
            intensityLimits = n5.getAttribute(path, "intensityLimits", CanonicalDatasetMetadata.IntensityLimits.class);
            color = n5.getAttribute(path, "color", IntColorMetadata.class);
            if (color == null) {
                color = n5.getAttribute(path, "color", RGBAColorMetadata.class);
            }
        }
        catch (N5Exception n5Exception) {
            // empty catch block
        }
        if (spatial != null) {
            SpatialTransform transform = spatial.transform();
            if (transform instanceof ParametrizedTransform) {
                ParametrizedTransform pt = (ParametrizedTransform)((Object)transform);
                if (pt.getParameterPath() != null) {
                    pt.buildTransform(pt.getParameters(n5));
                }
            } else if (transform instanceof SequenceSpatialTransform) {
                SequenceSpatialTransform seq = (SequenceSpatialTransform)transform;
                for (SpatialTransform t : seq.getTransformations()) {
                    ParametrizedTransform pt;
                    if (!(t instanceof ParametrizedTransform) || (pt = (ParametrizedTransform)((Object)t)).getParameterPath() == null) continue;
                    pt.buildTransform(pt.getParameters(n5));
                }
            }
        }
        if (spatial == null && multichannel == null && multiscale == null && color == null && intensityLimits == null) {
            return Optional.empty();
        }
        if (attrs != null) {
            if (spatial != null) {
                return Optional.of(new CanonicalSpatialDatasetMetadata(path, spatial, attrs, intensityLimits, color));
            }
            return Optional.of(new CanonicalDatasetMetadata(path, attrs, intensityLimits, color));
        }
        if (spatial != null) {
            return Optional.of(new CanonicalSpatialMetadata(path, spatial, intensityLimits));
        }
        if (multiscale != null && multiscale.getChildrenMetadata() != null) {
            return Optional.of(new CanonicalMultiscaleMetadata(path, multiscale));
        }
        if (multichannel != null && multichannel.getPaths() != null) {
            return Optional.of(new CanonicalMultichannelMetadata(path, multichannel));
        }
        return Optional.empty();
    }

    @Deprecated
    public Optional<CanonicalMetadata> parseMetadata(String dataset, String groupSep) {
        return this.parseMetadata(new N5TreeNode(dataset), groupSep);
    }

    @Deprecated
    public Optional<CanonicalMetadata> parseMetadata(N5TreeNode node, String groupSep) {
        if (this.root == null) {
            return Optional.empty();
        }
        return this.root.getNode(node.getPath()).map(ContainerMetadataNode::getContainerAttributes).map(this::canonicalMetadata).filter(this.filter);
    }

    public CanonicalMetadata canonicalMetadata(HashMap<String, JsonElement> attrMap) {
        return this.gson.fromJson(this.gson.toJson(attrMap), CanonicalMetadata.class);
    }

    @Deprecated
    public static Scope buildRootScope() {
        Scope rootScope = Scope.newEmptyScope();
        BuiltinFunctionLoader.getInstance().loadFunctions(Versions.JQ_1_6, rootScope);
        rootScope.addFunction("repeat", 1, new Function(){

            public void apply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version) throws JsonQueryException {
                args.get(0).apply(scope, in, time -> output.emit((JsonNode)new TextNode(Strings.repeat((String)in.asText(), (int)time.asInt())), null));
            }
        });
        return rootScope;
    }

    public static Optional<DatasetAttributes> datasetAttributes(JsonDeserializationContext context, JsonElement elem) {
        try {
            Compression compression;
            long[] dimensions = (long[])context.deserialize(elem.getAsJsonObject().get("dimensions"), (Type)((Object)long[].class));
            if (dimensions == null) {
                return Optional.empty();
            }
            DataType dataType = (DataType)((Object)context.deserialize(elem.getAsJsonObject().get("dataType"), (Type)((Object)DataType.class)));
            if (dataType == null) {
                return Optional.empty();
            }
            int[] blockSize = (int[])context.deserialize(elem.getAsJsonObject().get("blockSize"), (Type)((Object)int[].class));
            if (blockSize == null) {
                blockSize = Arrays.stream(dimensions).mapToInt(a -> (int)a).toArray();
            }
            if ((compression = (Compression)context.deserialize(elem.getAsJsonObject().get("compression"), (Type)((Object)Compression.class))) == null) {
                String compressionString;
                switch (compressionString = (String)context.deserialize(elem.getAsJsonObject().get("compression"), (Type)((Object)String.class))) {
                    case "raw": {
                        compression = new RawCompression();
                        break;
                    }
                    case "gzip": {
                        compression = new GzipCompression();
                        break;
                    }
                    case "bzip2": {
                        compression = new Bzip2Compression();
                        break;
                    }
                    case "lz4": {
                        compression = new Lz4Compression();
                        break;
                    }
                    case "xz": {
                        compression = new XzCompression();
                    }
                }
            }
            return Optional.of(new DatasetAttributes(dimensions, blockSize, dataType, compression));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }
}

