/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.canonical;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Optional;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.universe.metadata.ColorMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.IntColorMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.RGBAColorMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.AbstractMetadataTemplateParser;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMultichannelMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMultiscaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalSpatialDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalSpatialMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.MultiChannelMetadataCanonical;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.MultiResolutionSpatialMetadataCanonical;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.SpatialMetadataCanonical;

public class CanonicalMetadataAdapter
implements JsonDeserializer<CanonicalMetadata> {
    @Override
    public CanonicalMetadata deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        String path = jsonObj.get("path").getAsString();
        Optional<DatasetAttributes> attrs = AbstractMetadataTemplateParser.datasetAttributes(context, json);
        SpatialMetadataCanonical spatial = null;
        if (jsonObj.has("spatialTransform")) {
            spatial = (SpatialMetadataCanonical)context.deserialize(jsonObj.get("spatialTransform"), (Type)((Object)SpatialMetadataCanonical.class));
        }
        MultiResolutionSpatialMetadataCanonical multiscale = null;
        if (jsonObj.has("multiscales")) {
            multiscale = (MultiResolutionSpatialMetadataCanonical)context.deserialize(jsonObj.get("multiscales"), (Type)((Object)MultiResolutionSpatialMetadataCanonical.class));
        }
        MultiChannelMetadataCanonical multichannel = null;
        if (jsonObj.has("multichannel")) {
            multichannel = (MultiChannelMetadataCanonical)context.deserialize(jsonObj.get("multichannel"), (Type)((Object)MultiChannelMetadataCanonical.class));
        }
        CanonicalDatasetMetadata.IntensityLimits intensityLimits = null;
        if (jsonObj.has("intensityLimits")) {
            intensityLimits = (CanonicalDatasetMetadata.IntensityLimits)context.deserialize(jsonObj.get("intensityLimits"), (Type)((Object)CanonicalDatasetMetadata.IntensityLimits.class));
        }
        ColorMetadata color = null;
        if (jsonObj.has("color")) {
            JsonObject colorObj = jsonObj.get("color").getAsJsonObject();
            color = colorObj.has("rgba") ? (ColorMetadata)context.deserialize(colorObj, (Type)((Object)IntColorMetadata.class)) : (ColorMetadata)context.deserialize(colorObj, (Type)((Object)RGBAColorMetadata.class));
        }
        if (spatial == null && multichannel == null && multiscale == null && color == null && intensityLimits == null) {
            return null;
        }
        if (attrs.isPresent()) {
            if (spatial != null) {
                return new CanonicalSpatialDatasetMetadata(path, spatial, attrs.get(), intensityLimits, color);
            }
            return new CanonicalDatasetMetadata(path, attrs.get(), intensityLimits, color);
        }
        if (spatial != null) {
            return new CanonicalSpatialMetadata(path, spatial, intensityLimits);
        }
        if (multiscale != null && multiscale.getChildrenMetadata() != null) {
            return new CanonicalMultiscaleMetadata(path, multiscale);
        }
        if (multichannel != null && multichannel.getPaths() != null) {
            return new CanonicalMultichannelMetadata(path, multichannel);
        }
        return null;
    }
}

