/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.axisTransforms;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.stream.IntStream;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.IndexedAxis;
import org.janelia.saalfeldlab.n5.universe.metadata.axisTransforms.TransformAxes;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.IdentitySpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.SpatialTransform;

public class TransformAxesMetadataAdapter
implements JsonDeserializer<TransformAxes> {
    @Override
    public TransformAxes deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        SpatialTransform transform = null;
        transform = jsonObj.has("transform") ? (SpatialTransform)context.deserialize(jsonObj.get("transform"), (Type)((Object)SpatialTransform.class)) : new IdentitySpatialTransform();
        IndexedAxis[] inputAxesParsed = null;
        if (jsonObj.has("inputAxes")) {
            inputAxesParsed = (IndexedAxis[])context.deserialize(jsonObj.get("inputAxes"), (Type)((Object)IndexedAxis[].class));
        }
        IndexedAxis[] outputAxesParsed = null;
        if (jsonObj.has("outputAxes")) {
            outputAxesParsed = (IndexedAxis[])context.deserialize(jsonObj.get("outputAxes"), (Type)((Object)IndexedAxis[].class));
        }
        int[] inIdxs = null;
        if (jsonObj.has("inputIndexes")) {
            inIdxs = (int[])context.deserialize(jsonObj.get("inputIndexes"), (Type)((Object)int[].class));
        }
        int[] outIdxs = null;
        if (jsonObj.has("outputIndexes")) {
            outIdxs = (int[])context.deserialize(jsonObj.get("outputIndexes"), (Type)((Object)int[].class));
        }
        String[] outputLabels = null;
        if (jsonObj.has("outputLabels")) {
            outputLabels = (String[])context.deserialize(jsonObj.get("outputLabels"), (Type)((Object)String[].class));
        }
        IndexedAxis[] inputAxes = TransformAxesMetadataAdapter.makeAxes(inputAxesParsed, "none", null, inIdxs);
        IndexedAxis[] outputAxes = TransformAxesMetadataAdapter.makeAxes(outputAxesParsed, "none", outputLabels, outIdxs);
        TransformAxes ta = new TransformAxes(transform, inputAxes, outputAxes);
        return ta;
    }

    private static IndexedAxis[] makeAxes(IndexedAxis[] axes, String unit, String[] axisLabels, int[] indexes) {
        if (axes != null) {
            return axes;
        }
        int N = 0;
        if (axisLabels != null) {
            N = axisLabels.length;
        } else if (indexes != null) {
            N = indexes.length;
        }
        if (N > 0) {
            IndexedAxis[] out = new IndexedAxis[N];
            for (int i = 0; i < N; ++i) {
                out[i] = new IndexedAxis(null, axisLabels != null ? axisLabels[i] : null, unit != null ? unit : null, indexes != null ? indexes[i] : -1);
            }
            return out;
        }
        return null;
    }

    private static IndexedAxis[] makeAxes(int N, IndexedAxis[] axes, String unit, String[] axisLabels, int[] indexes, boolean input) {
        IndexedAxis[] axesout;
        if (axes != null) {
            return axes;
        }
        if (axisLabels == null && indexes == null) {
            return null;
        }
        if (axisLabels != null) {
            axesout = indexes != null ? IndexedAxis.axesFromLabels(axisLabels, indexes, unit) : IndexedAxis.axesFromLabels(axisLabels, unit);
        } else if (indexes != null) {
            axesout = input ? IndexedAxis.dataAxes(indexes) : IndexedAxis.axesFromIndexes(indexes, unit);
        } else if (N > 0) {
            axesout = input ? IndexedAxis.dataAxes(N) : IndexedAxis.axesFromIndexes(IntStream.range(0, N).toArray(), unit);
        } else {
            return null;
        }
        return axesout;
    }
}

