/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.axes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.transform.integer.Mixed;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.universe.metadata.MetadataUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SpatialDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialModifiable;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.DefaultAxisMetadata;

public class AxisUtils {
    public static final String xLabel = "x";
    public static final String yLabel = "y";
    public static final String cLabel = "c";
    public static final String zLabel = "z";
    public static final String tLabel = "t";
    public static final String spaceType = "space";
    public static final String timeType = "time";
    public static final String channelType = "channel";
    public static final String unknownType = "unknown";
    public static final DefaultAxisTypes defaultAxisTypes = DefaultAxisTypes.getInstance();
    public static String SPACE_UNIT = "um";
    public static String TIME_UNIT = "s";

    public static <T> int[] findPermutation(T[] source, T[] target) {
        int[] p = new int[target.length];
        for (int i = 0; i < target.length; ++i) {
            T t = target[i];
            boolean found = false;
            for (int j = 0; j < source.length; ++j) {
                if (!source[j].equals(t)) continue;
                p[i] = j;
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return p;
    }

    public static <T> List<T> permute(List<T> in, int[] p) {
        ArrayList<T> out = new ArrayList<T>(p.length);
        for (int i = 0; i < p.length; ++i) {
            out.add(in.get(p[i]));
        }
        return out;
    }

    public static <T> void permute(T[] in, T[] dest, int[] p) {
        int i;
        ArrayList<T> tmp = new ArrayList<T>(in.length);
        for (i = 0; i < in.length; ++i) {
            tmp.add(in[i]);
        }
        for (i = 0; i < p.length; ++i) {
            dest[i] = tmp.get(p[i]);
        }
    }

    public static long[] permute(long[] in, int[] p) {
        long[] out = new long[p.length];
        for (int i = 0; i < p.length; ++i) {
            out[i] = in[p[i]];
        }
        return out;
    }

    public static int[] permute(int[] in, int[] p) {
        int[] out = new int[p.length];
        for (int i = 0; i < p.length; ++i) {
            out[i] = in[p[i]];
        }
        return out;
    }

    public static double[] permute(double[] in, int[] p) {
        double[] out = new double[p.length];
        for (int i = 0; i < p.length; ++i) {
            out[i] = in[p[i]];
        }
        return out;
    }

    public static Axis[] buildAxes(String ... labels) {
        return (Axis[])Arrays.stream(labels).map(x -> {
            String type = AxisUtils.getDefaultType(x);
            return new Axis((String)x, type, "", type.equals(channelType));
        }).toArray(Axis[]::new);
    }

    public static <A extends AxisMetadata> int[] findImagePlusPermutation(AxisMetadata axisMetadata) {
        return AxisUtils.findImagePlusPermutation(axisMetadata.getAxisLabels());
    }

    public static int[] findImagePlusPermutation(String[] axisLabels) {
        int[] p = new int[]{AxisUtils.indexOf(axisLabels, xLabel), AxisUtils.indexOf(axisLabels, yLabel), AxisUtils.indexOf(axisLabels, cLabel), AxisUtils.indexOf(axisLabels, zLabel), AxisUtils.indexOf(axisLabels, tLabel)};
        return p;
    }

    public static int[] findImagePlusSpatialPermutation(int[] p) {
        OptionalInt minOpt = Arrays.stream(p).min();
        if (minOpt.isPresent()) {
            int min = minOpt.getAsInt();
            return Arrays.stream(p).map(x -> x - min).toArray();
        }
        return p;
    }

    public static int[] normalizeIndexes(int[] indexes) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i : indexes) {
            set.add(i);
        }
        int[] sortedUniqueIndexes = new int[set.size()];
        Iterator it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            sortedUniqueIndexes[i++] = (Integer)it.next();
        }
        int[] out = new int[indexes.length];
        for (i = 0; i < out.length; ++i) {
            out[i] = Arrays.binarySearch(sortedUniqueIndexes, indexes[i]);
        }
        return out;
    }

    public static void fillPermutation(int[] p) {
        int j = Arrays.stream(p).max().getAsInt() + 1;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] >= 0) continue;
            p[i] = j++;
        }
    }

    public static AffineGet axisPermutationTransform(int[] p) {
        int N = p.length;
        int[] normalP = AxisUtils.normalizeIndexes(p);
        double[] affineParams = new double[N * (N + 1)];
        for (int i = 0; i < normalP.length; ++i) {
            affineParams[normalP[i] + (N + 1) * i] = 1.0;
        }
        return new AffineTransform(affineParams);
    }

    public static boolean isIdentityPermutation(int[] p) {
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == i) continue;
            return false;
        }
        return true;
    }

    public static <T, M extends AxisMetadata & N5Metadata> RandomAccessibleInterval<T> permuteForImagePlus(RandomAccessibleInterval<T> img, M meta) {
        int[] p = AxisUtils.findImagePlusPermutation(meta);
        AxisUtils.fillPermutation(p);
        IntervalView imgTmp = img;
        while (imgTmp.numDimensions() < 5) {
            imgTmp = Views.addDimension(imgTmp, (long)0L, (long)0L);
        }
        if (AxisUtils.isIdentityPermutation(p)) {
            return imgTmp;
        }
        return AxisUtils.permute(imgTmp, AxisUtils.invertPermutation(p));
    }

    public static <M extends AxisMetadata & N5Metadata> M permuteForImagePlus(int[] spatialPermutation, M meta) {
        if (AxisUtils.isIdentityPermutation(spatialPermutation)) {
            return meta;
        }
        if (meta instanceof SpatialMetadata && meta instanceof SpatialModifiable) {
            AffineTransform3D tform = ((SpatialMetadata)meta).spatialTransform3d().copy();
            AffineTransform3D tformInv = ((SpatialMetadata)meta).spatialTransform3d().inverse().copy();
            AffineGet permTform = AxisUtils.axisPermutationTransform(spatialPermutation);
            tform.concatenate(permTform).preConcatenate(permTform.inverse());
            tform.concatenate(tformInv);
            AxisMetadata out = (AxisMetadata)((SpatialModifiable)meta).modifySpatialTransform(((N5Metadata)meta).getPath(), (AffineGet)tform);
            return (M)out;
        }
        return meta;
    }

    public static <T, M extends N5Metadata, A extends AxisMetadata & N5Metadata> Pair<RandomAccessibleInterval<T>, M> permuteImageAndMetadataForImagePlus(RandomAccessibleInterval<T> img, M meta) {
        if (meta != null && meta instanceof AxisMetadata) {
            int[] p = AxisUtils.findImagePlusPermutation((AxisMetadata)((Object)meta));
            AxisUtils.fillPermutation(p);
            IntervalView imgTmp = img;
            while (imgTmp.numDimensions() < 5) {
                imgTmp = Views.addDimension(imgTmp, (long)0L, (long)0L);
            }
            if (AxisUtils.isIdentityPermutation(p)) {
                return new ValuePair((Object)imgTmp, meta);
            }
            IntervalView<T> imgOut = AxisUtils.permute(imgTmp, AxisUtils.invertPermutation(p));
            int[] spatialPermutation = new int[]{p[0], p[1], p[3]};
            N5Metadata permutedMeta = (N5Metadata)((Object)AxisUtils.permuteForImagePlus(spatialPermutation, (AxisMetadata)((Object)meta)));
            return new ValuePair(imgOut, (Object)permutedMeta);
        }
        return new ValuePair(img, meta);
    }

    public static <T, M extends N5Metadata, A extends AxisMetadata & N5Metadata> Pair<RandomAccessibleInterval<T>, M> permuteImageAndMetadataForImagePlus(int[] p, RandomAccessibleInterval<T> img, M meta) {
        M datasetMeta;
        IntervalView<T> imgOut;
        int[] metadataPermutation = Arrays.stream(p).filter(x -> x >= 0).toArray();
        AxisUtils.fillPermutation(p);
        IntervalView<T> imgTmp = img;
        while (imgTmp.numDimensions() < 5) {
            imgTmp = Views.addDimension(imgTmp, (long)0L, (long)0L);
        }
        if (AxisUtils.isIdentityPermutation(p)) {
            imgOut = imgTmp;
            datasetMeta = meta;
        } else {
            imgOut = AxisUtils.permute(imgTmp, AxisUtils.invertPermutation(p));
            datasetMeta = MetadataUtils.permuteSpatialMetadata(meta, metadataPermutation);
        }
        return new ValuePair(imgOut, datasetMeta);
    }

    public static <T> RandomAccessibleInterval<T> reverseDimensions(RandomAccessibleInterval<T> img) {
        int nd = img.numDimensions();
        int[] p = IntStream.iterate(nd - 1, x -> x - 1).limit(nd).toArray();
        return AxisUtils.permute(img, p);
    }

    private static final <T> int indexOf(T[] arr, T tgt) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(tgt)) continue;
            return i;
        }
        return -1;
    }

    public static final <T> IntervalView<T> permute(RandomAccessibleInterval<T> source, int[] p) {
        int n = source.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        for (int i = 0; i < n; ++i) {
            min[p[i]] = source.min(i);
            max[p[i]] = source.max(i);
        }
        MixedTransform t = new MixedTransform(n, n);
        t.setComponentMapping(p);
        IntervalView out = Views.interval((RandomAccessible)new MixedTransformView(source, (Mixed)t), (long[])min, (long[])max);
        return out;
    }

    public static int[] invertPermutation(int[] p) {
        int[] inv = new int[p.length];
        for (int i = 0; i < p.length; ++i) {
            inv[p[i]] = i;
        }
        return inv;
    }

    public static int[] indexes(Axis[] axes, Predicate<Axis> predicate) {
        return IntStream.range(0, axes.length).filter(i -> predicate.test(axes[i])).toArray();
    }

    public static Axis[] defaultAxes(int N) {
        return (Axis[])IntStream.range(0, N).mapToObj(i -> AxisUtils.defaultAxis(AxisUtils.defaultLabel(i))).toArray(Axis[]::new);
    }

    public static Axis[] defaultAxes(String ... labels) {
        Axis[] axes = new Axis[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            axes[i] = AxisUtils.defaultAxis(labels[i]);
        }
        return axes;
    }

    public static Axis defaultAxis(String label) {
        String type = AxisUtils.getDefaultType(label);
        return new Axis(type, label, AxisUtils.getDefaultUnit(type));
    }

    public static Axis unknownAxis() {
        return new Axis(unknownType, "", "");
    }

    public static DefaultAxisMetadata defaultN5ViewerAxes(N5SpatialDatasetMetadata meta) {
        String[] labels;
        int nd = meta.getAttributes().getNumDimensions();
        if (nd == 2) {
            labels = new String[]{xLabel, yLabel};
        } else if (nd == 3) {
            labels = new String[]{xLabel, yLabel, zLabel};
        } else if (nd == 4) {
            labels = new String[]{xLabel, yLabel, zLabel, tLabel};
        } else {
            return null;
        }
        String[] types = AxisUtils.getDefaultTypes(labels);
        String[] units = (String[])Stream.generate(() -> meta.unit()).limit(nd).toArray(String[]::new);
        return new DefaultAxisMetadata(meta.getPath(), labels, types, units);
    }

    public static String[] getDefaultTypes(String[] labels) {
        return (String[])Arrays.stream(labels).map(l -> defaultAxisTypes.get((String)l)).toArray(String[]::new);
    }

    public static String getDefaultType(String label) {
        return defaultAxisTypes.get(label);
    }

    public static String getDefaultUnit(String type) {
        if (type.equals(spaceType)) {
            return SPACE_UNIT;
        }
        if (type.equals(timeType)) {
            return TIME_UNIT;
        }
        return "";
    }

    public static String defaultLabel(int i) {
        if (i == 0) {
            return xLabel;
        }
        if (i == 1) {
            return yLabel;
        }
        if (i == 2) {
            return cLabel;
        }
        if (i == 3) {
            return zLabel;
        }
        if (i == 4) {
            return tLabel;
        }
        return String.format("dim_%d", i);
    }

    public static <T> boolean containsAny(Set<T> set, T[] array) {
        for (T t : array) {
            if (!set.contains(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T t, T[] array) {
        return Arrays.stream(array).anyMatch(x -> x.equals(t));
    }

    public static class DefaultAxisTypes {
        private static DefaultAxisTypes INSTANCE;
        private final HashMap<String, String> labelToType = new HashMap();

        private DefaultAxisTypes() {
            this.labelToType.put(AxisUtils.xLabel, AxisUtils.spaceType);
            this.labelToType.put(AxisUtils.yLabel, AxisUtils.spaceType);
            this.labelToType.put(AxisUtils.zLabel, AxisUtils.spaceType);
            this.labelToType.put(AxisUtils.cLabel, AxisUtils.channelType);
            this.labelToType.put(AxisUtils.tLabel, AxisUtils.timeType);
            this.labelToType.put("X", AxisUtils.spaceType);
            this.labelToType.put("Y", AxisUtils.spaceType);
            this.labelToType.put("Z", AxisUtils.spaceType);
            this.labelToType.put("C", AxisUtils.channelType);
            this.labelToType.put("T", AxisUtils.timeType);
        }

        public static final DefaultAxisTypes getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new DefaultAxisTypes();
            }
            return INSTANCE;
        }

        public String get(String label) {
            if (this.labelToType.containsKey(label)) {
                return this.labelToType.get(label);
            }
            if (label.toLowerCase().startsWith("data")) {
                return "data";
            }
            return AxisUtils.unknownType;
        }
    }
}

