/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import net.imglib2.realtransform.AffineTransform3D;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.imglib2.N5LabelMultisets;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.IntensityMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DefaultSingleScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadataParser;

public class N5GenericSingleScaleMetadataParser
implements N5MetadataParser<N5SingleScaleMetadata> {
    public static final String DEFAULT_MIN = "min";
    public static final String DEFAULT_MAX = "max";
    public static final String DEFAULT_RESOLUTION = "resolution";
    public static final String DEFAULT_OFFSET = "offset";
    public static final String DEFAULT_UNIT = "unit";
    public static final String DEFAULT_DOWNSAMPLING_FACTORS = "downsamplingFactors";
    public final String minKey;
    public final String maxKey;
    public final String resolutionKey;
    public final String offsetKey;
    public final String unitKey;
    public final String downsamplingFactorsKey;
    public boolean minKeyStrict = false;
    public boolean maxKeyStrict = false;
    public boolean resolutionKeyStrict = false;
    public boolean offsetKeyStrict = false;
    public boolean unitKeyStrict = false;
    public boolean downsamplingFactorsKeyStrict = false;
    private boolean allDefault;

    public N5GenericSingleScaleMetadataParser() {
        this.minKey = DEFAULT_MIN;
        this.maxKey = DEFAULT_MAX;
        this.resolutionKey = DEFAULT_RESOLUTION;
        this.offsetKey = DEFAULT_OFFSET;
        this.unitKey = DEFAULT_UNIT;
        this.downsamplingFactorsKey = DEFAULT_DOWNSAMPLING_FACTORS;
    }

    public N5GenericSingleScaleMetadataParser(String minKey, String maxKey, String resolutionKey, String offsetKey, String unitKey, String downsamplingFactorsKey) {
        this.minKey = minKey;
        this.maxKey = maxKey;
        this.resolutionKey = resolutionKey;
        this.offsetKey = offsetKey;
        this.unitKey = unitKey;
        this.downsamplingFactorsKey = downsamplingFactorsKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(boolean useDefaults) {
        Builder builder = new Builder();
        if (useDefaults) {
            builder.minKey = DEFAULT_MIN;
            builder.maxKey = DEFAULT_MAX;
            builder.resolutionKey = DEFAULT_RESOLUTION;
            builder.offsetKey = DEFAULT_OFFSET;
            builder.downsamplingFactorsKey = DEFAULT_DOWNSAMPLING_FACTORS;
            builder.unitKey = DEFAULT_UNIT;
        }
        return builder;
    }

    @Override
    public Optional<N5SingleScaleMetadata> parseMetadata(N5Reader n5, N5TreeNode node) {
        this.allDefault = true;
        try {
            int i;
            int N;
            DatasetAttributes attributes = n5.getDatasetAttributes(node.getPath());
            if (attributes == null) {
                return Optional.empty();
            }
            int nd = attributes.getNumDimensions();
            String path = node.getPath();
            double[] resolution = this.getAttribute(n5, path, this.resolutionKey, double[].class, this.resolutionKeyStrict, x -> ((double[])x).length == nd, () -> DoubleStream.generate(() -> 1.0).limit(nd).toArray());
            double[] downsamplingFactors = this.getAttribute(n5, path, this.downsamplingFactorsKey, double[].class, this.downsamplingFactorsKeyStrict, x -> ((double[])x).length == nd, () -> DoubleStream.generate(() -> 1.0).limit(nd).toArray());
            String unit = this.getAttribute(n5, path, this.unitKey, String.class, this.unitKeyStrict, x -> true, () -> "pixel");
            double min = this.getAttribute(n5, path, this.minKey, Double.TYPE, this.minKeyStrict, x -> true, () -> 0.0);
            double max = this.getAttribute(n5, path, this.maxKey, Double.TYPE, this.maxKeyStrict, x -> true, () -> IntensityMetadata.maxForDataType(attributes.getDataType()));
            Boolean isLabelMultiset = N5LabelMultisets.isLabelMultisetType((N5Reader)n5, (String)node.getPath());
            AffineTransform3D transform = N5SingleScaleMetadataParser.buildTransform(downsamplingFactors, resolution, Optional.empty());
            double[] offset = this.getAttribute(n5, path, this.offsetKey, double[].class, this.offsetKeyStrict, x -> ((double[])x).length == nd, () -> DoubleStream.generate(() -> Double.NaN).limit(nd).toArray());
            int n = N = nd > 3 ? 3 : nd;
            if (Double.isNaN(offset[0])) {
                for (i = 0; i < N; ++i) {
                    offset[i] = transform.get(i, 3);
                }
            } else {
                for (i = 0; i < N; ++i) {
                    transform.set(offset[i], i, 3);
                }
            }
            N5SingleScaleMetadata metadata = this.allDefault ? new N5DefaultSingleScaleMetadata(path, transform, downsamplingFactors, resolution, offset, unit, attributes, min, max, isLabelMultiset) : new N5SingleScaleMetadata(path, transform, downsamplingFactors, resolution, offset, unit, attributes, min, max, isLabelMultiset);
            return Optional.of(metadata);
        }
        catch (N5Exception e) {
            return Optional.empty();
        }
    }

    private static <T> Optional<T> getAttributeOptional(N5Reader n5, String path, String key, Class<T> clazz) {
        try {
            return Optional.ofNullable(n5.getAttribute(path, key, clazz));
        }
        catch (N5Exception e) {
            return Optional.empty();
        }
    }

    private <T> T getAttribute(N5Reader n5, String path, String key, Class<T> clazz, boolean strict, Predicate<T> filter, Supplier<T> defaultValue) {
        return (T)N5GenericSingleScaleMetadataParser.getAttributeOptional(n5, path, key, clazz).filter(filter).map(x -> {
            this.allDefault = false;
            return x;
        }).orElseGet(() -> {
            if (strict) {
                throw new N5Exception("Missing or invalid attribute for key: " + key);
            }
            return defaultValue.get();
        });
    }

    public static class Builder {
        private String minKey = "";
        private String maxKey = "";
        private String resolutionKey = "";
        private String offsetKey = "";
        private String downsamplingFactorsKey = "";
        private String unitKey = "";
        private boolean minStrict = false;
        private boolean maxStrict = false;
        private boolean resolutionStrict = false;
        private boolean offsetStrict = false;
        private boolean unitStrict = false;
        private boolean downsamplingFactorsStrict = false;

        public Builder min(String key) {
            this.minKey = key;
            return this;
        }

        public Builder max(String key) {
            this.maxKey = key;
            return this;
        }

        public Builder resolution(String key) {
            this.resolutionKey = key;
            return this;
        }

        public Builder offset(String key) {
            this.offsetKey = key;
            return this;
        }

        public Builder unit(String key) {
            this.unitKey = key;
            return this;
        }

        public Builder downsamplingFactors(String key) {
            this.downsamplingFactorsKey = key;
            return this;
        }

        public Builder resolutionStrict() {
            this.resolutionStrict = true;
            return this;
        }

        public Builder downsamplingFactorsStrict() {
            this.downsamplingFactorsStrict = true;
            return this;
        }

        public Builder offsetStrict() {
            this.offsetStrict = true;
            return this;
        }

        public Builder minStrict() {
            this.minStrict = true;
            return this;
        }

        public Builder maxStrict() {
            this.maxStrict = true;
            return this;
        }

        public Builder unitStrict() {
            this.unitStrict = true;
            return this;
        }

        public N5GenericSingleScaleMetadataParser build() {
            N5GenericSingleScaleMetadataParser p = new N5GenericSingleScaleMetadataParser(this.minKey, this.maxKey, this.resolutionKey, this.offsetKey, this.unitKey, this.downsamplingFactorsKey);
            p.resolutionKeyStrict = this.resolutionStrict;
            p.downsamplingFactorsKeyStrict = this.downsamplingFactorsStrict;
            p.offsetKeyStrict = this.offsetStrict;
            p.unitKeyStrict = this.unitStrict;
            p.minKeyStrict = this.minStrict;
            p.maxKeyStrict = this.maxStrict;
            return p;
        }
    }
}

