/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.google.cloud.storage.Storage;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import org.apache.commons.lang3.function.TriFunction;
import org.janelia.saalfeldlab.googlecloud.GoogleCloudStorageURI;
import org.janelia.saalfeldlab.googlecloud.GoogleCloudUtils;
import org.janelia.saalfeldlab.n5.FileSystemKeyValueAccess;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5KeyValueReader;
import org.janelia.saalfeldlab.n5.N5KeyValueWriter;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.googlecloud.GoogleCloudStorageKeyValueAccess;
import org.janelia.saalfeldlab.n5.hdf5.HDF5Utils;
import org.janelia.saalfeldlab.n5.hdf5.N5HDF5Reader;
import org.janelia.saalfeldlab.n5.hdf5.N5HDF5Writer;
import org.janelia.saalfeldlab.n5.s3.AmazonS3KeyValueAccess;
import org.janelia.saalfeldlab.n5.s3.AmazonS3Utils;
import org.janelia.saalfeldlab.n5.zarr.ZarrKeyValueReader;
import org.janelia.saalfeldlab.n5.zarr.ZarrKeyValueWriter;

public class N5Factory
implements Serializable {
    private static final N5Factory FACTORY = new N5Factory();
    private static final long serialVersionUID = -6823715427289454617L;
    private static final Pattern HTTPS_SCHEME = Pattern.compile("http(s)?", 2);
    private static final Pattern FILE_SCHEME = Pattern.compile("file", 2);
    private int[] hdf5DefaultBlockSize = new int[]{64, 64, 64, 1, 1};
    private boolean hdf5OverrideBlockSize = false;
    private GsonBuilder gsonBuilder = new GsonBuilder();
    private boolean cacheAttributes = true;
    private String zarrDimensionSeparator = ".";
    private boolean zarrMapN5DatasetAttributes = true;
    private boolean zarrMergeAttributes = true;
    private String googleCloudProjectId = null;
    private String s3Region = null;
    private AWSCredentials s3Credentials = null;
    private ClientConfiguration s3ClientConfiguration = null;
    private boolean s3Anonymous = true;
    private String s3Endpoint;

    private static GoogleCloudStorageKeyValueAccess newGoogleCloudKeyValueAccess(URI uri, N5Factory factory) {
        GoogleCloudStorageURI googleCloudUri = new GoogleCloudStorageURI(uri);
        return new GoogleCloudStorageKeyValueAccess(factory.createGoogleCloudStorage(), googleCloudUri, true);
    }

    private static AmazonS3KeyValueAccess newAmazonS3KeyValueAccess(URI uri, N5Factory factory) {
        String uriString = uri.toString();
        AmazonS3 s3 = factory.createS3(uriString);
        return new AmazonS3KeyValueAccess(s3, uri, true);
    }

    private static FileSystemKeyValueAccess newFileSystemKeyValueAccess(URI uri, N5Factory factory) {
        return new FileSystemKeyValueAccess(FileSystems.getDefault());
    }

    public N5Factory hdf5DefaultBlockSize(int ... blockSize) {
        this.hdf5DefaultBlockSize = blockSize;
        return this;
    }

    public N5Factory hdf5OverrideBlockSize(boolean override) {
        this.hdf5OverrideBlockSize = override;
        return this;
    }

    public N5Factory gsonBuilder(GsonBuilder gsonBuilder) {
        this.gsonBuilder = gsonBuilder;
        return this;
    }

    public N5Factory cacheAttributes(boolean cacheAttributes) {
        this.cacheAttributes = cacheAttributes;
        return this;
    }

    public N5Factory zarrDimensionSeparator(String separator) {
        this.zarrDimensionSeparator = separator;
        return this;
    }

    public N5Factory zarrMapN5Attributes(boolean mapAttributes) {
        this.zarrMapN5DatasetAttributes = mapAttributes;
        return this;
    }

    public N5Factory zarrMergeAttributes(boolean mergeAttributes) {
        this.zarrMergeAttributes = mergeAttributes;
        return this;
    }

    public N5Factory googleCloudProjectId(String projectId) {
        this.googleCloudProjectId = projectId;
        return this;
    }

    public N5Factory s3UseCredentials() {
        this.s3Anonymous = false;
        return this;
    }

    public N5Factory s3UseCredentials(AWSCredentials credentials) {
        this.s3Credentials = credentials;
        return this;
    }

    public N5Factory s3ClientConfiguration(ClientConfiguration clientConfiguration) {
        this.s3ClientConfiguration = clientConfiguration;
        return this;
    }

    @Deprecated
    public N5Factory s3RetryWithCredentials() {
        return this;
    }

    public N5Factory s3Endpoint(String s3Endpoint) {
        this.s3Endpoint = s3Endpoint;
        return this;
    }

    public N5Factory s3Region(String s3Region) {
        this.s3Region = s3Region;
        return this;
    }

    AmazonS3 createS3(String uri) {
        try {
            return AmazonS3Utils.createS3((String)uri, (String)this.s3Endpoint, (AWSCredentialsProvider)AmazonS3Utils.getS3Credentials((AWSCredentials)this.s3Credentials, (boolean)this.s3Anonymous), (ClientConfiguration)this.s3ClientConfiguration, (String)this.s3Region);
        }
        catch (Throwable e) {
            throw new N5Exception("Could not create s3 client from uri: " + uri, e);
        }
    }

    Storage createGoogleCloudStorage() {
        return GoogleCloudUtils.createGoogleCloudStorage((String)this.googleCloudProjectId);
    }

    @Nullable
    KeyValueAccess getKeyValueAccess(URI uri) {
        for (KeyValueAccessBackend backend : KeyValueAccessBackend.values()) {
            KeyValueAccess kva = backend.apply(uri, this);
            if (kva == null) continue;
            return kva;
        }
        return null;
    }

    @Deprecated
    public N5Reader openFSReader(String path) {
        return this.openN5ContainerWithStorageFormat(StorageFormat.N5, path, this::openReader);
    }

    @Deprecated
    public N5Reader openZarrReader(String path) {
        return this.openN5ContainerWithStorageFormat(StorageFormat.ZARR, path, this::openReader);
    }

    @Deprecated
    public N5Reader openHDF5Reader(String path) {
        return this.openN5ContainerWithStorageFormat(StorageFormat.HDF5, path, (format, uri) -> this.openReader((StorageFormat)((Object)format), null, uri.getPath()));
    }

    public N5Reader openGoogleCloudReader(String uri) throws URISyntaxException {
        return this.openN5ContainerWithBackend(KeyValueAccessBackend.GOOGLE_CLOUD, uri, this::openReader);
    }

    public N5Reader openAWSS3Reader(String uri) throws URISyntaxException {
        return this.openN5ContainerWithBackend(KeyValueAccessBackend.AWS, uri, this::openReader);
    }

    public N5Reader openFileSystemReader(String uri) throws URISyntaxException {
        return this.openN5ContainerWithBackend(KeyValueAccessBackend.FILE, uri, this::openReader);
    }

    public N5Reader openReader(StorageFormat format, String uri) {
        return this.openN5Container(format, N5Factory.parseUriFromString(uri), this::openReader);
    }

    public N5Reader openReader(StorageFormat format, URI uri) {
        return this.openN5Container(format, uri, this::openReader);
    }

    public N5Reader openReader(String uri) {
        return this.openN5Container(uri, this::openReader, this::openReader);
    }

    private N5Reader openReader(@Nullable StorageFormat storage, @Nullable KeyValueAccess access, String containerPath) {
        if (storage == null) {
            for (StorageFormat format : StorageFormat.values()) {
                try {
                    return this.openReader(format, access, containerPath);
                }
                catch (Throwable throwable) {
                }
            }
            throw new N5Exception("Unable to open " + containerPath + " as N5Reader");
        }
        switch (storage) {
            case N5: {
                return new N5KeyValueReader(access, containerPath, this.gsonBuilder, this.cacheAttributes);
            }
            case ZARR: {
                return new ZarrKeyValueReader(access, containerPath, this.gsonBuilder, this.zarrMapN5DatasetAttributes, this.zarrMergeAttributes, this.cacheAttributes);
            }
            case HDF5: {
                return new N5HDF5Reader(containerPath, this.hdf5OverrideBlockSize, this.gsonBuilder, this.hdf5DefaultBlockSize);
            }
        }
        return null;
    }

    @Deprecated
    public N5Writer openFSWriter(String path) {
        return this.openN5ContainerWithStorageFormat(StorageFormat.N5, path, this::openWriter);
    }

    @Deprecated
    public N5Writer openZarrWriter(String path) {
        return this.openN5ContainerWithStorageFormat(StorageFormat.ZARR, path, this::openWriter);
    }

    @Deprecated
    public N5Writer openHDF5Writer(String path) {
        return this.openN5ContainerWithStorageFormat(StorageFormat.HDF5, path, (format, uri) -> this.openWriter((StorageFormat)((Object)format), null, uri.getPath()));
    }

    public N5Writer openGoogleCloudWriter(String uri) throws URISyntaxException {
        return (N5Writer)this.openN5ContainerWithBackend(KeyValueAccessBackend.GOOGLE_CLOUD, uri, this::openWriter);
    }

    public N5Writer openAWSS3Writer(String uri) throws URISyntaxException {
        return (N5Writer)this.openN5ContainerWithBackend(KeyValueAccessBackend.AWS, uri, this::openWriter);
    }

    public N5Writer openWriter(StorageFormat format, String uri) {
        return (N5Writer)this.openN5Container(format, N5Factory.parseUriFromString(uri), this::openWriter);
    }

    public N5Writer openWriter(StorageFormat format, URI uri) {
        return (N5Writer)this.openN5Container(format, uri, this::openWriter);
    }

    public N5Writer openWriter(String uri) {
        return this.openN5Container(uri, this::openWriter, this::openWriter);
    }

    private N5Writer openWriter(@Nullable StorageFormat storage, @Nullable KeyValueAccess access, String containerPath) {
        if (storage == null) {
            for (StorageFormat format : StorageFormat.values()) {
                try {
                    return this.openWriter(format, access, containerPath);
                }
                catch (Throwable throwable) {
                }
            }
            throw new N5Exception("Unable to open " + containerPath + " as N5Writer");
        }
        switch (storage) {
            case ZARR: {
                return new ZarrKeyValueWriter(access, containerPath, this.gsonBuilder, this.zarrMapN5DatasetAttributes, this.zarrMergeAttributes, this.zarrDimensionSeparator, this.cacheAttributes);
            }
            case N5: {
                return new N5KeyValueWriter(access, containerPath, this.gsonBuilder, this.cacheAttributes);
            }
            case HDF5: {
                return new N5HDF5Writer(containerPath, this.hdf5OverrideBlockSize, this.gsonBuilder, this.hdf5DefaultBlockSize);
            }
        }
        return null;
    }

    private <T extends N5Reader> T openN5ContainerWithStorageFormat(StorageFormat format, String uri, BiFunction<StorageFormat, URI, T> openWithFormat) {
        try {
            URI asUri = (URI)StorageFormat.parseUri(uri).getB();
            return (T)((N5Reader)openWithFormat.apply(format, asUri));
        }
        catch (URISyntaxException e) {
            throw new N5Exception("Cannot create N5 Container (" + (Object)((Object)format) + ") at " + uri, e);
        }
    }

    private <T extends N5Reader> T openN5ContainerWithBackend(KeyValueAccessBackend backend, String containerUri, TriFunction<StorageFormat, KeyValueAccess, String, T> openWithBackend) throws URISyntaxException {
        Pair<StorageFormat, URI> formatAndUri = StorageFormat.parseUri(containerUri);
        URI uri = (URI)formatAndUri.getB();
        KeyValueAccess kva = backend.apply(uri, this);
        return (T)((N5Reader)openWithBackend.apply(formatAndUri.getA(), (Object)kva, (Object)uri.toString()));
    }

    private <T extends N5Reader> T openN5Container(StorageFormat storageFormat, URI uri, TriFunction<StorageFormat, KeyValueAccess, String, T> openWithKva) {
        KeyValueAccess kva = this.getKeyValueAccess(uri);
        if (kva == null) {
            throw new N5Exception("Cannot get KeyValueAccess at " + uri);
        }
        return (T)((N5Reader)openWithKva.apply((Object)storageFormat, (Object)kva, (Object)uri.toString()));
    }

    private <T extends N5Reader> T openN5Container(String containerUri, BiFunction<StorageFormat, URI, T> openWithFormat, TriFunction<StorageFormat, KeyValueAccess, String, T> openWithKva) {
        Pair<StorageFormat, URI> storageAndUri;
        try {
            storageAndUri = StorageFormat.parseUri(containerUri);
        }
        catch (URISyntaxException e) {
            throw new N5Exception("Unable to open " + containerUri + " as N5 Container", e);
        }
        StorageFormat format = (StorageFormat)((Object)storageAndUri.getA());
        URI uri = (URI)storageAndUri.getB();
        if (format != null) {
            return (T)((N5Reader)openWithFormat.apply(format, uri));
        }
        return this.openN5Container(null, uri, openWithKva);
    }

    public static N5Writer createWriter(String containerUri) {
        return FACTORY.openWriter(containerUri);
    }

    public static N5Reader createReader(String containerUri) {
        return FACTORY.openReader(containerUri);
    }

    private static URI parseUriFromString(String uri) {
        try {
            return URI.create(uri);
        }
        catch (Throwable throwable) {
            try {
                return Paths.get(uri, new String[0]).toUri();
            }
            catch (Throwable throwable2) {
                try {
                    return N5URI.encodeAsUri(uri);
                }
                catch (URISyntaxException e) {
                    throw new N5Exception(e);
                }
            }
        }
    }

    public static enum StorageFormat {
        ZARR(Pattern.compile("zarr", 2), uri -> Pattern.compile("\\.zarr$", 2).matcher(new File(uri.getPath()).toString()).find()),
        N5(Pattern.compile("n5", 2), uri -> Pattern.compile("\\.n5$", 2).matcher(new File(uri.getPath()).toString()).find()),
        HDF5(Pattern.compile("h(df)?5", 2), uri -> {
            boolean hasHdf5Extension = Pattern.compile("\\.h(df)?5$", 2).matcher(uri.getPath()).find();
            return hasHdf5Extension || HDF5Utils.isHDF5((String)uri.getPath());
        });

        static final Pattern STORAGE_SCHEME_PATTERN;
        private static final String STORAGE_SCHEME_GROUP = "storageScheme";
        private static final String URI_GROUP = "uri";
        final Pattern schemePattern;
        private final Predicate<URI> uriTest;

        private StorageFormat(Pattern schemePattern, Predicate<URI> test) {
            this.schemePattern = schemePattern;
            this.uriTest = test;
        }

        public static StorageFormat guessStorageFromUri(URI uri) {
            for (StorageFormat format : StorageFormat.values()) {
                if (!format.uriTest.test(uri)) continue;
                return format;
            }
            return null;
        }

        public static Pair<StorageFormat, URI> parseUri(String uri) throws URISyntaxException {
            Pair<StorageFormat, String> storageFromScheme = StorageFormat.getStorageFromNestedScheme(uri);
            URI asUri = N5Factory.parseUriFromString((String)storageFromScheme.getB());
            if (storageFromScheme.getA() != null) {
                return new ValuePair(storageFromScheme.getA(), (Object)asUri);
            }
            return new ValuePair((Object)StorageFormat.guessStorageFromUri(asUri), (Object)asUri);
        }

        public static Pair<StorageFormat, String> getStorageFromNestedScheme(String uri) {
            Matcher storageSchemeMatcher = STORAGE_SCHEME_PATTERN.matcher(uri);
            storageSchemeMatcher.matches();
            String storageFormatScheme = storageSchemeMatcher.group(STORAGE_SCHEME_GROUP);
            String uriGroup = storageSchemeMatcher.group(URI_GROUP);
            if (storageFormatScheme != null) {
                for (StorageFormat format : StorageFormat.values()) {
                    if (!format.schemePattern.asPredicate().test(storageFormatScheme)) continue;
                    return new ValuePair((Object)format, (Object)uriGroup);
                }
            }
            return new ValuePair(null, (Object)uriGroup);
        }

        static {
            STORAGE_SCHEME_PATTERN = Pattern.compile("^(\\s*(?<storageScheme>(n5|h(df)?5|zarr)):(//)?)?(?<uri>.*)$", 2);
        }
    }

    static enum KeyValueAccessBackend implements Predicate<URI>,
    BiFunction<URI, N5Factory, KeyValueAccess>
    {
        GOOGLE_CLOUD(uri -> {
            String scheme = uri.getScheme();
            boolean hasScheme = scheme != null;
            return hasScheme && GoogleCloudUtils.GS_SCHEME.asPredicate().test(scheme) || hasScheme && HTTPS_SCHEME.asPredicate().test(scheme) && uri.getHost() != null && GoogleCloudUtils.GS_HOST.asPredicate().test(uri.getHost());
        }, (x$0, x$1) -> N5Factory.access$400(x$0, x$1)),
        AWS(uri -> {
            String scheme = uri.getScheme();
            boolean hasScheme = scheme != null;
            return hasScheme && AmazonS3Utils.S3_SCHEME.asPredicate().test(scheme) || uri.getHost() != null && hasScheme && HTTPS_SCHEME.asPredicate().test(scheme);
        }, (x$0, x$1) -> N5Factory.access$200(x$0, x$1)),
        FILE(uri -> {
            String scheme = uri.getScheme();
            boolean hasScheme = scheme != null;
            return !hasScheme || FILE_SCHEME.asPredicate().test(scheme);
        }, (x$0, x$1) -> N5Factory.access$000(x$0, x$1));

        private final Predicate<URI> backendTest;
        private final BiFunction<URI, N5Factory, KeyValueAccess> backendGenerator;

        private KeyValueAccessBackend(Predicate<URI> test, BiFunction<URI, N5Factory, KeyValueAccess> generator) {
            this.backendTest = test;
            this.backendGenerator = generator;
        }

        @Override
        public KeyValueAccess apply(URI uri, N5Factory factory) {
            if (this.test(uri)) {
                return this.backendGenerator.apply(uri, factory);
            }
            return null;
        }

        @Override
        public boolean test(URI uri) {
            return this.backendTest.test(uri);
        }
    }
}

