/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMultiScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5GenericSingleScaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataGroup;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5ViewerMultiscaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadataParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.sawano.java.text.AlphanumericComparator;

public class N5DatasetDiscoverer {
    private static final Logger LOG = LoggerFactory.getLogger(N5DatasetDiscoverer.class);
    public static final N5MetadataParser<?>[] DEFAULT_PARSERS = new N5MetadataParser[]{new N5CosemMetadataParser(), new N5SingleScaleMetadataParser(), new CanonicalMetadataParser(), new N5GenericSingleScaleMetadataParser()};
    public static final N5MetadataParser<?>[] DEFAULT_GROUP_PARSERS = new N5MetadataParser[]{new OmeNgffMetadataParser(), new N5CosemMultiScaleMetadata.CosemMultiScaleParser(), new N5ViewerMultiscaleMetadataParser(), new CanonicalMetadataParser()};
    private final List<N5MetadataParser<?>> metadataParsers;
    private final List<N5MetadataParser<?>> groupParsers;
    private final Comparator<? super String> comparator;
    private final Predicate<N5TreeNode> filter;
    private final ExecutorService executor;
    private N5TreeNode root;
    private String groupSeparator;
    private N5Reader n5;

    public N5DatasetDiscoverer(ExecutorService executor, List<N5MetadataParser<?>> metadataParsers, List<N5MetadataParser<?>> groupParsers) {
        this(executor, Optional.of(new AlphanumericComparator(Collator.getInstance())), null, metadataParsers, groupParsers);
    }

    public N5DatasetDiscoverer(N5Reader n5, ExecutorService executor, List<N5MetadataParser<?>> metadataParsers, List<N5MetadataParser<?>> groupParsers) {
        this(n5, executor, Optional.of(new AlphanumericComparator(Collator.getInstance())), null, metadataParsers, groupParsers);
    }

    public N5DatasetDiscoverer(List<N5MetadataParser<?>> metadataParsers, List<N5MetadataParser<?>> groupParsers) {
        this(Executors.newSingleThreadExecutor(), Optional.of(new AlphanumericComparator(Collator.getInstance())), null, metadataParsers, groupParsers);
    }

    public N5DatasetDiscoverer(N5Reader n5, List<N5MetadataParser<?>> metadataParsers, List<N5MetadataParser<?>> groupParsers) {
        this(n5, Executors.newSingleThreadExecutor(), Optional.of(new AlphanumericComparator(Collator.getInstance())), null, metadataParsers, groupParsers);
    }

    public N5DatasetDiscoverer(ExecutorService executor, Predicate<N5TreeNode> filter, List<N5MetadataParser<?>> metadataParsers, List<N5MetadataParser<?>> groupParsers) {
        this(executor, Optional.of(new AlphanumericComparator(Collator.getInstance())), filter, metadataParsers, groupParsers);
    }

    public N5DatasetDiscoverer(N5Reader n5, ExecutorService executor, Predicate<N5TreeNode> filter, List<N5MetadataParser<?>> metadataParsers, List<N5MetadataParser<?>> groupParsers) {
        this(n5, executor, Optional.of(new AlphanumericComparator(Collator.getInstance())), filter, metadataParsers, groupParsers);
    }

    public N5DatasetDiscoverer(ExecutorService executor, Optional<Comparator<? super String>> comparator, List<N5MetadataParser<?>> metadataParsers, List<N5MetadataParser<?>> groupParsers) {
        this(executor, comparator, null, metadataParsers, groupParsers);
    }

    public N5DatasetDiscoverer(N5Reader n5, ExecutorService executor, Optional<Comparator<? super String>> comparator, List<N5MetadataParser<?>> metadataParsers, List<N5MetadataParser<?>> groupParsers) {
        this(n5, executor, comparator, null, metadataParsers, groupParsers);
    }

    public N5DatasetDiscoverer(ExecutorService executor, Optional<Comparator<? super String>> comparator, Predicate<N5TreeNode> filter, List<N5MetadataParser<?>> metadataParsers, List<N5MetadataParser<?>> groupParsers) {
        this.executor = executor;
        this.comparator = comparator.orElseGet(null);
        this.filter = filter;
        this.metadataParsers = metadataParsers;
        this.groupParsers = groupParsers;
    }

    public N5DatasetDiscoverer(N5Reader n5, ExecutorService executor, Optional<Comparator<? super String>> comparator, Predicate<N5TreeNode> filter, List<N5MetadataParser<?>> metadataParsers, List<N5MetadataParser<?>> groupParsers) {
        this.n5 = n5;
        this.executor = executor;
        this.comparator = comparator.orElseGet(null);
        this.filter = filter;
        this.metadataParsers = metadataParsers;
        this.groupParsers = groupParsers;
    }

    public static void parseMetadata(N5Reader n5, N5TreeNode node, List<N5MetadataParser<?>> metadataParsers) throws IOException {
        N5DatasetDiscoverer.parseMetadata(n5, node, metadataParsers, new ArrayList());
    }

    public static void parseMetadata(N5Reader n5, N5TreeNode node, List<N5MetadataParser<?>> metadataParsers, List<N5MetadataParser<?>> groupParsers) throws IOException {
        for (N5MetadataParser<?> parser : metadataParsers) {
            try {
                Optional<?> parsedMeta = parser.apply(n5, node);
                parsedMeta.ifPresent(node::setMetadata);
                if (!parsedMeta.isPresent()) continue;
                break;
            }
            catch (Exception parsedMeta) {
            }
        }
        if (node.getMetadata() == null && !node.childrenList().isEmpty() && groupParsers != null) {
            for (N5MetadataParser<?> gp : groupParsers) {
                Optional<?> groupMeta = gp.apply(n5, node);
                groupMeta.ifPresent(node::setMetadata);
                if (!groupMeta.isPresent()) continue;
                break;
            }
        }
    }

    public static boolean trim(N5TreeNode node) {
        return N5DatasetDiscoverer.trim(node, x -> {});
    }

    public static boolean trim(N5TreeNode node, Consumer<N5TreeNode> callback) {
        List<N5TreeNode> children = node.childrenList();
        if (children.isEmpty()) {
            return node.getMetadata() != null;
        }
        boolean ret = false;
        Iterator<N5TreeNode> it = children.iterator();
        while (it.hasNext()) {
            N5TreeNode childNode = it.next();
            if (!N5DatasetDiscoverer.trim(childNode, callback)) {
                it.remove();
                callback.accept(childNode);
                continue;
            }
            ret = true;
        }
        return ret || node.getMetadata() != null;
    }

    public static void sort(N5TreeNode node, Comparator<? super String> comparator, Consumer<N5TreeNode> callback) {
        List<N5TreeNode> children = node.childrenList();
        children.sort(Comparator.comparing(N5TreeNode::toString, comparator));
        if (callback != null) {
            callback.accept(node);
        }
        for (N5TreeNode childNode : node.childrenList()) {
            N5DatasetDiscoverer.sort(childNode, comparator, callback);
        }
    }

    public void sort(N5TreeNode node, Consumer<N5TreeNode> callback) {
        if (this.comparator != null) {
            N5DatasetDiscoverer.sort(node, this.comparator, callback);
        }
    }

    public void sort(N5TreeNode node) {
        if (this.comparator != null) {
            N5DatasetDiscoverer.sort(node, this.comparator, null);
        }
    }

    public N5TreeNode discoverAndParseRecursive(String base) throws IOException {
        return this.discoverAndParseRecursive(base, (N5TreeNode x) -> {});
    }

    public N5TreeNode discoverAndParseRecursive(String base, Consumer<N5TreeNode> callback) throws IOException {
        this.groupSeparator = this.n5.getGroupSeparator();
        this.root = new N5TreeNode(base);
        this.discoverAndParseRecursive(this.root, callback);
        return this.root;
    }

    public N5TreeNode discoverAndParseRecursive(N5TreeNode root) throws IOException {
        return this.discoverAndParseRecursive(root, (N5TreeNode x) -> {});
    }

    public N5TreeNode discoverAndParseRecursive(N5TreeNode root, Consumer<N5TreeNode> callback) throws IOException {
        this.groupSeparator = this.n5.getGroupSeparator();
        try {
            String[] datasetPaths = this.n5.deepList(root.getPath(), this.executor);
            N5TreeNode.fromFlatList(root, datasetPaths, this.groupSeparator);
        }
        catch (Exception e) {
            return null;
        }
        callback.accept(root);
        this.parseMetadataRecursive(root, callback);
        this.sortAndTrimRecursive(root, callback);
        return root;
    }

    private String normalDatasetName(String fullPath) {
        return fullPath.replaceAll("(^" + this.groupSeparator + "*)|(" + this.groupSeparator + "*$)", "");
    }

    public N5TreeNode parse(String dataset) {
        N5TreeNode node = new N5TreeNode(dataset);
        return this.parse(node);
    }

    public N5TreeNode parse(N5TreeNode node) {
        for (N5MetadataParser<?> parser : this.metadataParsers) {
            try {
                Optional<?> metadata = parser.apply(this.n5, node);
                if (!metadata.isPresent()) continue;
                node.setMetadata((N5Metadata)metadata.get());
                break;
            }
            catch (Exception exception) {
            }
        }
        return node;
    }

    public void sortAndTrimRecursive(N5TreeNode node) {
        this.sortAndTrimRecursive(node, x -> {});
    }

    public void sortAndTrimRecursive(N5TreeNode node, Consumer<N5TreeNode> callback) {
        N5DatasetDiscoverer.trim(node, callback);
        if (this.comparator != null) {
            this.sort(node, callback);
        }
        for (N5TreeNode c : node.childrenList()) {
            this.sortAndTrimRecursive(c, callback);
        }
    }

    public void filterRecursive(N5TreeNode node) {
        if (this.filter == null) {
            return;
        }
        if (!this.filter.test(node)) {
            node.setMetadata(null);
        }
        for (N5TreeNode c : node.childrenList()) {
            this.filterRecursive(c);
        }
    }

    public void parseMetadataRecursive(N5TreeNode rootNode) {
        this.parseMetadataRecursive(rootNode, x -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseMetadataRecursive(N5TreeNode rootNode, Consumer<N5TreeNode> callback) {
        List<N5TreeNode> children = rootNode.childrenList();
        ArrayList childrenFutures = new ArrayList();
        if (!children.isEmpty()) {
            if (this.executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor threadPoolExec = (ThreadPoolExecutor)this.executor;
                for (N5TreeNode child : children) {
                    boolean useExec;
                    ExecutorService executorService = this.executor;
                    synchronized (executorService) {
                        useExec = threadPoolExec.getActiveCount() < threadPoolExec.getMaximumPoolSize() - 1;
                    }
                    if (useExec) {
                        childrenFutures.add(this.executor.submit(() -> this.parseMetadataRecursive(child, callback)));
                        continue;
                    }
                    this.parseMetadataRecursive(child, callback);
                }
            } else {
                for (N5TreeNode n5TreeNode : children) {
                    this.parseMetadataRecursive(n5TreeNode, callback);
                }
            }
        }
        for (Future future : childrenFutures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Error encountered during metadata parsing", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            N5DatasetDiscoverer.parseMetadata(this.n5, rootNode, this.metadataParsers, this.groupParsers);
        }
        catch (Exception threadPoolExec) {
            // empty catch block
        }
        LOG.debug("parsed metadata for: {}:\t found: {}", (Object)rootNode.getPath(), (Object)(rootNode.getMetadata() == null ? "NONE" : rootNode.getMetadata().getClass().getSimpleName()));
        callback.accept(rootNode);
        if (rootNode.getMetadata() instanceof N5MetadataGroup) {
            N5MetadataGroup grpMeta = (N5MetadataGroup)rootNode.getMetadata();
            for (N5Metadata child : grpMeta.getChildrenMetadata()) {
                rootNode.getDescendant(child.getPath()).ifPresent(x -> callback.accept((N5TreeNode)x));
            }
        }
    }

    public static final List<N5MetadataParser<?>> fromParsers(N5MetadataParser<?>[] parsers) {
        return Arrays.asList(parsers);
    }

    public static N5TreeNode discover(N5Reader n5, List<N5MetadataParser<?>> parsers, List<N5MetadataParser<?>> groupParsers) {
        N5DatasetDiscoverer discoverer = new N5DatasetDiscoverer(n5, Executors.newCachedThreadPool(), parsers, groupParsers);
        try {
            return discoverer.discoverAndParseRecursive("");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static N5TreeNode discover(N5Reader n5, List<N5MetadataParser<?>> parsers) {
        return N5DatasetDiscoverer.discover(n5, parsers, null);
    }

    public static N5TreeNode discover(N5Reader n5) {
        return N5DatasetDiscoverer.discover(n5, Arrays.asList(DEFAULT_PARSERS), Arrays.asList(DEFAULT_GROUP_PARSERS));
    }
}

