/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.utils;

import bdv.util.BdvHandle;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerPanel;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.ActionMap;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.BehaviourMap;
import org.scijava.ui.behaviour.util.RunnableAction;

public class BdvUtils {
    private static final String[] ROTATE_BEHAVIOURS = new String[]{"drag rotate", "drag rotate fast", "drag rotate slow", "rotate left", "rotate left fast", "rotate left slow", "rotate right", "rotate right fast", "rotate right slow", "2d drag rotate", "2d rotate left", "2d rotate left fast", "2d rotate left slow", "2d rotate right", "2d rotate right fast", "2d rotate right slow"};
    private static final String[] ROTATE_ACTIONS = new String[]{"align XY plane", "align XZ plane", "align ZY plane"};
    private static final String BLOCK_ROTATE_BEHAVIOURS_ID = "block_rotate_behaviours";
    private static final String BLOCK_ROTATE_ACTIONS_ID = "block_rotate_actions";

    public static void blockRotation(BdvHandle bdv) {
        BdvUtils.blockRotateBehaviors(bdv);
        BdvUtils.blockRotateActions(bdv);
    }

    private static void blockRotateBehaviors(BdvHandle bdv) {
        BehaviourMap behaviourMap = new BehaviourMap();
        Behaviour do_nothing = new Behaviour(){};
        for (String id : ROTATE_BEHAVIOURS) {
            behaviourMap.put(id, do_nothing);
        }
        bdv.getTriggerbindings().addBehaviourMap(BLOCK_ROTATE_BEHAVIOURS_ID, behaviourMap);
    }

    private static void blockRotateActions(BdvHandle bdv) {
        ActionMap actionMap = new ActionMap();
        RunnableAction do_nothing = new RunnableAction("nop", () -> {});
        for (String id : ROTATE_ACTIONS) {
            actionMap.put(id, (Action)do_nothing);
        }
        bdv.getKeybindings().addActionMap(BLOCK_ROTATE_ACTIONS_ID, actionMap);
    }

    public static void unblockRotation(BdvHandle bdv) {
        bdv.getTriggerbindings().removeBehaviourMap(BLOCK_ROTATE_BEHAVIOURS_ID);
        bdv.getKeybindings().removeActionMap(BLOCK_ROTATE_ACTIONS_ID);
    }

    public static void resetView(ViewerPanel viewerPanel) {
        Source spimSource = ((SourceAndConverter)viewerPanel.state().getSources().get(0)).getSpimSource();
        AffineTransform3D transform = new AffineTransform3D();
        int timePoint = viewerPanel.state().getCurrentTimepoint();
        spimSource.getSourceTransform(timePoint, 0, transform);
        FinalInterval interval = new FinalInterval((Interval)spimSource.getSource(timePoint, 0));
        BdvUtils.resetView(viewerPanel, (Interval)interval, transform);
    }

    public static void resetView(ViewerPanel viewerPanel, Interval interval, AffineTransform3D sourceTransform) {
        AffineTransform3D concat = new AffineTransform3D();
        int width = viewerPanel.getWidth();
        int height = viewerPanel.getHeight();
        AffineTransform3D m = BdvUtils.calculateScreenTransform(interval, width, height);
        concat.set(m);
        concat.concatenate(sourceTransform.inverse());
        viewerPanel.state().setViewerTransform(concat);
    }

    private static AffineTransform3D calculateScreenTransform(Interval interval, int width, int height) {
        double[] screenSize = new double[]{width, height};
        double scale = BdvUtils.getScaleFactor(screenSize, interval);
        double[] translate = BdvUtils.getTranslation(screenSize, interval, scale);
        AffineTransform3D transform = new AffineTransform3D();
        transform.scale(scale);
        transform.translate(translate);
        return transform;
    }

    private static double[] getTranslation(double[] screenSize, Interval interval, double labelScale) {
        double[] translate = new double[3];
        for (int i = 0; i < Math.min(translate.length, interval.numDimensions()); ++i) {
            translate[i] = (double)(-(interval.min(i) + interval.max(i))) * labelScale / 2.0;
            if (i >= 2) continue;
            int n = i;
            translate[n] = translate[n] + screenSize[i] / 2.0;
        }
        return translate;
    }

    private static double getScaleFactor(double[] screenSize, Interval interval) {
        Double[] scales = new Double[2];
        for (int i = 0; i < 2; ++i) {
            scales[i] = screenSize[i] / (double)interval.dimension(i);
        }
        return Collections.min(Arrays.asList(scales));
    }
}

