/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.scijava.ui.behaviour.util.RunnableAction;
import sc.fiji.labkit.ui.utils.Notifier;

public class ComponentList<K, C extends JComponent> {
    private final Color SELECTED_BACKGROUND = UIManager.getColor("List.selectionBackground");
    private final Color BACKGROUND = UIManager.getColor("List.background");
    private JPanel background = new JPanel();
    private JComponent scrollPane = new JScrollPane(this.background, 20, 31);
    private K selected;
    private Map<K, C> items = new HashMap<K, C>();
    private Notifier listeners = new Notifier();

    public ComponentList() {
        this.background.setLayout((LayoutManager)new MigLayout("insets 4pt, gap 4pt", "[grow]"));
        this.background.setBackground(this.BACKGROUND);
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    public void add(final K key, C component) {
        ((JComponent)component).setBackground(this.BACKGROUND);
        ((Component)component).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ComponentList.this.setSelected(key);
            }
        });
        ((JComponent)component).setBackground(key == this.selected ? this.SELECTED_BACKGROUND : this.BACKGROUND);
        this.items.put(key, component);
        this.background.add((Component)component, "grow, wrap");
        this.background.revalidate();
        this.background.repaint();
    }

    public void setSelected(K key) {
        if (this.selected == key) {
            return;
        }
        this.setItemBackground(this.selected, this.BACKGROUND);
        this.selected = key;
        this.setItemBackground(key, this.SELECTED_BACKGROUND);
        this.focusItem(key);
        this.listeners.notifyListeners();
    }

    private void setItemBackground(K key, Color selected_background) {
        C component = this.getComponent(key);
        if (component != null) {
            ((JComponent)component).setBackground(selected_background);
        }
    }

    private void focusItem(K key) {
        C component = this.getComponent(key);
        if (component != null) {
            ((JComponent)component).scrollRectToVisible(new Rectangle(((JComponent)component).getWidth(), ((JComponent)component).getHeight()));
        }
    }

    private C getComponent(K key) {
        if (key == null) {
            return null;
        }
        return (C)((JComponent)this.items.get(key));
    }

    public K getSelected() {
        return this.selected;
    }

    public void clear() {
        this.items.clear();
        this.background.removeAll();
        this.background.revalidate();
        this.background.repaint();
    }

    public Notifier listeners() {
        return this.listeners;
    }

    public static void main(String ... args) {
        JFrame frame = new JFrame();
        frame.setSize(300, 600);
        frame.setLayout((LayoutManager)new MigLayout("", "[grow]", "[grow][]"));
        ComponentList<Integer, JPanel> panelList = new ComponentList<Integer, JPanel>();
        AtomicInteger counter = new AtomicInteger();
        for (int i = 0; i < 1000; ++i) {
            ComponentList.addItem(panelList, counter);
        }
        Random random = new Random();
        frame.add((Component)panelList.getComponent(), "grow, wrap");
        frame.add((Component)new JButton((Action)new RunnableAction("add", () -> ComponentList.addItem(panelList, counter))), "split");
        frame.add(new JButton((Action)new RunnableAction("clear", () -> panelList.clear())));
        frame.add(new JButton((Action)new RunnableAction("jump", () -> panelList.setSelected(random.nextInt(counter.get())))));
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private static void addItem(ComponentList<Integer, JPanel> panelList, AtomicInteger counter) {
        int key = counter.getAndIncrement();
        panelList.add(key, ComponentList.newExamplePanel(key));
    }

    private static JPanel newExamplePanel(int i) {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[][][grow]"));
        panel.add(new JCheckBox());
        JButton button = new JButton();
        button.setBackground(Color.RED);
        panel.add(button);
        panel.add(new JLabel("Hello " + i));
        return panel;
    }
}

