/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.models;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.roi.IterableRegion;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.util.Intervals;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.models.LabelingModel;
import sc.fiji.labkit.ui.models.WeakListeningHolder;
import sc.fiji.labkit.ui.utils.Notifier;

public class ColoredLabelsModel {
    private final LabelingModel model;
    private final Notifier listChangeListeners = new Notifier();
    private final Runnable onLabelingChanged = this.listChangeListeners::notifyListeners;
    private final Holder<Label> selected;

    public ColoredLabelsModel(LabelingModel model) {
        this.model = model;
        model.labeling().notifier().addWeakListener(this.onLabelingChanged);
        this.selected = new WeakListeningHolder<Label>(model.selectedLabel());
    }

    public List<Label> items() {
        return this.model.labeling().get().getLabels();
    }

    public Holder<Label> selected() {
        return this.selected;
    }

    public Notifier listeners() {
        return this.listChangeListeners;
    }

    public void addLabel() {
        Holder<Labeling> holder = this.model.labeling();
        Labeling labeling = holder.get();
        String newName = ColoredLabelsModel.suggestName(labeling.getLabels().stream().map(Label::name).collect(Collectors.toList()));
        if (newName == null) {
            return;
        }
        Label newLabel = labeling.addLabel(newName);
        this.model.selectedLabel().set(newLabel);
        this.fireLabelsChanged();
    }

    public void removeLabel(Label label) {
        this.model.labeling().get().removeLabel(label);
        this.fireLabelsChanged();
    }

    public void renameLabel(Label label, String newLabel) {
        this.model.labeling().get().renameLabel(label, newLabel);
        this.fireLabelsChanged();
    }

    public void moveLabel(Label label, int movement) {
        Labeling labeling = this.model.labeling().get();
        ArrayList<Label> oldOrder = new ArrayList<Label>(labeling.getLabels());
        Function<Label, Double> priority = l -> (double)oldOrder.indexOf(l) + (l == label ? (double)movement + 0.5 * (double)Math.signum(movement) : 0.0);
        labeling.setLabelOrder(Comparator.comparing(priority));
        this.fireLabelsChanged();
    }

    public void setColor(Label label, ARGBType newColor) {
        label.setColor(newColor);
        this.fireLabelsChanged();
    }

    private static String suggestName(List<String> labels) {
        for (int i = 1; i < 10000; ++i) {
            String label = "Label " + i;
            if (labels.contains(label)) continue;
            return label;
        }
        return null;
    }

    public void localizeLabel(Label label) {
        Interval interval = ColoredLabelsModel.getBoundingBox(this.model.labeling().get().iterableRegions().get(label));
        if (interval == null) {
            return;
        }
        interval = Intervals.expand((Interval)interval, (long)Math.max(interval.dimension(0), 20L), (int)0);
        interval = Intervals.expand((Interval)interval, (long)Math.max(interval.dimension(1), 20L), (int)1);
        this.model.transformationModel().transformToShowInterval(interval, this.model.labelTransformation());
    }

    private static Interval getBoundingBox(IterableRegion<BitType> region) {
        int numDimensions = region.numDimensions();
        Cursor cursor = region.cursor();
        if (!cursor.hasNext()) {
            return null;
        }
        long[] min = new long[numDimensions];
        long[] max = new long[numDimensions];
        cursor.fwd();
        cursor.localize(min);
        cursor.localize(max);
        while (cursor.hasNext()) {
            cursor.fwd();
            for (int i = 0; i < numDimensions; ++i) {
                int pos = cursor.getIntPosition(i);
                min[i] = Math.min(min[i], (long)pos);
                max[i] = Math.max(max[i], (long)pos);
            }
        }
        return new FinalInterval(min, max);
    }

    public void clearLabel(Label selected) {
        this.model.labeling().get().clearLabel(selected);
        this.fireLabelsChanged();
    }

    public void setActive(Label label, boolean b) {
        label.setVisible(b);
        this.fireLabelsChanged();
    }

    private void fireLabelsChanged() {
        Holder<Labeling> holder = this.model.labeling();
        holder.notifier().notifyListeners();
    }
}

