/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.menu;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import net.imglib2.util.Cast;
import org.scijava.ui.behaviour.util.AbstractNamedAction;
import org.scijava.ui.behaviour.util.RunnableAction;
import sc.fiji.labkit.ui.menu.MenuKey;

public class MenuFactory {
    private final ConcurrentMap<MenuKey<?>, List<Entry<?>>> menus = new ConcurrentHashMap();
    private final List<AbstractNamedAction> shortCutActions = new ArrayList<AbstractNamedAction>();
    private static final AtomicInteger id = new AtomicInteger();

    public <T> void addMenuItem(MenuKey<T> key, String title, float priority, Consumer<T> action, Icon icon, String keyStroke) {
        List<Entry<T>> list = this.getMenu(key);
        Entry entry = new Entry(title, priority, action, icon, keyStroke);
        list.add(entry);
        if (keyStroke != null && !keyStroke.isEmpty() && key.inputParameterClass() == Void.class) {
            this.shortCutActions.add((AbstractNamedAction)entry.asAction(() -> null));
        }
    }

    public <T> JPopupMenu createPopupMenu(MenuKey<T> key, Supplier<T> item) {
        JPopupMenu menu = new JPopupMenu();
        this.addMenuItems(key, item, menu::add, menu::addSeparator);
        return menu;
    }

    public <T> JMenu createMenu(MenuKey<T> key, Supplier<T> item) {
        JMenu menu = new JMenu("Hello");
        this.addMenuItems(key, item, menu::add, menu::addSeparator);
        return menu;
    }

    private <T> void addMenuItems(MenuKey<T> key, Supplier<T> item, Consumer<Action> addAction, Runnable addSeparator) {
        ArrayList<Entry<T>> list = new ArrayList<Entry<T>>(this.getMenu(key));
        list.sort(Comparator.comparing(entry -> Float.valueOf(((Entry)entry).priority)));
        int previous = list.isEmpty() ? 0 : this.group((Entry)list.get(0));
        for (Entry entry2 : list) {
            int group = this.group(entry2);
            if (group != previous) {
                addSeparator.run();
            }
            previous = group;
            addAction.accept((Action)entry2.asAction(item));
        }
    }

    private <T> int group(Entry<T> entry) {
        return (int)(((Entry)entry).priority / 100.0f);
    }

    private <T> List<Entry<T>> getMenu(MenuKey<T> key) {
        List input = this.menus.computeIfAbsent(key, k -> new ArrayList());
        return (List)Cast.unchecked((Object)input);
    }

    public List<AbstractNamedAction> shortCutActions() {
        return this.shortCutActions;
    }

    private static class Entry<T> {
        private final String title;
        private final float priority;
        private final Consumer<T> action;
        private final Icon icon;
        private final String keyStroke;
        private final String commandKey;

        private Entry(String title, float priority, Consumer<T> action, Icon icon, String keyStroke) {
            this.title = title;
            this.priority = priority;
            this.action = action;
            this.icon = icon;
            this.keyStroke = keyStroke;
            this.commandKey = "MenuFactoryGeneratedCommandKey" + id.getAndIncrement();
        }

        private RunnableAction asAction(Supplier<T> item) {
            RunnableAction action = new RunnableAction(this.title, () -> this.action.accept(item.get()));
            action.putValue("SmallIcon", (Object)this.icon);
            action.putValue("SwingLargeIconKey", (Object)this.icon);
            action.putValue("ActionCommandKey", (Object)this.commandKey);
            action.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke(this.keyStroke));
            return action;
        }
    }
}

