/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.labeling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.scif.config.SCIFIOConfig;
import io.scif.services.DatasetIOService;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.imagej.DatasetService;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.axis.LinearAxis;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.RealTypeConverters;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import org.apache.commons.io.FilenameUtils;
import org.scijava.Context;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.utils.NumberAwareStringComparator;
import sc.fiji.labkit.ui.utils.sparse.SparseIterableRegion;

public class LabelingSerializer {
    private final Context context;

    public LabelingSerializer(Context context) {
        this.context = context;
    }

    public Labeling open(String filename) throws IOException {
        if (FilenameUtils.isExtension((String)filename, (String[])new String[]{"tif", "tiff"})) {
            return this.openFromTiff(filename);
        }
        if (FilenameUtils.isExtension((String)filename, (String[])new String[]{"labeling", "json"})) {
            return this.openFromJson(filename);
        }
        throw new IllegalArgumentException("Filename must have supported extension (*.labeling, *.tif, *.tiff)");
    }

    private Labeling openFromJson(String filename) throws IOException {
        try (FileReader reader = new FileReader(filename);){
            Labeling result = new Gson().fromJson((Reader)reader, Labeling.class);
            if (result == null) {
                throw new IOException("Error, labeling file is empty: " + filename);
            }
            Labeling labeling = result;
            return labeling;
        }
    }

    private Labeling openFromTiff(String filename) throws IOException {
        Img<? extends IntegerType<?>> img = this.openImageFromTiff(filename);
        if (new File(filename + ".labels").exists()) {
            List<Set<String>> labelSets = this.openMetaData(filename + ".labels").asLabelSets();
            ImgLabeling imgLabeling = ImgLabeling.fromImageAndLabelSets((RandomAccessibleInterval)((RandomAccessibleInterval)Cast.unchecked(img)), labelSets);
            Labeling labeling = Labeling.fromImgLabeling(imgLabeling);
            labeling.setLabelOrder(Comparator.comparing(Label::name, NumberAwareStringComparator.getInstance()));
            return labeling;
        }
        return Labeling.fromImg(img);
    }

    private Img<? extends IntegerType<?>> openImageFromTiff(String filename) throws IOException {
        DatasetIOService io = (DatasetIOService)this.context.service(DatasetIOService.class);
        return this.convertToIntegerType(io.open(filename).getImgPlus().getImg());
    }

    private Img<? extends IntegerType<? extends IntegerType<?>>> convertToIntegerType(Img<? extends RealType<?>> img) {
        if (img.firstElement() instanceof IntegerType) {
            return (Img)Cast.unchecked(img);
        }
        ArrayImg result = ArrayImgs.ints((long[])Intervals.dimensionsAsLongArray(img));
        RealTypeConverters.copyFromTo(img, (RandomAccessibleInterval)result);
        return result;
    }

    private LabelsMetaData openMetaData(String filename) throws IOException {
        try (FileReader reader = new FileReader(filename);){
            LabelsMetaData labelsMetaData = new Gson().fromJson((Reader)reader, LabelsMetaData.class);
            return labelsMetaData;
        }
    }

    public void save(Labeling labeling, String filename) throws IOException {
        if (FilenameUtils.isExtension((String)filename, (String[])new String[]{"tif", "tiff"})) {
            this.saveAsTiff(labeling, filename);
        } else if (FilenameUtils.isExtension((String)filename, (String[])new String[]{"labeling", "json"})) {
            this.saveAsJson(labeling, filename);
        } else {
            throw new IllegalArgumentException("Filename must have supported extension (*.labeling, *.tif, *.tiff)");
        }
    }

    private void saveAsJson(Labeling labeling, String filename) throws IOException {
        String tmpFilename = filename + ".tmp";
        try (FileWriter writer = new FileWriter(tmpFilename);){
            new Gson().toJson((Object)labeling, (Type)((Object)Labeling.class), writer);
        }
        Files.move(Paths.get(tmpFilename, new String[0]), Paths.get(filename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    private <I extends IntegerType<I>> void saveAsTiff(Labeling labeling, String filename) throws IOException {
        LabelsMetaData meta = new LabelsMetaData(labeling.getLabelSets());
        try (FileWriter writer = new FileWriter(filename + ".labels");){
            new Gson().toJson((Object)meta, (Appendable)writer);
        }
        DatasetIOService io = (DatasetIOService)this.context.service(DatasetIOService.class);
        DatasetService ds = (DatasetService)this.context.service(DatasetService.class);
        RandomAccessibleInterval imgPlus = (RandomAccessibleInterval)Cast.unchecked(labeling.getIndexImg());
        io.save(ds.create(imgPlus), filename, new SCIFIOConfig().writerSetFailIfOverwriting(false));
    }

    public static class Adapter
    extends TypeAdapter<Labeling> {
        @Override
        public void write(JsonWriter jsonWriter, Labeling labeling) throws IOException {
            Gson gson = new Gson();
            JsonObject jsonLabeling = new JsonObject();
            jsonLabeling.add("interval", gson.toJsonTree(new FinalInterval((Interval)labeling), (Type)((Object)FinalInterval.class)));
            jsonLabeling.add("pixelSizes", gson.toJsonTree(this.getPixelSize(labeling), (Type)((Object)PixelSize[].class)));
            jsonLabeling.add("labels", this.regionsToJson(labeling, gson));
            jsonLabeling.add("colors", this.colorsToJson(labeling.getLabels()));
            gson.toJson((JsonElement)jsonLabeling, jsonWriter);
        }

        private JsonElement colorsToJson(List<Label> labels) {
            JsonObject map = new JsonObject();
            for (Label label : labels) {
                String format = String.format("#%06X", label.color().get() & 0xFFFFFF);
                map.add(label.name(), new JsonPrimitive(format));
            }
            return map;
        }

        private PixelSize[] getPixelSize(Labeling labeling) {
            return (PixelSize[])labeling.axes().stream().map(this::toPixelSize).toArray(PixelSize[]::new);
        }

        private PixelSize toPixelSize(CalibratedAxis calibratedAxis) {
            if (!(calibratedAxis instanceof LinearAxis)) {
                return new PixelSize(1.0, "unknown");
            }
            LinearAxis linear = (LinearAxis)calibratedAxis;
            return new PixelSize(linear.scale(), linear.unit());
        }

        private JsonObject regionsToJson(Labeling labeling, Gson gson) {
            JsonObject map = new JsonObject();
            Map<Label, IterableRegion<BitType>> iterableRegions = labeling.iterableRegions();
            for (Label label : labeling.getLabels()) {
                map.add(label.name(), this.regionToJson(gson, iterableRegions.get(label)));
            }
            return map;
        }

        private JsonElement regionToJson(Gson gson, IterableRegion<BitType> region) {
            JsonArray result = new JsonArray();
            Cursor cursor = region.cursor();
            long[] coords = new long[cursor.numDimensions()];
            while (cursor.hasNext()) {
                cursor.fwd();
                cursor.localize(coords);
                result.add(gson.toJsonTree(coords, (Type)((Object)long[].class)));
            }
            return result;
        }

        @Override
        public Labeling read(JsonReader jsonReader) throws IOException {
            Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Labeling.class), new MyDeserializer()).create();
            return (Labeling)((Object)gson.fromJson(jsonReader, (Type)((Object)Labeling.class)));
        }

        private static class PixelSize {
            public double size;
            public String unit;

            public PixelSize(double size, String unit) {
                this.size = size;
                this.unit = unit;
            }
        }

        private static class MyDeserializer
        implements JsonDeserializer<Labeling> {
            private MyDeserializer() {
            }

            @Override
            public Labeling deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = json.getAsJsonObject();
                Interval interval = (Interval)context.deserialize(object.get("interval"), (Type)((Object)FinalInterval.class));
                PixelSize[] axes = (PixelSize[])context.deserialize(object.get("pixelSizes"), (Type)((Object)PixelSize[].class));
                LinkedTreeMap<String, IterableRegion<BitType>> regions = new LinkedTreeMap<String, IterableRegion<BitType>>();
                for (Map.Entry<String, JsonElement> entry : object.getAsJsonObject("labels").entrySet()) {
                    regions.put(entry.getKey(), this.regionFromJson(context, interval, entry.getValue()));
                }
                Labeling labeling = regions.isEmpty() ? Labeling.createEmptyLabels(Collections.emptyList(), interval) : Labeling.fromMap(regions);
                labeling.setAxes(this.pixelSizesToAxes(axes));
                this.deserializeColors(context, object, labeling);
                return labeling;
            }

            private void deserializeColors(JsonDeserializationContext context, JsonObject object, Labeling labeling) {
                if (!object.has("colors")) {
                    return;
                }
                Map map = (Map)context.deserialize(object.get("colors"), new TypeToken<Map<String, String>>(){}.getType());
                for (Label label : labeling.getLabels()) {
                    String color = (String)map.get(label.name());
                    if (color == null) continue;
                    label.setColor(new ARGBType(Color.decode(color).getRGB()));
                }
            }

            private List<CalibratedAxis> pixelSizesToAxes(PixelSize[] axes) {
                return Stream.of(axes).map(this::pixelSizeToAxis).collect(Collectors.toList());
            }

            private LinearAxis pixelSizeToAxis(PixelSize pixelSize) {
                return new DefaultLinearAxis(Axes.unknown(), pixelSize.unit, pixelSize.size);
            }

            private SparseIterableRegion regionFromJson(JsonDeserializationContext context, Interval interval, JsonElement jsonCoords) {
                SparseIterableRegion result = new SparseIterableRegion(interval);
                JsonArray array = jsonCoords.getAsJsonArray();
                Point point = new Point(interval.numDimensions());
                for (JsonElement item : array) {
                    long[] coords = (long[])context.deserialize(item, (Type)((Object)long[].class));
                    point.setPosition(coords);
                    result.add((Localizable)point);
                }
                return result;
            }
        }
    }

    private static class LabelsMetaData {
        List<Set<String>> labelSets;

        public LabelsMetaData(List<Set<Label>> mapping) {
            this.labelSets = mapping.stream().map(set -> set.stream().map(Label::name).collect(Collectors.toSet())).collect(Collectors.toList());
        }

        public List<Set<String>> asLabelSets() {
            return this.labelSets;
        }
    }
}

