/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.brush;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import org.scijava.ui.behaviour.util.AbstractNamedAction;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.models.LabelingModel;

public class ChangeLabel
extends AbstractNamedAction {
    private final LabelingModel model;

    public ChangeLabel(LabelingModel model) {
        super("Next Label");
        this.model = model;
        super.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("N"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        List<Label> labels = this.model.labeling().get().getLabels();
        Label nextLabel = this.next(labels, this.model.selectedLabel().get());
        if (nextLabel != null) {
            this.model.selectedLabel().set(nextLabel);
        }
    }

    private Label next(List<Label> labels, Label currentLabel) {
        if (labels.isEmpty()) {
            return null;
        }
        int index = labels.indexOf(currentLabel) + 1;
        if (index >= labels.size()) {
            index = 0;
        }
        return labels.get(index);
    }
}

