/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.reconstructreader.reconstruct;

import edu.utexas.clm.reconstructreader.reconstruct.ReconstructTranslator;
import ij.IJ;
import ij.gui.MessageDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ini.trakem2.Project;
import java.awt.Frame;

public class Reconstruct_Reader
implements PlugIn {
    public void run(String arg) {
        String fname;
        if (arg.equals("")) {
            OpenDialog od = new OpenDialog("Select Reconstruct ser File", "");
            fname = od.getDirectory() + od.getFileName();
        } else {
            fname = arg;
        }
        IJ.log((String)"Creating Reconstruct Translator.");
        ReconstructTranslator translator = new ReconstructTranslator(fname);
        IJ.log((String)"Done.");
        long sTime = System.currentTimeMillis();
        IJ.log((String)"Beginning translation");
        if (translator.process()) {
            float pTime = (float)(System.currentTimeMillis() - sTime) / 1000.0f;
            IJ.log((String)("Done translating, took " + pTime + " seconds. Writing XML"));
            String projectFileName = translator.writeTrakEM2();
            if (!translator.getPostTranslationMessage().isEmpty()) {
                IJ.showMessage((String)translator.getPostTranslationMessage());
            }
            if (projectFileName != null) {
                IJ.log((String)("Opening project " + projectFileName));
                Project t2p = Project.openFSProject(projectFileName);
                t2p.getRootLayerSet().setMinimumDimensions();
            }
        } else {
            IJ.log((String)translator.getLastErrorMessage());
            new MessageDialog((Frame)IJ.getInstance(), "Error", "Encountered an Error while translating");
        }
    }
}

