/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.crop;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ShapeRoi;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.Project;
import ini.trakem2.display.AreaList;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;

public class AreaListCrop {
    private final ArrayList<AreaList> areaLists = new ArrayList();

    public void addAreaList(AreaList areaList) {
        if (!this.areaLists.contains(areaList)) {
            this.areaLists.add(areaList);
        }
    }

    public ArrayList<AreaList> getAreaLists() {
        return this.areaLists;
    }

    protected void progress(double p) {
    }

    public ImagePlus getCropImage(int defVal) {
        ByteProcessor refIp = new ByteProcessor(2, 2);
        if (!this.areaLists.isEmpty()) {
            Rectangle bound = this.areaLists.get(0).getBoundingBox();
            Project project = this.areaLists.get(0).getProject();
            Layer minLayer = this.areaLists.get(0).getLayerRange().get(0);
            Layer maxLayer = this.areaLists.get(0).getLastLayer();
            int idxLayer = 0;
            for (AreaList areaList : this.areaLists) {
                bound.add(areaList.getBoundingBox());
                if (areaList.getLayerRange().get(0).getZ() < minLayer.getZ()) {
                    minLayer = areaList.getLayerRange().get(0);
                }
                if (!(areaList.getLastLayer().getZ() > maxLayer.getZ())) continue;
                maxLayer = areaList.getLastLayer();
            }
            ImageStack stack = new ImageStack(bound.width, bound.height);
            List<Layer> layerRange = minLayer.getParent().getLayers(minLayer, maxLayer);
            this.progress(0.0);
            for (Layer layer : layerRange) {
                IJ.log((String)"Releasing memory...");
                project.getLoader().releaseToFit(bound.width * bound.height * 10);
                ImageProcessor ip = refIp.createProcessor(bound.width, bound.height);
                ip.add(defVal);
                IJ.log((String)"Loading image data...");
                ImageProcessor flatCrop = Patch.makeFlatImage(0, layer, bound, 1.0, layer.getAll(Patch.class), new Color(defVal, defVal, defVal)).crop();
                IJ.log((String)("Got flat image for " + layer.toString()));
                for (AreaList areaList : this.areaLists) {
                    Area area = areaList.getArea(layer);
                    if (area == null) continue;
                    AffineTransform aff = areaList.getAffineTransformCopy();
                    aff.translate(-bound.x, -bound.y);
                    ShapeRoi roi = new ShapeRoi((Shape)areaList.getArea(layer).createTransformedArea(aff));
                    Rectangle rb = roi.getBounds();
                    int x = rb.x;
                    while (x - rb.x < rb.width) {
                        int y = rb.y;
                        while (y - rb.y < rb.height) {
                            if (roi.contains(x, y) && this.check(ip, x, y) && this.check(flatCrop, x, y)) {
                                ip.set(x, y, flatCrop.get(x, y));
                            }
                            ++y;
                        }
                        ++x;
                    }
                }
                stack.addSlice("", ip);
                this.progress((double)idxLayer++ / (double)layerRange.size());
                IJ.log((String)("Done for " + idxLayer));
            }
            ImagePlus imp = new ImagePlus("Cropped AreaList Stack", stack);
            imp.setCalibration(minLayer.getParent().getCalibrationCopy());
            return imp;
        }
        return null;
    }

    private boolean check(ImageProcessor ip, int x, int y) {
        return x > 0 && y > 0 && x <= ip.getWidth() && y <= ip.getHeight();
    }
}

