/*
 * Decompiled with CFR 0.152.
 */
package bvv.vistools;

import bdv.cache.CacheControl;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.transformation.ManualTransformationEditor;
import bdv.viewer.DisplayMode;
import bdv.viewer.SourceAndConverter;
import bvv.core.BigVolumeViewer;
import bvv.core.VolumeViewerFrame;
import bvv.core.VolumeViewerOptions;
import bvv.vistools.BvvHandle;
import bvv.vistools.BvvOptions;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import org.scijava.ui.behaviour.util.InputActionBindings;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class BvvHandleFrame
extends BvvHandle {
    private BigVolumeViewer bvv;
    private final String frameTitle;

    BvvHandleFrame(BvvOptions options) {
        super(options);
        this.frameTitle = options.values.getFrameTitle();
        this.bvv = null;
        this.cacheControls = new CacheControl.CacheControls();
    }

    public BigVolumeViewer getBigVolumeViewer() {
        return this.bvv;
    }

    @Override
    public void close() {
        if (this.bvv != null) {
            VolumeViewerFrame frame = this.bvv.getViewerFrame();
            frame.dispatchEvent(new WindowEvent(frame, 201));
            this.bvv = null;
        }
        super.close();
    }

    @Override
    public ManualTransformationEditor getManualTransformEditor() {
        return this.bvv.getManualTransformEditor();
    }

    @Override
    public InputActionBindings getKeybindings() {
        return this.bvv.getViewerFrame().getKeybindings();
    }

    @Override
    public TriggerBehaviourBindings getTriggerbindings() {
        return this.bvv.getViewerFrame().getTriggerbindings();
    }

    @Override
    boolean createViewer(List<? extends ConverterSetup> converterSetups, List<? extends SourceAndConverter<?>> sources, int numTimepoints) {
        VolumeViewerOptions viewerOptions = this.bvvOptions.values.getVolumeViewerOptions();
        this.bvv = new BigVolumeViewer(new ArrayList<ConverterSetup>(converterSetups), new ArrayList(sources), numTimepoints, (CacheControl)this.cacheControls, this.frameTitle, viewerOptions);
        this.viewer = this.bvv.getViewer();
        this.setupAssignments = this.bvv.getSetupAssignments();
        this.setups = this.bvv.getConverterSetups();
        this.viewer.setDisplayMode(DisplayMode.FUSED);
        this.bvv.getViewerFrame().setVisible(true);
        boolean initTransform = !sources.isEmpty();
        return initTransform;
    }
}

