/*
 * Decompiled with CFR 0.152.
 */
package bvv.vistools;

import bdv.cache.CacheControl;
import bdv.tools.InitializeViewerState;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.SetupAssignments;
import bdv.tools.transformation.ManualTransformationEditor;
import bdv.ui.CardPanel;
import bdv.ui.splitpanel.SplitPanel;
import bdv.util.BdvFunctions;
import bdv.viewer.ConverterSetups;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.TimePointListener;
import bdv.viewer.TransformListener;
import bdv.viewer.ViewerState;
import bdv.viewer.ViewerStateChangeListener;
import bvv.core.VolumeViewerPanel;
import bvv.vistools.Bvv;
import bvv.vistools.BvvOptions;
import bvv.vistools.BvvSource;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.ui.behaviour.util.InputActionBindings;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public abstract class BvvHandle
implements Bvv {
    protected VolumeViewerPanel viewer;
    protected CardPanel cards;
    protected SplitPanel splitPanel;
    protected ConverterSetups setups;
    protected SetupAssignments setupAssignments;
    protected final List<BvvSource> bvvSources;
    protected final BvvOptions bvvOptions;
    protected boolean hasPlaceHolderSources;
    protected final int origNumTimepoints;
    protected CacheControl.CacheControls cacheControls;
    private boolean initTransformPending;

    public BvvHandle(BvvOptions options) {
        this.bvvOptions = options;
        this.bvvSources = new ArrayList<BvvSource>();
        this.origNumTimepoints = 1;
    }

    @Override
    public BvvHandle getBvvHandle() {
        return this;
    }

    public VolumeViewerPanel getViewerPanel() {
        return this.viewer;
    }

    public CardPanel getCardPanel() {
        return this.cards;
    }

    public SplitPanel getSplitPanel() {
        return this.splitPanel;
    }

    public ConverterSetups getConverterSetups() {
        return this.setups;
    }

    @Deprecated
    public SetupAssignments getSetupAssignments() {
        return this.setupAssignments;
    }

    CacheControl.CacheControls getCacheControls() {
        return this.cacheControls;
    }

    @Deprecated
    int getUnusedSetupId() {
        return BdvFunctions.getUnusedSetupId((SetupAssignments)this.setupAssignments);
    }

    @Override
    public void close() {
        if (this.viewer != null) {
            this.viewer.stop();
            this.bvvSources.clear();
            this.cacheControls.clear();
            this.viewer = null;
            this.cards = null;
            this.splitPanel = null;
            this.setups = null;
            this.setupAssignments = null;
            this.cacheControls = null;
        }
    }

    public abstract ManualTransformationEditor getManualTransformEditor();

    public abstract InputActionBindings getKeybindings();

    public abstract TriggerBehaviourBindings getTriggerbindings();

    abstract boolean createViewer(List<? extends ConverterSetup> var1, List<? extends SourceAndConverter<?>> var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(List<? extends ConverterSetup> converterSetups, List<? extends SourceAndConverter<?>> sources, int numTimepoints) {
        boolean initTransform;
        if (this.viewer == null) {
            initTransform = this.createViewer(converterSetups, sources, numTimepoints);
        } else {
            boolean bl = initTransform = this.viewer.state().getSources().isEmpty() && sources != null && !sources.isEmpty();
            if (converterSetups != null && sources != null && converterSetups.size() != sources.size()) {
                System.err.println("WARNING! Adding sources to BdvHandle with converterSetups.size() != sources.size().");
            }
            if (converterSetups != null) {
                int numSetups = Math.min(converterSetups.size(), sources.size());
                for (int i = 0; i < numSetups; ++i) {
                    SourceAndConverter<?> source = sources.get(i);
                    ConverterSetup setup = converterSetups.get(i);
                    if (setup == null) continue;
                    this.setups.put(source, setup);
                }
                converterSetups.forEach(arg_0 -> ((SetupAssignments)this.setupAssignments).addSetup(arg_0));
            }
            if (sources != null) {
                for (SourceAndConverter<?> soc : sources) {
                    this.viewer.state().addSource(soc);
                    this.viewer.state().setSourceActive(soc, true);
                }
            }
        }
        if (initTransform) {
            BvvHandle bvvHandle = this;
            synchronized (bvvHandle) {
                this.initTransformPending = true;
                this.tryInitTransform();
            }
        }
    }

    protected synchronized void tryInitTransform() {
        if (this.viewer.getDisplay().getWidth() <= 0 || this.viewer.getDisplay().getHeight() <= 0) {
            return;
        }
        if (this.initTransformPending) {
            this.initTransformPending = false;
            Dimension dim = this.viewer.getDisplay().getSize();
            AffineTransform3D viewerTransform = InitializeViewerState.initTransform((int)dim.width, (int)dim.height, (boolean)false, (ViewerState)this.viewer.state().snapshot());
            this.viewer.state().setViewerTransform(viewerTransform);
        }
    }

    void remove(List<? extends ConverterSetup> converterSetups, List<? extends SourceAndConverter<?>> sources, List<TransformListener<AffineTransform3D>> transformListeners, List<TimePointListener> timepointListeners, List<ViewerStateChangeListener> viewerStateChangeListeners) {
        if (this.viewer == null) {
            return;
        }
        if (converterSetups != null) {
            for (ConverterSetup converterSetup : converterSetups) {
                this.setupAssignments.removeSetup(converterSetup);
            }
        }
        if (transformListeners != null) {
            this.viewer.transformListeners().removeAll(transformListeners);
        }
        if (timepointListeners != null) {
            for (TimePointListener timePointListener : timepointListeners) {
                this.viewer.removeTimePointListener(timePointListener);
            }
        }
        if (viewerStateChangeListeners != null) {
            this.viewer.state().changeListeners().removeAll(viewerStateChangeListeners);
        }
        if (sources != null) {
            this.viewer.state().removeSources(sources);
        }
    }

    void addBvvSource(BvvSource bvvSource) {
        this.bvvSources.add(bvvSource);
        this.updateHasPlaceHolderSources();
        this.updateNumTimepoints();
    }

    void removeBvvSource(BvvSource bvvSource) {
        this.bvvSources.remove(bvvSource);
        this.updateHasPlaceHolderSources();
        this.updateNumTimepoints();
    }

    void updateHasPlaceHolderSources() {
        for (BvvSource s : this.bvvSources) {
            if (!s.isPlaceHolderSource()) continue;
            this.hasPlaceHolderSources = true;
            return;
        }
        this.hasPlaceHolderSources = false;
    }

    void updateNumTimepoints() {
        int numTimepoints = this.origNumTimepoints;
        for (BvvSource s : this.bvvSources) {
            numTimepoints = Math.max(numTimepoints, s.getNumTimepoints());
        }
        if (this.viewer != null) {
            this.viewer.setNumTimepoints(numTimepoints);
        }
    }
}

