/*
 * Decompiled with CFR 0.152.
 */
package bvv.vistools;

import bdv.BigDataViewer;
import bdv.ViewerImgLoader;
import bdv.cache.CacheControl;
import bdv.img.cache.VolatileGlobalCellCache;
import bdv.spimdata.WrapBasicImgLoader;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.SetupAssignments;
import bdv.util.AxisOrder;
import bdv.util.RandomAccessibleIntervalSource;
import bdv.util.RandomAccessibleIntervalSource4D;
import bdv.util.RandomAccessibleSource;
import bdv.util.RandomAccessibleSource4D;
import bdv.util.volatiles.VolatileView;
import bdv.util.volatiles.VolatileViewData;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bvv.vistools.Bvv;
import bvv.vistools.BvvHandle;
import bvv.vistools.BvvHandleFrame;
import bvv.vistools.BvvOptions;
import bvv.vistools.BvvStackSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.volatiles.VolatileARGBType;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;

public class BvvFunctions {
    public static <T> BvvStackSource<T> show(RandomAccessibleInterval<T> img, String name) {
        return BvvFunctions.show(img, name, Bvv.options());
    }

    public static Bvv show(BvvOptions options) {
        Bvv bvv = options.values.addTo();
        BvvHandle handle = bvv == null ? new BvvHandleFrame(options) : bvv.getBvvHandle();
        handle.createViewer(Collections.emptyList(), Collections.emptyList(), 1);
        return handle;
    }

    public static <T> BvvStackSource<T> show(RandomAccessibleInterval<T> img, String name, BvvOptions options) {
        Object type;
        Bvv bvv = options.values.addTo();
        BvvHandle handle = bvv == null ? new BvvHandleFrame(options) : bvv.getBvvHandle();
        AxisOrder axisOrder = AxisOrder.getAxisOrder((AxisOrder)options.values.axisOrder(), img, (boolean)false);
        AffineTransform3D sourceTransform = options.values.getSourceTransform();
        if (img instanceof VolatileView) {
            VolatileViewData viewData = ((VolatileView)img).getVolatileViewData();
            type = viewData.getVolatileType();
            handle.getCacheControls().addCacheControl(viewData.getCacheControl());
        } else {
            type = Util.getTypeFromInterval(img);
        }
        return BvvFunctions.addRandomAccessibleInterval(handle, img, (NumericType)type, name, axisOrder, sourceTransform);
    }

    public static <T> BvvStackSource<T> show(Source<T> source) {
        return BvvFunctions.show(source, Bvv.options());
    }

    public static <T> BvvStackSource<T> show(Source<T> source, BvvOptions options) {
        return BvvFunctions.show(source, 1, options);
    }

    public static <T> BvvStackSource<T> show(Source<T> source, int numTimePoints) {
        return BvvFunctions.show(source, numTimePoints, Bvv.options());
    }

    public static <T> BvvStackSource<T> show(Source<T> source, int numTimePoints, BvvOptions options) {
        Bvv bvv = options.values.addTo();
        BvvHandle handle = bvv == null ? new BvvHandleFrame(options) : bvv.getBvvHandle();
        BvvStackSource<T> stackSource = BvvFunctions.addSource(handle, source, numTimePoints);
        return stackSource;
    }

    public static List<BvvStackSource<?>> show(AbstractSpimData<?> spimData) {
        return BvvFunctions.show(spimData, Bvv.options());
    }

    public static List<BvvStackSource<?>> show(AbstractSpimData<?> spimData, BvvOptions options) {
        Bvv bvv = options.values.addTo();
        BvvHandle handle = bvv == null ? new BvvHandleFrame(options) : bvv.getBvvHandle();
        AbstractSequenceDescription seq = spimData.getSequenceDescription();
        int numTimepoints = seq.getTimePoints().size();
        VolatileGlobalCellCache cache = (VolatileGlobalCellCache)((ViewerImgLoader)seq.getImgLoader()).getCacheControl();
        handle.getBvvHandle().getCacheControls().addCacheControl((CacheControl)cache);
        cache.clearCache();
        WrapBasicImgLoader.wrapImgLoaderIfNecessary(spimData);
        ArrayList sources = new ArrayList();
        BigDataViewer.initSetups(spimData, new ArrayList(), sources);
        ArrayList bvvSources = new ArrayList();
        for (SourceAndConverter source : sources) {
            bvvSources.add(BvvFunctions.addSpimDataSource(handle, source, numTimepoints));
        }
        WrapBasicImgLoader.removeWrapperIfPresent(spimData);
        return bvvSources;
    }

    public static int getUnusedSetupId(BigDataViewer bdv) {
        return BvvFunctions.getUnusedSetupId(bdv.getSetupAssignments());
    }

    public static synchronized int getUnusedSetupId(SetupAssignments setupAssignments) {
        return SetupAssignments.getUnusedSetupId((SetupAssignments)setupAssignments);
    }

    private static <T extends NumericType<T>> BvvStackSource<T> addRandomAccessibleInterval(BvvHandle handle, RandomAccessibleInterval<T> img, T type, String name, AxisOrder axisOrder, AffineTransform3D sourceTransform) {
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>();
        ArrayList sources = new ArrayList();
        ArrayList stacks = AxisOrder.splitInputStackIntoSourceStacks(img, (AxisOrder)axisOrder);
        int numTimepoints = 1;
        for (RandomAccessibleInterval stack : stacks) {
            RandomAccessibleIntervalSource s;
            if (stack.numDimensions() > 3) {
                numTimepoints = (int)stack.max(3) + 1;
                s = new RandomAccessibleIntervalSource4D(stack, type, sourceTransform, name);
            } else {
                s = new RandomAccessibleIntervalSource(stack, type, sourceTransform, name);
            }
            BvvFunctions.addSourceToListsGenericType(s, handle.getUnusedSetupId(), converterSetups, sources);
        }
        handle.add(converterSetups, sources, numTimepoints);
        BvvStackSource<T> bvvSource = new BvvStackSource<T>(handle, numTimepoints, type, converterSetups, sources);
        handle.addBvvSource(bvvSource);
        return bvvSource;
    }

    private static <T extends NumericType<T>> BvvStackSource<T> addRandomAccessible(BvvHandle handle, RandomAccessible<T> img, Interval interval, int numTimepoints, T type, String name, AxisOrder axisOrder, AffineTransform3D sourceTransform) {
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>();
        ArrayList sources = new ArrayList();
        Pair stacksAndInterval = AxisOrder.splitInputStackIntoSourceStacks(img, (Interval)interval, (AxisOrder)axisOrder);
        ArrayList stacks = (ArrayList)stacksAndInterval.getA();
        Interval stackInterval = (Interval)stacksAndInterval.getB();
        for (RandomAccessible stack : stacks) {
            Object s = stack.numDimensions() > 3 ? new RandomAccessibleSource4D(stack, stackInterval, type, sourceTransform, name) : new RandomAccessibleSource(stack, stackInterval, type, sourceTransform, name);
            BvvFunctions.addSourceToListsGenericType(s, handle.getUnusedSetupId(), converterSetups, sources);
        }
        handle.add(converterSetups, sources, numTimepoints);
        BvvStackSource<T> bvvSource = new BvvStackSource<T>(handle, numTimepoints, type, converterSetups, sources);
        handle.addBvvSource(bvvSource);
        return bvvSource;
    }

    private static <T> BvvStackSource<T> addSource(BvvHandle handle, Source<T> source, int numTimepoints) {
        Object type = source.getType();
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>();
        ArrayList<SourceAndConverter<T>> sources = new ArrayList<SourceAndConverter<T>>();
        BvvFunctions.addSourceToListsGenericType(source, handle.getUnusedSetupId(), converterSetups, sources);
        handle.add(converterSetups, sources, numTimepoints);
        BvvStackSource<Object> bvvSource = new BvvStackSource<Object>(handle, numTimepoints, type, converterSetups, sources);
        handle.addBvvSource(bvvSource);
        return bvvSource;
    }

    private static <T> void addSourceToListsGenericType(Source<T> source, int setupId, List<ConverterSetup> converterSetups, List<SourceAndConverter<T>> sources) {
        Object type = source.getType();
        if (!(type instanceof RealType || type instanceof ARGBType || type instanceof VolatileARGBType)) {
            throw new IllegalArgumentException("Unknown source type. Expected RealType, ARGBType, or VolatileARGBType");
        }
        BvvFunctions.addSourceToListsNumericType(source, setupId, converterSetups, sources);
    }

    private static <T extends NumericType<T>> void addSourceToListsNumericType(Source<T> source, int setupId, List<ConverterSetup> converterSetups, List<SourceAndConverter<T>> sources) {
        NumericType type = (NumericType)source.getType();
        SourceAndConverter soc = BigDataViewer.wrapWithTransformedSource((SourceAndConverter)new SourceAndConverter(source, BigDataViewer.createConverterToARGB((NumericType)type)));
        converterSetups.add(BigDataViewer.createConverterSetup((SourceAndConverter)soc, (int)setupId));
        sources.add(soc);
    }

    private static <T> BvvStackSource<T> addSpimDataSource(BvvHandle handle, SourceAndConverter<T> source, int numTimepoints) {
        ConverterSetup setup = BigDataViewer.createConverterSetup(source, (int)handle.getUnusedSetupId());
        List<ConverterSetup> setups = Collections.singletonList(setup);
        List<SourceAndConverter<T>> sources = Collections.singletonList(source);
        handle.add(setups, sources, numTimepoints);
        Object type = source.getSpimSource().getType();
        BvvStackSource<Object> bdvSource = new BvvStackSource<Object>(handle, numTimepoints, type, setups, sources);
        handle.addBvvSource(bdvSource);
        return bdvSource;
    }
}

