/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.util;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.scijava.listeners.Listeners;

public class HotLoadingUtils {
    private static final Map<String, FilePair> files = new HashMap<String, FilePair>();

    private static void add(String f, Runnable runnable) {
        HotLoadingUtils.files.computeIfAbsent((String)f, (Function<String, FilePair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Lbvv/core/util/HotLoadingUtils$FilePair;)()).listeners.add((Object)runnable);
    }

    private static void checkModified() {
        try {
            for (FilePair file : files.values()) {
                file.checkModified();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static class ShaderHotLoader {
        private final AtomicBoolean modified;
        private final Runnable setModified;

        public ShaderHotLoader(String ... filesToWatch) {
            this(false, filesToWatch);
        }

        public ShaderHotLoader(boolean initiallyModified, String ... filesToWatch) {
            this.modified = new AtomicBoolean(initiallyModified);
            this.setModified = () -> this.modified.set(true);
            for (String f : filesToWatch) {
                HotLoadingUtils.add(f, this.setModified);
            }
        }

        public ShaderHotLoader watch(Class<?> resourceContext, String resourceName) {
            this.watch(resourceContext.getResource(resourceName).getFile());
            return this;
        }

        public ShaderHotLoader watch(String filename) {
            HotLoadingUtils.add(filename, this.setModified);
            return this;
        }

        public boolean isModified() {
            HotLoadingUtils.checkModified();
            return this.modified.getAndSet(false);
        }
    }

    static class FilePair {
        private final File target;
        private final File resource;
        private long lastModified;
        public final Listeners.List<Runnable> listeners = new Listeners.List();

        FilePair(String targetName) {
            this.target = new File(targetName);
            this.resource = new File(targetName.replaceAll("target/classes", "src/main/resources"));
            this.lastModified = this.resource.lastModified();
        }

        void checkModified() throws IOException {
            long mod = this.resource.lastModified();
            if (mod != this.lastModified) {
                this.lastModified = mod;
                Files.copy(this.resource.toPath(), this.target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.listeners.list.forEach(Runnable::run);
            }
        }
    }
}

