/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.shadergen.generate;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.stringtemplate.v4.ST;

public class StringTemplateUtils {
    public static ST loadAndPatchSnippet(Class<?> resourceContext, String resourceName, List<String> keys) throws IOException {
        String line;
        ArrayList<String> searchList = new ArrayList<String>();
        ArrayList<String> replacementList = new ArrayList<String>();
        for (String key : keys) {
            searchList.add(key);
            replacementList.add("$" + key + "$");
        }
        String[] search = searchList.toArray(new String[0]);
        String[] replace = replacementList.toArray(new String[0]);
        searchList.add("}");
        replacementList.add("\\}");
        String[] searchInRepeat = searchList.toArray(new String[0]);
        String[] replaceInRepeat = replacementList.toArray(new String[0]);
        String REPEAT = "repeat";
        String PAT_REPEAT = "$repeat:{";
        boolean REPEAT_START = true;
        String INSERT = "insert";
        String PAT_INSERT = "$insert{";
        int INSERT_START = "$insert{".length();
        int PAT_INSERT_END = 125;
        InputStream stream = resourceContext.getResourceAsStream(resourceName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder builder = new StringBuilder();
        boolean inRepeatBlock = false;
        while ((line = reader.readLine()) != null) {
            int ri;
            int ii = line.indexOf("$insert{");
            if (ii != -1) {
                int lws;
                for (lws = 0; lws < line.length() && line.charAt(lws) <= ' '; ++lws) {
                }
                int ie = line.indexOf(125, ii);
                line = line.substring(0, lws) + line.substring(ii + INSERT_START, ie);
            }
            if ((ri = line.indexOf("$repeat:{")) != -1) {
                if (inRepeatBlock) {
                    throw new IllegalArgumentException();
                }
                int re = line.indexOf("|", ri + "$repeat:{".length());
                if (re == -1) {
                    throw new IllegalArgumentException();
                }
                String args = line.substring(ri + "$repeat:{".length(), re);
                line = line.substring(0, ri + 1) + args + line.substring(ri + 1 + "repeat".length(), re + 1) + "\n";
                builder.append(line);
                inRepeatBlock = true;
            } else if (inRepeatBlock) {
                if (line.contains("}$")) {
                    inRepeatBlock = false;
                } else {
                    builder.append(StringUtils.replaceEach(line, searchInRepeat, replaceInRepeat));
                }
            }
            if (!inRepeatBlock) {
                builder.append(StringUtils.replaceEach(line, search, replace));
            }
            builder.append("\n");
        }
        String snippet = builder.toString();
        return new ST(snippet, '$', '$');
    }

    public static void clearAttributes(ST st) {
        if (st.getAttributes() != null) {
            new ArrayList(st.getAttributes().keySet()).forEach(arg_0 -> ((ST)st).remove(arg_0));
        }
    }
}

