/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.shadergen.generate;

import bvv.core.shadergen.generate.Segment;
import bvv.core.shadergen.generate.SegmentTemplate;
import bvv.core.shadergen.generate.SegmentedShader;
import java.util.HashMap;
import java.util.Map;

public class SegmentedShaderBuilder {
    static final Object NOT_UNIQUE = new Object();
    private final Map<String, Object> uniforms = new HashMap<String, Object>();
    private final StringBuilder vpCode = new StringBuilder();
    private final StringBuilder fpCode = new StringBuilder();

    private void add(Segment segment, StringBuilder code) {
        Map<String, SegmentTemplate.Identifier> map = segment.getKeyToIdentifierMap();
        map.forEach((name, identifier) -> this.uniforms.compute((String)name, (n, value) -> {
            if (value == null && !identifier.isList()) {
                return (String)identifier.value();
            }
            return NOT_UNIQUE;
        }));
        code.append(segment.getCode());
    }

    public SegmentedShaderBuilder fragment(Segment segment) {
        this.add(segment, this.fpCode);
        return this;
    }

    public SegmentedShaderBuilder vertex(Segment segment) {
        this.add(segment, this.vpCode);
        return this;
    }

    public SegmentedShader build() {
        return new SegmentedShader(this.vpCode, this.fpCode, this.uniforms);
    }
}

