/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.shadergen.generate;

import bvv.core.shadergen.generate.SegmentTemplate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Segment {
    private final SegmentTemplate template;
    private final Map<String, SegmentTemplate.Identifier> keyToIdentifier;
    private String code = null;

    Segment(SegmentTemplate template, Map<String, SegmentTemplate.Identifier> keyToIdentifier) {
        this.template = template;
        this.keyToIdentifier = keyToIdentifier;
    }

    public synchronized String getCode() {
        if (this.code == null) {
            this.code = this.template.render(this.keyToIdentifier);
        }
        return this.code;
    }

    public synchronized Segment bind(String key, Segment segment, String segmentKey) {
        if (this.code != null) {
            throw new IllegalStateException("trying to bind identifiers after code has been already generated.");
        }
        this.keyToIdentifier.put(key, segment.getIdentifier(segmentKey));
        return this;
    }

    public Segment bind(String key, Segment segment) {
        return this.bind(key, segment, key);
    }

    public synchronized Segment bind(String key, int index, Segment segment, String segmentKey) {
        SegmentTemplate.Identifier value;
        if (this.code != null) {
            throw new IllegalStateException("trying to bind identifiers after code has been already generated.");
        }
        SegmentTemplate.Identifier identifier = this.keyToIdentifier.get(key);
        if (!identifier.isList()) {
            identifier = new SegmentTemplate.Identifier();
            this.keyToIdentifier.put(key, identifier);
        }
        if ((value = segment.getIdentifier(segmentKey)).isList()) {
            throw new IllegalArgumentException("Key '" + key + "' in the segment maps to a list of identifiers. Expected single identifier.");
        }
        identifier.put(index, (String)value.value());
        return this;
    }

    public Segment bind(String key, int index, Segment segment) {
        return this.bind(key, index, segment, key);
    }

    public synchronized Segment repeat(String key, int num) {
        this.keyToIdentifier.put(key, SegmentTemplate.proposeIdentifiers(key, num));
        return this;
    }

    public synchronized Segment repeat(List<String> keys, int num) {
        keys.forEach(k -> this.repeat((String)k, num));
        return this;
    }

    public synchronized void insert(String key, Segment ... segments) {
        this.insert(key, Arrays.asList(segments));
    }

    public synchronized void insert(String key, Collection<Segment> segments) {
        StringBuilder sb = new StringBuilder("\n");
        for (Segment segment : segments) {
            sb.append(segment.getCode());
        }
        this.keyToIdentifier.put(key, new SegmentTemplate.Identifier(sb.toString()));
    }

    SegmentTemplate.Identifier getIdentifier(String key) {
        SegmentTemplate.Identifier identifier = this.keyToIdentifier.get(key);
        if (identifier == null) {
            throw new IllegalArgumentException("Key '" + key + "' does not exist.");
        }
        return identifier;
    }

    String getSingleIdentifier(String key) {
        SegmentTemplate.Identifier identifier = this.keyToIdentifier.get(key);
        if (identifier == null) {
            throw new IllegalArgumentException("Key '" + key + "' does not exist.");
        }
        if (identifier.isList()) {
            throw new IllegalArgumentException("Key '" + key + "' maps to a list of identifiers. Expected single identifier.");
        }
        return (String)identifier.value();
    }

    Map<String, SegmentTemplate.Identifier> getKeyToIdentifierMap() {
        return this.keyToIdentifier;
    }
}

