/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.render;

import bvv.core.backend.GpuContext;
import bvv.core.backend.Texture;
import bvv.core.backend.Texture3D;
import java.nio.Buffer;

public class VolumeTextureU16
implements Texture3D {
    private final int[] size = new int[3];

    public void init(int[] size) {
        for (int d = 0; d < 3; ++d) {
            this.size[d] = size[d];
        }
    }

    public void upload(GpuContext context, Buffer data) {
        context.delete(this);
        context.texSubImage3D(this, 0, 0, 0, this.texWidth(), this.texHeight(), this.texDepth(), data);
    }

    @Override
    public Texture.InternalFormat texInternalFormat() {
        return Texture.InternalFormat.R16;
    }

    @Override
    public int texWidth() {
        return this.size[0];
    }

    @Override
    public int texHeight() {
        return this.size[1];
    }

    @Override
    public int texDepth() {
        return this.size[2];
    }

    @Override
    public Texture.MinFilter texMinFilter() {
        return Texture.MinFilter.LINEAR;
    }

    @Override
    public Texture.MagFilter texMagFilter() {
        return Texture.MagFilter.LINEAR;
    }

    @Override
    public Texture.Wrap texWrap() {
        return Texture.Wrap.CLAMP_TO_BORDER_ZERO;
    }
}

