/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.render;

import bvv.core.multires.SourceStacks;
import java.util.ArrayList;
import java.util.List;

public final class VolumeShaderSignature {
    private final List<VolumeSignature> volumeSignatures;

    public VolumeShaderSignature(List<VolumeSignature> volumeSignatures) {
        this.volumeSignatures = new ArrayList<VolumeSignature>(volumeSignatures);
    }

    public List<VolumeSignature> getVolumeSignatures() {
        return this.volumeSignatures;
    }

    public final int numVolumes() {
        return this.volumeSignatures.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VolumeShaderSignature)) {
            return false;
        }
        VolumeShaderSignature that = (VolumeShaderSignature)o;
        return this.volumeSignatures.equals(that.volumeSignatures);
    }

    public int hashCode() {
        return this.volumeSignatures.hashCode();
    }

    public static final class VolumeSignature {
        private final SourceStacks.SourceStackType sourceStackType;
        private final PixelType pixelType;

        public VolumeSignature(SourceStacks.SourceStackType sourceStackType, PixelType pixelType) {
            this.sourceStackType = sourceStackType;
            this.pixelType = pixelType;
        }

        public SourceStacks.SourceStackType getSourceStackType() {
            return this.sourceStackType;
        }

        public PixelType getPixelType() {
            return this.pixelType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VolumeSignature)) {
                return false;
            }
            VolumeSignature that = (VolumeSignature)o;
            return this.sourceStackType == that.sourceStackType && this.pixelType == that.pixelType;
        }

        public int hashCode() {
            int result = this.sourceStackType.hashCode();
            result = 31 * result + this.pixelType.hashCode();
            return result;
        }
    }

    public static enum PixelType {
        USHORT,
        UBYTE,
        ARGB;

    }
}

