/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.render;

import bdv.tools.brightness.ConverterSetup;
import bvv.core.backend.Texture;
import bvv.core.backend.jogl.JoglGpuContext;
import bvv.core.blocks.TileAccess;
import bvv.core.cache.CacheSpec;
import bvv.core.cache.FillTask;
import bvv.core.cache.PboChain;
import bvv.core.cache.ProcessFillTasks;
import bvv.core.cache.TextureCache;
import bvv.core.dither.DitherBuffer;
import bvv.core.multires.MultiResolutionStack3D;
import bvv.core.multires.SimpleStack3D;
import bvv.core.multires.SourceStacks;
import bvv.core.multires.Stack3D;
import bvv.core.offscreen.OffScreenFrameBufferWithDepth;
import bvv.core.render.DefaultSimpleStackManager;
import bvv.core.render.MultiVolumeShaderMip;
import bvv.core.render.SimpleStackManager;
import bvv.core.render.SimpleVolume;
import bvv.core.render.VolumeBlocks;
import bvv.core.render.VolumeShaderSignature;
import bvv.core.util.DefaultQuad;
import com.jogamp.opengl.GL3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class VolumeRenderer {
    private final int renderWidth;
    private final int renderHeight;
    private final Repaint nextRequestedRepaint = new Repaint();
    private int ditherStep = 0;
    private int targetDitherSteps = 0;
    private MultiVolumeShaderMip progvol;
    private final DitherBuffer dither;
    private final int numDitherSteps;
    private final CacheSpec cacheSpec;
    private final TextureCache textureCache;
    private final PboChain pboChain;
    private final ForkJoinPool forkJoinPool;
    private final HashMap<VolumeShaderSignature, MultiVolumeShaderMip> progvols;
    private final ArrayList<VolumeBlocks> volumes;
    private final SimpleStackManager simpleStackManager = new DefaultSimpleStackManager();
    private final DefaultQuad quad;

    public VolumeRenderer(int renderWidth, int renderHeight, int ditherWidth, int ditherStep, int numDitherSamples, int[] cacheBlockSize, int maxCacheSizeInMB) {
        this.renderWidth = renderWidth;
        this.renderHeight = renderHeight;
        this.cacheSpec = new CacheSpec(Texture.InternalFormat.R16, cacheBlockSize);
        int[] cacheGridDimensions = TextureCache.findSuitableGridSize(this.cacheSpec, maxCacheSizeInMB);
        this.textureCache = new TextureCache(cacheGridDimensions, this.cacheSpec);
        this.pboChain = new PboChain(5, 100, this.textureCache);
        int parallelism = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        this.forkJoinPool = new ForkJoinPool(parallelism);
        if (ditherWidth <= 1) {
            this.dither = null;
            this.numDitherSteps = 1;
        } else {
            this.dither = new DitherBuffer(renderWidth, renderHeight, ditherWidth, ditherStep, numDitherSamples);
            this.numDitherSteps = this.dither.numSteps();
        }
        this.volumes = new ArrayList();
        this.progvols = new HashMap();
        this.progvols.put(new VolumeShaderSignature(Collections.emptyList()), null);
        this.quad = new DefaultQuad();
    }

    private void needAtLeastNumBlockVolumes(int n) {
        while (this.volumes.size() < n) {
            this.volumes.add(new VolumeBlocks(this.textureCache));
        }
    }

    private MultiVolumeShaderMip createMultiVolumeShader(VolumeShaderSignature signature) {
        MultiVolumeShaderMip progvol = new MultiVolumeShaderMip(signature, true, 1.0);
        progvol.setTextureCache(this.textureCache);
        return progvol;
    }

    public void init(GL3 gl) {
        gl.glPixelStorei(3317, 1);
    }

    public RepaintType draw(GL3 gl, RepaintType type, OffScreenFrameBufferWithDepth sceneBuf, List<Stack3D<?>> renderStacks, List<ConverterSetup> renderConverters, Matrix4f pv, int maxRenderMillis, double maxAllowedStepInVoxels) {
        long maxRenderNanoTime = System.nanoTime() + 1000000L * (long)maxRenderMillis;
        JoglGpuContext context = JoglGpuContext.get(gl);
        this.nextRequestedRepaint.type = RepaintType.NONE;
        if (renderStacks.isEmpty()) {
            return this.nextRequestedRepaint.type;
        }
        gl.glEnable(2929);
        gl.glDepthFunc(519);
        if (type == RepaintType.FULL) {
            this.ditherStep = 0;
            this.targetDitherSteps = this.numDitherSteps;
        } else if (type == RepaintType.LOAD) {
            this.targetDitherSteps = this.ditherStep + this.numDitherSteps;
        }
        if (type == RepaintType.FULL || type == RepaintType.LOAD) {
            ArrayList<VolumeShaderSignature.VolumeSignature> volumeSignatures = new ArrayList<VolumeShaderSignature.VolumeSignature>();
            ArrayList<MultiResolutionStack3D> multiResStacks = new ArrayList<MultiResolutionStack3D>();
            for (int i = 0; i < renderStacks.size(); ++i) {
                Stack3D<?> stack = renderStacks.get(i);
                if (stack instanceof MultiResolutionStack3D) {
                    if (!TileAccess.isSupportedType(stack.getType())) {
                        throw new IllegalArgumentException();
                    }
                    multiResStacks.add((MultiResolutionStack3D)stack);
                    volumeSignatures.add(new VolumeShaderSignature.VolumeSignature(SourceStacks.SourceStackType.MULTIRESOLUTION, VolumeShaderSignature.PixelType.USHORT));
                    continue;
                }
                if (stack instanceof SimpleStack3D) {
                    Object pixelType = stack.getType();
                    if (pixelType instanceof UnsignedShortType) {
                        volumeSignatures.add(new VolumeShaderSignature.VolumeSignature(SourceStacks.SourceStackType.SIMPLE, VolumeShaderSignature.PixelType.USHORT));
                        continue;
                    }
                    if (pixelType instanceof UnsignedByteType) {
                        volumeSignatures.add(new VolumeShaderSignature.VolumeSignature(SourceStacks.SourceStackType.SIMPLE, VolumeShaderSignature.PixelType.UBYTE));
                        continue;
                    }
                    if (pixelType instanceof ARGBType) {
                        volumeSignatures.add(new VolumeShaderSignature.VolumeSignature(SourceStacks.SourceStackType.SIMPLE, VolumeShaderSignature.PixelType.ARGB));
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
                throw new IllegalArgumentException();
            }
            this.needAtLeastNumBlockVolumes(multiResStacks.size());
            this.updateBlocks(context, multiResStacks, pv);
            double minWorldVoxelSize = Double.POSITIVE_INFINITY;
            this.progvol = this.progvols.computeIfAbsent(new VolumeShaderSignature(volumeSignatures), this::createMultiVolumeShader);
            if (this.progvol != null) {
                int mri = 0;
                for (int i = 0; i < renderStacks.size(); ++i) {
                    this.progvol.setConverter(i, renderConverters.get(i));
                    if (((VolumeShaderSignature.VolumeSignature)volumeSignatures.get(i)).getSourceStackType() == SourceStacks.SourceStackType.MULTIRESOLUTION) {
                        VolumeBlocks volume = this.volumes.get(mri++);
                        this.progvol.setVolume(i, volume);
                        minWorldVoxelSize = Math.min(minWorldVoxelSize, volume.getBaseLevelVoxelSizeInWorldCoordinates());
                        continue;
                    }
                    SimpleStack3D simpleStack3D = (SimpleStack3D)renderStacks.get(i);
                    SimpleVolume volume = this.simpleStackManager.getSimpleVolume(context, simpleStack3D);
                    this.progvol.setVolume(i, volume);
                    minWorldVoxelSize = Math.min(minWorldVoxelSize, volume.getVoxelSizeInWorldCoordinates());
                }
                this.progvol.setDepthTexture(sceneBuf.getDepthTexture());
                this.progvol.setViewportWidth(this.renderWidth);
                this.progvol.setProjectionViewMatrix((Matrix4fc)pv, maxAllowedStepInVoxels * minWorldVoxelSize);
            }
            this.simpleStackManager.freeUnusedSimpleVolumes(context);
        }
        if (this.progvol != null) {
            if (this.dither != null) {
                if (this.ditherStep != this.targetDitherSteps) {
                    this.dither.bind(gl);
                    this.progvol.use(context);
                    this.progvol.bindSamplers(context);
                    gl.glDisable(3042);
                    while (this.ditherStep < this.targetDitherSteps) {
                        this.progvol.setDither(this.dither, this.ditherStep % this.numDitherSteps);
                        this.progvol.setUniforms(context);
                        this.quad.draw(gl);
                        gl.glFinish();
                        ++this.ditherStep;
                        if (System.nanoTime() <= maxRenderNanoTime) continue;
                    }
                    this.dither.unbind(gl);
                }
                gl.glEnable(3042);
                gl.glBlendFunc(770, 771);
                int stepsCompleted = Math.min(this.ditherStep, this.numDitherSteps);
                this.dither.dither(gl, stepsCompleted, this.renderWidth, this.renderHeight);
                if (this.ditherStep != this.targetDitherSteps) {
                    this.nextRequestedRepaint.request(RepaintType.DITHER);
                }
            } else {
                gl.glEnable(3042);
                gl.glBlendFunc(770, 771);
                this.progvol.use(context);
                this.progvol.bindSamplers(context);
                this.progvol.setEffectiveViewportSize(this.renderWidth, this.renderHeight);
                this.progvol.setUniforms(context);
                this.quad.draw(gl);
            }
        }
        return this.nextRequestedRepaint.type;
    }

    private void updateBlocks(JoglGpuContext context, List<? extends MultiResolutionStack3D<?>> multiResStacks, Matrix4f pv) {
        boolean bl;
        ArrayList<VolumeAndTasks> tasksPerVolume = new ArrayList<VolumeAndTasks>();
        int numTasks = 0;
        for (int i = 0; i < multiResStacks.size(); ++i) {
            MultiResolutionStack3D<?> multiResolutionStack3D = multiResStacks.get(i);
            VolumeBlocks volume = this.volumes.get(i);
            volume.init(multiResolutionStack3D, this.renderWidth, (Matrix4fc)pv);
            List<FillTask> tasks = volume.getFillTasks();
            numTasks += tasks.size();
            tasksPerVolume.add(new VolumeAndTasks(tasks, volume, multiResolutionStack3D.resolutions().size() - 1));
        }
        block3: while (numTasks > this.textureCache.getMaxNumTiles()) {
            tasksPerVolume.sort(Comparator.comparingInt(VolumeAndTasks::numTasks).reversed());
            for (VolumeAndTasks volumeAndTasks : tasksPerVolume) {
                int baseLevel = volumeAndTasks.volume.getBaseLevel();
                if (baseLevel >= volumeAndTasks.maxLevel) continue;
                volumeAndTasks.volume.setBaseLevel(baseLevel + 1);
                numTasks -= volumeAndTasks.numTasks();
                volumeAndTasks.tasks.clear();
                volumeAndTasks.tasks.addAll(volumeAndTasks.volume.getFillTasks());
                numTasks += volumeAndTasks.numTasks();
                continue block3;
            }
        }
        ArrayList fillTasks = new ArrayList();
        for (VolumeAndTasks vat : tasksPerVolume) {
            fillTasks.addAll(vat.tasks);
        }
        if (fillTasks.size() > this.textureCache.getMaxNumTiles()) {
            fillTasks.subList(this.textureCache.getMaxNumTiles(), fillTasks.size()).clear();
        }
        try {
            ProcessFillTasks.parallel(this.textureCache, this.pboChain, context, this.forkJoinPool, fillTasks);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        boolean bl2 = false;
        int timestamp = this.textureCache.nextTimestamp();
        for (int i = 0; i < multiResStacks.size(); ++i) {
            VolumeBlocks volume = this.volumes.get(i);
            boolean complete = volume.makeLut(timestamp);
            if (!complete) {
                bl = true;
            }
            volume.getLookupTexture().upload(context);
        }
        if (bl) {
            this.nextRequestedRepaint.request(RepaintType.LOAD);
        }
    }

    static class VolumeAndTasks {
        private final List<FillTask> tasks;
        private final VolumeBlocks volume;
        private final int maxLevel;

        int numTasks() {
            return this.tasks.size();
        }

        VolumeAndTasks(List<FillTask> tasks, VolumeBlocks volume, int maxLevel) {
            this.tasks = new ArrayList<FillTask>(tasks);
            this.volume = volume;
            this.maxLevel = maxLevel;
        }
    }

    private static class Repaint {
        RepaintType type = RepaintType.NONE;

        Repaint() {
        }

        void request(RepaintType type) {
            if (this.type.ordinal() < type.ordinal()) {
                this.type = type;
            }
        }
    }

    public static enum RepaintType {
        NONE,
        SCENE,
        DITHER,
        LOAD,
        FULL;

    }
}

