/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.render;

import bvv.core.blockmath.FindRequiredBlocks;
import bvv.core.blockmath.MipmapSizes;
import bvv.core.blockmath.RequiredBlock;
import bvv.core.blockmath.RequiredBlocks;
import bvv.core.blocks.TileAccess;
import bvv.core.cache.CacheSpec;
import bvv.core.cache.DefaultFillTask;
import bvv.core.cache.FillTask;
import bvv.core.cache.ImageBlockKey;
import bvv.core.cache.TextureCache;
import bvv.core.cache.UploadBuffer;
import bvv.core.multires.MultiResolutionStack3D;
import bvv.core.multires.ResolutionLevel3D;
import bvv.core.render.LookupTextureARGB;
import bvv.core.util.MatrixMath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VolumeBlocks {
    private final TextureCache textureCache;
    private final CacheSpec cacheSpec;
    private final LookupTextureARGB lut;
    private final TileAccess.Cache tileAccess;
    private final MipmapSizes sizes;
    private MultiResolutionStack3D<?> multiResolutionStack;
    final Matrix4f pvm = new Matrix4f();
    private int baseLevel;
    private RequiredBlocks requiredBlocks;

    public VolumeBlocks(TextureCache textureCache) {
        this.textureCache = textureCache;
        this.cacheSpec = textureCache.spec();
        this.lut = new LookupTextureARGB();
        this.tileAccess = new TileAccess.Cache();
        this.sizes = new MipmapSizes();
    }

    public void init(MultiResolutionStack3D<?> multiResolutionStack, int viewportWidth, Matrix4fc pv) {
        this.multiResolutionStack = multiResolutionStack;
        Matrix4f model = MatrixMath.affine(multiResolutionStack.getSourceTransform(), new Matrix4f());
        this.pvm.set(pv).mul((Matrix4fc)model);
        this.sizes.init((Matrix4fc)this.pvm, viewportWidth, multiResolutionStack.resolutions());
        this.baseLevel = this.sizes.getBaseLevel();
    }

    public int getBaseLevel() {
        return this.baseLevel;
    }

    public void setBaseLevel(int baseLevel) {
        this.baseLevel = baseLevel;
    }

    public double getBaseLevelVoxelSizeInWorldCoordinates() {
        AffineTransform3D sourceToWorld = this.multiResolutionStack.getSourceTransform();
        int[] r = this.multiResolutionStack.resolutions().get(this.baseLevel).getR();
        double[] tzero = new double[3];
        sourceToWorld.apply(new double[3], tzero);
        double[] one = new double[3];
        double[] tone = new double[3];
        double voxelSize = Double.POSITIVE_INFINITY;
        for (int i = 0; i < 3; ++i) {
            for (int d = 0; d < 3; ++d) {
                one[d] = d == i ? (double)r[d] : 0.0;
            }
            sourceToWorld.apply(one, tone);
            LinAlgHelpers.subtract((double[])tone, (double[])tzero, (double[])tone);
            voxelSize = Math.min(voxelSize, LinAlgHelpers.length((double[])tone));
        }
        return voxelSize;
    }

    public List<FillTask> getFillTasks() {
        this.requiredBlocks = this.getRequiredBlocks(this.baseLevel);
        this.assignBestLevels(this.requiredBlocks, this.baseLevel, this.baseLevel);
        List<FillTask> fillTasks = this.getFillTasks(this.requiredBlocks, this.baseLevel);
        return fillTasks;
    }

    public boolean makeLut(int timestamp) {
        int[] rmin = this.requiredBlocks.getMin();
        int[] rmax = this.requiredBlocks.getMax();
        this.lut.init(rmin, rmax, this.baseLevel);
        boolean complete = true;
        int maxLevel = this.multiResolutionStack.resolutions().size() - 1;
        int[] r = this.multiResolutionStack.resolutions().get(this.baseLevel).getR();
        int[] gj = new int[3];
        block0: for (RequiredBlock block : this.requiredBlocks.getBlocks()) {
            int[] g0 = block.getGridPos();
            for (int level = block.getBestLevel(); level <= maxLevel; ++level) {
                ResolutionLevel3D<?> resolution = this.multiResolutionStack.resolutions().get(level);
                double[] sj = resolution.getS();
                for (int d = 0; d < 3; ++d) {
                    gj[d] = (int)((double)g0[d] * sj[d] * (double)r[d]);
                }
                TextureCache.Tile tile = this.textureCache.get(new ImageBlockKey(resolution, gj));
                if (tile != null) {
                    tile.useAtTimestamp(timestamp);
                    this.lut.putTile(g0, tile, level);
                    if (level == block.getBestLevel() && tile.state() != TextureCache.ContentState.INCOMPLETE) continue block0;
                    complete = false;
                    continue block0;
                }
                if (level != maxLevel) continue;
                complete = false;
            }
        }
        return complete;
    }

    public float[][] getLutBlockScales(int NUM_BLOCK_SCALES) {
        float[][] lutBlockScales = new float[NUM_BLOCK_SCALES][3];
        int[] r = this.multiResolutionStack.resolutions().get(this.baseLevel).getR();
        for (int d = 0; d < 3; ++d) {
            lutBlockScales[0][d] = 0.0f;
        }
        int maxLevel = this.multiResolutionStack.resolutions().size() - 1;
        for (int level = this.baseLevel; level <= maxLevel; ++level) {
            ResolutionLevel3D<?> resolution = this.multiResolutionStack.resolutions().get(level);
            double[] sj = resolution.getS();
            int i = 1 + level - this.baseLevel;
            for (int d = 0; d < 3; ++d) {
                lutBlockScales[i][d] = (float)(sj[d] * (double)r[d]);
            }
        }
        return lutBlockScales;
    }

    public Matrix4f getIms() {
        return MatrixMath.affine(this.multiResolutionStack.getSourceTransform(), new Matrix4f()).mul((Matrix4fc)this.getUpscale(this.baseLevel)).invert();
    }

    public Vector3f getSourceLevelMin() {
        RandomAccessibleInterval<?> lbb = this.multiResolutionStack.resolutions().get(this.baseLevel).getImage();
        Vector3f sourceLevelMin = new Vector3f((float)lbb.min(0), (float)lbb.min(1), (float)lbb.min(2));
        return sourceLevelMin;
    }

    public Vector3f getSourceLevelMax() {
        RandomAccessibleInterval<?> lbb = this.multiResolutionStack.resolutions().get(this.baseLevel).getImage();
        Vector3f sourceLevelMax = new Vector3f((float)lbb.max(0), (float)lbb.max(1), (float)lbb.max(2));
        return sourceLevelMax;
    }

    public LookupTextureARGB getLookupTexture() {
        return this.lut;
    }

    private RequiredBlocks getRequiredBlocks(int baseLevel) {
        Matrix4f pvms = this.pvm.mul((Matrix4fc)this.getUpscale(baseLevel), new Matrix4f());
        long[] gridMin = new long[3];
        long[] gridMax = new long[3];
        this.getGridMinMax(baseLevel, gridMin, gridMax);
        return FindRequiredBlocks.getRequiredLevelBlocksFrustum((Matrix4fc)pvms, this.cacheSpec.blockSize(), gridMin, gridMax);
    }

    private void assignBestLevels(RequiredBlocks requiredBlocks, int baseLevel, int minLevel) {
        int[] r = this.multiResolutionStack.resolutions().get(baseLevel).getR();
        int[] blockSize = this.cacheSpec.blockSize();
        int[] scale = new int[]{blockSize[0] * r[0], blockSize[1] * r[1], blockSize[2] * r[2]};
        Vector3f blockCenter = new Vector3f();
        Vector3f tmp = new Vector3f();
        for (RequiredBlock block : requiredBlocks.getBlocks()) {
            int[] g0 = block.getGridPos();
            blockCenter.set(((float)g0[0] + 0.5f) * (float)scale[0], ((float)g0[1] + 0.5f) * (float)scale[1], ((float)g0[2] + 0.5f) * (float)scale[2]);
            int bestLevel = Math.max(minLevel, this.sizes.bestLevel((Vector3fc)blockCenter, tmp));
            block.setBestLevel(bestLevel);
        }
    }

    private List<FillTask> getFillTasks(RequiredBlocks requiredBlocks, int baseLevel) {
        int maxLevel = this.multiResolutionStack.resolutions().size() - 1;
        int[] r = this.multiResolutionStack.resolutions().get(baseLevel).getR();
        HashSet existingKeys = new HashSet();
        ArrayList<FillTask> fillTasks = new ArrayList<FillTask>();
        int[] gj = new int[3];
        block0: for (RequiredBlock block : requiredBlocks.getBlocks()) {
            int[] g0 = block.getGridPos();
            for (int level = block.getBestLevel(); level <= maxLevel; ++level) {
                ResolutionLevel3D<?> resolution = this.multiResolutionStack.resolutions().get(level);
                double[] sj = resolution.getS();
                for (int d = 0; d < 3; ++d) {
                    gj[d] = (int)((double)g0[d] * sj[d] * (double)r[d]);
                }
                ImageBlockKey key = new ImageBlockKey(resolution, gj);
                if (existingKeys.contains(key)) continue block0;
                existingKeys.add(key);
                TextureCache.Tile tile = this.textureCache.get(key);
                if (tile == null && !this.canLoadCompletely(key) && level != maxLevel) continue;
                fillTasks.add(new DefaultFillTask(key, buf -> this.loadTile(key, (UploadBuffer)buf), () -> this.containsData(key)));
                continue block0;
            }
        }
        return fillTasks;
    }

    private boolean canLoadCompletely(ImageBlockKey<ResolutionLevel3D<?>> key) {
        return this.tileAccess.get(key.image(), this.cacheSpec).canLoadCompletely(key.pos(), false);
    }

    private boolean containsData(ImageBlockKey<ResolutionLevel3D<?>> key) {
        return this.tileAccess.get(key.image(), this.cacheSpec).canLoadCompletely(key.pos(), true);
    }

    private boolean loadTile(ImageBlockKey<ResolutionLevel3D<?>> key, UploadBuffer buffer) {
        return this.tileAccess.get(key.image(), this.cacheSpec).loadTile(key.pos(), buffer);
    }

    private void getGridMinMax(int level, long[] gridMin, long[] gridMax) {
        Matrix4f ipvms = this.pvm.mul((Matrix4fc)this.getUpscale(level), new Matrix4f()).invert();
        RandomAccessibleInterval<?> lbb = this.multiResolutionStack.resolutions().get(level).getImage();
        Vector3f fbbmin = new Vector3f();
        Vector3f fbbmax = new Vector3f();
        ipvms.frustumAabb(fbbmin, fbbmax);
        for (int d = 0; d < 3; ++d) {
            float lbbmin = lbb.min(d);
            float lbbmax = lbb.max(d);
            gridMin[d] = (long)(Math.max(fbbmin.get(d), lbbmin) / (float)this.cacheSpec.blockSize()[d]);
            gridMax[d] = (long)(Math.min(fbbmax.get(d), lbbmax) / (float)this.cacheSpec.blockSize()[d]);
        }
    }

    private Matrix4f getUpscale(int level) {
        return this.getUpscale(level, new Matrix4f());
    }

    private Matrix4f getUpscale(int level, Matrix4f dest) {
        int[] r = this.multiResolutionStack.resolutions().get(level).getR();
        int bsx = r[0];
        int bsy = r[1];
        int bsz = r[2];
        return dest.set((float)bsx, 0.0f, 0.0f, 0.0f, 0.0f, (float)bsy, 0.0f, 0.0f, 0.0f, 0.0f, (float)bsz, 0.0f, 0.5f * (float)(bsx - 1), 0.5f * (float)(bsy - 1), 0.5f * (float)(bsz - 1), 1.0f);
    }
}

