/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.render;

import bvv.core.backend.Texture3D;
import bvv.core.util.MatrixMath;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SimpleVolume {
    private final Texture3D texture;
    private final AffineTransform3D sourceToWorld;
    private final Vector3f sourceMax;
    private final Matrix4f ims;

    public SimpleVolume(Texture3D texture, AffineTransform3D sourceTransform, Vector3f sourceMin, Vector3f sourceMax) {
        this.texture = texture;
        this.sourceToWorld = sourceTransform;
        this.sourceMax = sourceMax.sub((Vector3fc)sourceMin, new Vector3f());
        AffineTransform3D t = new AffineTransform3D();
        t.translate(new double[]{sourceMin.x(), sourceMin.y(), sourceMin.z()});
        t.preConcatenate(sourceTransform);
        this.ims = MatrixMath.affine(t, new Matrix4f()).invert();
    }

    public Texture3D getVolumeTexture() {
        return this.texture;
    }

    public Matrix4f getIms() {
        return this.ims;
    }

    public double getVoxelSizeInWorldCoordinates() {
        double[] tzero = new double[3];
        this.sourceToWorld.apply(new double[3], tzero);
        double[] one = new double[3];
        double[] tone = new double[3];
        double voxelSize = Double.POSITIVE_INFINITY;
        for (int i = 0; i < 3; ++i) {
            for (int d = 0; d < 3; ++d) {
                one[d] = d == i ? 1.0 : 0.0;
            }
            this.sourceToWorld.apply(one, tone);
            LinAlgHelpers.subtract((double[])tone, (double[])tzero, (double[])tone);
            voxelSize = Math.min(voxelSize, LinAlgHelpers.length((double[])tone));
        }
        return voxelSize;
    }

    public Vector3f getSourceMax() {
        return this.sourceMax;
    }
}

