/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.render;

import net.imglib2.realtransform.AffineTransform3D;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class RenderData {
    private final Matrix4f pv;
    private int timepoint;
    private final AffineTransform3D renderTransformWorldToScreen;
    private double dCam;
    private double dClipNear;
    private double dClipFar;
    private double screenWidth;
    private double screenHeight;

    public RenderData(Matrix4fc pv, int timepoint, AffineTransform3D renderTransformWorldToScreen, double dCam, double dClipNear, double dClipFar, double screenWidth, double screenHeight) {
        this.pv = new Matrix4f(pv);
        this.timepoint = timepoint;
        this.renderTransformWorldToScreen = renderTransformWorldToScreen;
        this.dCam = dCam;
        this.dClipNear = dClipNear;
        this.dClipFar = dClipFar;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public RenderData() {
        this.pv = new Matrix4f();
        this.renderTransformWorldToScreen = new AffineTransform3D();
    }

    public void set(RenderData other) {
        this.pv.set((Matrix4fc)other.pv);
        this.timepoint = other.timepoint;
        this.renderTransformWorldToScreen.set(other.renderTransformWorldToScreen);
        this.dCam = other.dCam;
        this.dClipNear = other.dClipNear;
        this.dClipFar = other.dClipFar;
        this.screenWidth = other.screenWidth;
        this.screenHeight = other.screenHeight;
    }

    public Matrix4f getPv() {
        return this.pv;
    }

    public int getTimepoint() {
        return this.timepoint;
    }

    public AffineTransform3D getRenderTransformWorldToScreen() {
        return this.renderTransformWorldToScreen;
    }

    public double getDCam() {
        return this.dCam;
    }

    public double getDClipNear() {
        return this.dClipNear;
    }

    public double getDClipFar() {
        return this.dClipFar;
    }

    public double getScreenWidth() {
        return this.screenWidth;
    }

    public double getScreenHeight() {
        return this.screenHeight;
    }
}

