/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.offscreen;

import bvv.core.backend.Texture;
import bvv.core.backend.Texture2D;
import bvv.core.backend.jogl.JoglGpuContext;
import bvv.core.shadergen.DefaultShader;
import bvv.core.shadergen.generate.Segment;
import bvv.core.shadergen.generate.SegmentTemplate;
import com.jogamp.opengl.GL3;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.real.FloatType;

public class OffScreenFrameBufferWithDepth {
    private int vaoQuad;
    private final DefaultShader progQuad;
    private int framebuffer;
    private int texColorBuffer;
    private int texDepthBuffer;
    private final Texture2D depthTexture;
    private final int fbWidth;
    private final int fbHeight;
    private final int internalFormat;
    private int[] viewport = new int[4];
    private float[] rgb;
    private float[] depth;
    private Img<FloatType> rgbImg;
    private Img<FloatType> depthImg;
    private boolean framebufferInitialized;
    private boolean quadInitialized;
    private boolean imgsInitialized;
    private boolean imgValid;
    private int restoreFramebuffer;

    public OffScreenFrameBufferWithDepth(int fbWidth, int fbHeight) {
        this(fbWidth, fbHeight, 34837);
    }

    public OffScreenFrameBufferWithDepth(int fbWidth, int fbHeight, int internalFormat) {
        this.fbWidth = fbWidth;
        this.fbHeight = fbHeight;
        this.internalFormat = internalFormat;
        Segment quadvp = new SegmentTemplate(OffScreenFrameBufferWithDepth.class, "osfbquad.vp", new String[0]).instantiate();
        Segment quadfp = new SegmentTemplate(OffScreenFrameBufferWithDepth.class, "osfbquad.fp", new String[0]).instantiate();
        this.progQuad = new DefaultShader(quadvp.getCode(), quadfp.getCode());
        this.depthTexture = new DepthTexture(fbWidth, fbHeight);
    }

    private void initFrameBuffer(GL3 gl) {
        if (this.framebufferInitialized) {
            return;
        }
        this.framebufferInitialized = true;
        int[] tmp = new int[2];
        gl.glGenFramebuffers(1, tmp, 0);
        this.framebuffer = tmp[0];
        gl.glGetIntegerv(36006, tmp, 0);
        this.restoreFramebuffer = tmp[0];
        gl.glBindFramebuffer(36160, this.framebuffer);
        gl.glGenTextures(2, tmp, 0);
        this.texColorBuffer = tmp[0];
        gl.glBindTexture(3553, this.texColorBuffer);
        gl.glTexStorage2D(3553, 1, this.internalFormat, this.fbWidth, this.fbHeight);
        this.texDepthBuffer = tmp[1];
        gl.glBindTexture(3553, this.texDepthBuffer);
        gl.glTexStorage2D(3553, 1, 33190, this.fbWidth, this.fbHeight);
        gl.glBindTexture(3553, 0);
        gl.glFramebufferTexture2D(36160, 36064, 3553, this.texColorBuffer, 0);
        gl.glFramebufferTexture2D(36160, 36096, 3553, this.texDepthBuffer, 0);
        if (gl.glCheckFramebufferStatus(36160) != 36053) {
            System.err.println("ERROR::FRAMEBUFFER:: Framebuffer is not complete!");
        }
        gl.glBindFramebuffer(36160, this.restoreFramebuffer);
        JoglGpuContext.get(gl).registerTexture(this.depthTexture, this.texDepthBuffer);
    }

    private void initQuad(GL3 gl) {
        if (this.quadInitialized) {
            return;
        }
        this.quadInitialized = true;
        float[] verticesQuad = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        int[] tmp = new int[1];
        gl.glGenBuffers(1, tmp, 0);
        int vboQuad = tmp[0];
        gl.glBindBuffer(34962, vboQuad);
        gl.glBufferData(34962, (long)(verticesQuad.length * 4), (Buffer)FloatBuffer.wrap(verticesQuad), 35044);
        gl.glBindBuffer(34962, 0);
        int[] indices = new int[]{0, 3, 1, 1, 3, 2};
        gl.glGenBuffers(1, tmp, 0);
        int eboQuad = tmp[0];
        gl.glBindBuffer(34963, eboQuad);
        gl.glBufferData(34963, (long)(indices.length * 4), (Buffer)IntBuffer.wrap(indices), 35044);
        gl.glBindBuffer(34963, 0);
        gl.glGenVertexArrays(1, tmp, 0);
        this.vaoQuad = tmp[0];
        gl.glBindVertexArray(this.vaoQuad);
        gl.glBindBuffer(34962, vboQuad);
        gl.glVertexAttribPointer(0, 3, 5126, false, 20, 0L);
        gl.glEnableVertexAttribArray(0);
        gl.glVertexAttribPointer(1, 2, 5126, false, 20, 12L);
        gl.glEnableVertexAttribArray(1);
        gl.glBindBuffer(34963, eboQuad);
        gl.glBindVertexArray(0);
    }

    private void initImgs() {
        System.out.println("OffScreenFrameBufferWithDepth.initImgs");
        if (this.imgsInitialized) {
            return;
        }
        this.imgsInitialized = true;
        this.rgb = new float[this.fbWidth * this.fbHeight * 3];
        this.rgbImg = ArrayImgs.floats((float[])this.rgb, (long[])new long[]{3L, this.fbWidth, this.fbHeight});
        this.depth = new float[this.fbWidth * this.fbHeight];
        this.depthImg = ArrayImgs.floats((float[])this.depth, (long[])new long[]{this.fbWidth, this.fbHeight});
    }

    public void bind(GL3 gl) {
        this.bind(gl, true);
    }

    public void unbind(GL3 gl) {
        this.unbind(gl, true);
    }

    public Img<FloatType> getDepthImg() {
        return this.depthImg;
    }

    public Texture2D getDepthTexture() {
        return this.depthTexture;
    }

    public float get(int c, int x, int y) {
        if (!this.imgValid) {
            System.err.println("Img not valid. Call getTexture() first.");
        }
        RandomAccess a = this.rgbImg.randomAccess();
        a.setPosition(new long[]{c, x, y});
        return ((FloatType)a.get()).get();
    }

    public void bind(GL3 gl, boolean clear) {
        this.initFrameBuffer(gl);
        int[] tmp = new int[1];
        gl.glGetIntegerv(36006, tmp, 0);
        this.restoreFramebuffer = tmp[0];
        gl.glBindFramebuffer(36160, this.framebuffer);
        gl.glGetIntegerv(2978, this.viewport, 0);
        gl.glViewport(0, 0, this.fbWidth, this.fbHeight);
        if (clear) {
            gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            gl.glClear(16640);
        }
    }

    public void unbind(GL3 gl, boolean getTexture) {
        gl.glBindFramebuffer(36160, this.restoreFramebuffer);
        gl.glViewport(this.viewport[0], this.viewport[1], this.viewport[2], this.viewport[3]);
        this.imgValid = false;
        if (getTexture) {
            this.getTexture(gl);
        }
    }

    public void drawQuad(GL3 gl) {
        this.drawQuad(gl, 9729, 9729);
    }

    public void drawQuad(GL3 gl, int minFilter, int magFilter) {
        this.initQuad(gl);
        this.progQuad.use(JoglGpuContext.get(gl));
        gl.glActiveTexture(33984);
        gl.glBindTexture(3553, this.texColorBuffer);
        gl.glTexParameteri(3553, 10241, minFilter);
        gl.glTexParameteri(3553, 10240, magFilter);
        gl.glTexParameteri(3553, 10242, 33071);
        gl.glTexParameteri(3553, 10243, 33071);
        gl.glBindVertexArray(this.vaoQuad);
        gl.glDrawElements(4, 6, 5125, 0L);
        gl.glBindVertexArray(0);
        gl.glBindTexture(3553, 0);
    }

    public void getTexture(GL3 gl) {
        if (this.imgValid) {
            return;
        }
        this.imgValid = true;
        this.initImgs();
        gl.glBindTexture(3553, this.texColorBuffer);
        gl.glGetTexImage(3553, 0, 6407, 5126, (Buffer)FloatBuffer.wrap(this.rgb));
        gl.glBindTexture(3553, this.texDepthBuffer);
        gl.glGetTexImage(3553, 0, 6402, 5126, (Buffer)FloatBuffer.wrap(this.depth));
        gl.glBindTexture(3553, 0);
    }

    public int getWidth() {
        return this.fbWidth;
    }

    public int getHeight() {
        return this.fbHeight;
    }

    static class DepthTexture
    implements Texture2D {
        private final int width;
        private final int height;

        public DepthTexture(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public Texture.InternalFormat texInternalFormat() {
            return Texture.InternalFormat.UNKNOWN;
        }

        @Override
        public int texWidth() {
            return this.width;
        }

        @Override
        public int texHeight() {
            return this.height;
        }

        @Override
        public Texture.MinFilter texMinFilter() {
            return Texture.MinFilter.LINEAR;
        }

        @Override
        public Texture.MagFilter texMagFilter() {
            return Texture.MagFilter.LINEAR;
        }

        @Override
        public Texture.Wrap texWrap() {
            return Texture.Wrap.CLAMP_TO_EDGE;
        }
    }
}

