/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.multires;

import bdv.util.volatiles.VolatileView;
import bdv.viewer.Source;
import bvv.core.blocks.TileAccess;
import bvv.core.multires.MultiResolutionStack3D;
import bvv.core.multires.ResolutionLevel3D;
import bvv.core.multires.SimpleStack3D;
import bvv.core.multires.Stack3D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.realtransform.AffineTransform3D;

public class SourceStacks {
    private static final Map<Source<?>, SourceStackType> sourceStackTypes = new WeakHashMap();
    private static final Map<Source<?>, AtomicInteger> sourceGenerations = new WeakHashMap();
    private static final Map<Source<?>, SourceStackResolutions> sourceStackResolutions = new WeakHashMap();

    public static void setSourceStackType(Source<?> source, SourceStackType stack) {
        sourceStackTypes.put(source, stack);
    }

    public static SourceStackType getSourceStackType(Source<?> source) {
        return sourceStackTypes.getOrDefault(source, SourceStackType.UNDEFINED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidate(Source<?> source) {
        Source<?> source2 = source;
        synchronized (source2) {
            sourceGenerations.computeIfAbsent(source, s -> new AtomicInteger()).getAndIncrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Stack3D<T> getStack3D(Source<T> source, int timepoint) {
        if (!source.isPresent(timepoint)) {
            return null;
        }
        SourceStackType stackType = SourceStacks.getSourceStackType(source);
        if (stackType == SourceStackType.UNDEFINED) {
            stackType = SourceStacks.inferSourceStackType(source, timepoint);
            SourceStacks.setSourceStackType(source, stackType);
        }
        if (stackType == SourceStackType.SIMPLE) {
            int generation;
            Source<T> source2 = source;
            synchronized (source2) {
                generation = sourceGenerations.computeIfAbsent(source, s -> new AtomicInteger()).get();
            }
            return new SimpleStack3DImp<T>(source, timepoint, generation);
        }
        if (stackType == SourceStackType.MULTIRESOLUTION) {
            return new MultiResolutionStack3DImp<T>(source, timepoint);
        }
        return null;
    }

    private static SourceStackType inferSourceStackType(Source<?> source, int timepoint) {
        Object type = source.getType();
        if (TileAccess.isSupportedType(type)) {
            RandomAccessibleInterval rai = source.getSource(timepoint, 0);
            if (rai instanceof VolatileView) {
                rai = ((VolatileView)rai).getVolatileViewData().getImg();
            }
            if (rai instanceof AbstractCellImg) {
                return SourceStackType.MULTIRESOLUTION;
            }
        }
        return SourceStackType.SIMPLE;
    }

    static class SourceStackResolutions {
        final int[][] resolutions;
        final double[][] scales;
        final AffineTransform3D[] levelts;

        SourceStackResolutions(Source<?> source, int timepoint) {
            int numLevels = source.getNumMipmapLevels();
            this.resolutions = new int[numLevels][];
            this.scales = new double[numLevels][];
            this.levelts = new AffineTransform3D[numLevels];
            this.resolutions[0] = new int[]{1, 1, 1};
            this.scales[0] = new double[]{1.0, 1.0, 1.0};
            this.levelts[0] = new AffineTransform3D();
            AffineTransform3D sourceTransform = new AffineTransform3D();
            source.getSourceTransform(timepoint, 0, sourceTransform);
            for (int level = 1; level < numLevels; ++level) {
                this.resolutions[level] = new int[3];
                int[] resolution = this.resolutions[level];
                this.scales[level] = new double[3];
                double[] scale = this.scales[level];
                AffineTransform3D levelt = this.levelts[level] = new AffineTransform3D();
                AffineTransform3D levelTransform = new AffineTransform3D();
                source.getSourceTransform(timepoint, level, levelTransform);
                levelTransform.preConcatenate(sourceTransform.inverse());
                for (int d = 0; d < 3; ++d) {
                    resolution[d] = (int)Math.round(levelTransform.get(d, d));
                    scale[d] = 1.0 / (double)resolution[d];
                    levelt.set((double)resolution[d], d, d);
                    levelt.set(0.5 * (double)(resolution[d] - 1), d, 3);
                }
            }
        }
    }

    static class ResolutionLevel3DImp<T>
    implements ResolutionLevel3D<T> {
        private final int level;
        private final int timepoint;
        private final Source<T> source;
        private final int[] resolution;
        private final double[] scale;
        private final AffineTransform3D levelt;

        ResolutionLevel3DImp(Source<T> source, int timepoint, int level, SourceStackResolutions sourceStackResolutions) {
            this.level = level;
            this.timepoint = timepoint;
            this.source = source;
            this.resolution = sourceStackResolutions.resolutions[level];
            this.scale = sourceStackResolutions.scales[level];
            this.levelt = sourceStackResolutions.levelts[level];
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public int[] getR() {
            return this.resolution;
        }

        @Override
        public double[] getS() {
            return this.scale;
        }

        @Override
        public AffineTransform3D getLevelTransform() {
            return this.levelt;
        }

        @Override
        public RandomAccessibleInterval<T> getImage() {
            return this.source.getSource(this.timepoint, this.level);
        }

        @Override
        public T getType() {
            return (T)this.source.getType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolutionLevel3DImp that = (ResolutionLevel3DImp)o;
            if (this.timepoint != that.timepoint) {
                return false;
            }
            if (this.level != that.level) {
                return false;
            }
            return this.source.equals(that.source);
        }

        public int hashCode() {
            int result = this.level;
            result = 31 * result + this.timepoint;
            result = 31 * result + this.source.hashCode();
            return result;
        }
    }

    static class MultiResolutionStack3DImp<T>
    extends Stack3DImp<T>
    implements MultiResolutionStack3D<T> {
        private final ArrayList<ResolutionLevel3DImp<T>> resolutions;

        MultiResolutionStack3DImp(Source<T> source, int timepoint) {
            super(source, timepoint, 0);
            SourceStackResolutions ssr = sourceStackResolutions.computeIfAbsent(source, s -> new SourceStackResolutions(source, timepoint));
            this.resolutions = new ArrayList();
            for (int level = 0; level < source.getNumMipmapLevels(); ++level) {
                this.resolutions.add(new ResolutionLevel3DImp<T>(source, timepoint, level, ssr));
            }
        }

        @Override
        public List<ResolutionLevel3DImp<T>> resolutions() {
            return this.resolutions;
        }
    }

    static class SimpleStack3DImp<T>
    extends Stack3DImp<T>
    implements SimpleStack3D<T> {
        SimpleStack3DImp(Source<T> source, int timepoint, int generation) {
            super(source, timepoint, generation);
        }

        @Override
        public RandomAccessibleInterval<T> getImage() {
            return this.source.getSource(this.timepoint, 0);
        }
    }

    static abstract class Stack3DImp<T>
    implements Stack3D<T> {
        final int timepoint;
        final Source<T> source;
        private final AffineTransform3D sourceTransform;
        private final int generation;

        Stack3DImp(Source<T> source, int timepoint, int generation) {
            this.timepoint = timepoint;
            this.source = source;
            this.sourceTransform = new AffineTransform3D();
            source.getSourceTransform(timepoint, 0, this.sourceTransform);
            this.generation = generation;
        }

        @Override
        public AffineTransform3D getSourceTransform() {
            return this.sourceTransform;
        }

        @Override
        public T getType() {
            return (T)this.source.getType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stack3DImp that = (Stack3DImp)o;
            if (this.timepoint != that.timepoint) {
                return false;
            }
            if (this.generation != that.generation) {
                return false;
            }
            return this.source.equals(that.source);
        }

        public int hashCode() {
            int result = this.timepoint;
            result = 31 * result + this.generation;
            result = 31 * result + this.source.hashCode();
            return result;
        }
    }

    public static enum SourceStackType {
        SIMPLE,
        MULTIRESOLUTION,
        UNDEFINED;

    }
}

