/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.dither;

import bvv.core.backend.jogl.JoglGpuContext;
import bvv.core.dither.DitherPattern;
import bvv.core.offscreen.OffScreenFrameBuffer;
import bvv.core.shadergen.DefaultShader;
import bvv.core.shadergen.generate.Segment;
import bvv.core.shadergen.generate.SegmentTemplate;
import bvv.core.util.DefaultQuad;
import com.jogamp.opengl.GL3;
import java.util.function.IntFunction;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;

public class DitherBuffer {
    private final int paddedWidth;
    private final int paddedHeight;
    private final int spw;
    private final int sps;
    private final int[] spox;
    private final int[] spoy;
    private final DitherPattern.DitherWeights[] onws;
    private final DefaultQuad quad = new DefaultQuad();
    private final DefaultShader progDither;
    private final DefaultShader progStitch;
    private final OffScreenFrameBuffer dither;
    private final OffScreenFrameBuffer stitch;
    private final int we;
    private final int he;

    public DitherBuffer(int width, int height) {
        this(width, height, 4, 9, 8);
    }

    public DitherBuffer(int width, int height, int spw, int step, int numSamples) {
        this(width, height, spw, step, numSamples, maxsp -> {
            double minf = 0.2;
            double maxf = 2.0;
            double sps = spw * spw;
            int numValidTextures = maxsp + 1;
            double sigma = Math.sqrt(sps / (double)numValidTextures) * (0.2 + 1.8 * ((sps - (double)maxsp - 1.0) / (sps - 1.0)));
            return sigma;
        });
    }

    public DitherBuffer(int width, int height, int spw, int step, int numSamples, IntFunction<Double> sampleToSigma) {
        this.we = (width - 1) / spw + 1;
        this.he = (height - 1) / spw + 1;
        this.spw = spw;
        this.paddedWidth = spw * this.we;
        this.paddedHeight = spw * this.he;
        this.sps = spw * spw;
        this.spox = new int[this.sps];
        this.spoy = new int[this.sps];
        DitherPattern.makePattern(spw, step, this.spox, this.spoy);
        this.onws = new DitherPattern.DitherWeights[this.sps * this.sps];
        for (int maxsp = 0; maxsp < this.sps; ++maxsp) {
            for (int oy = 0; oy < spw; ++oy) {
                for (int ox = 0; ox < spw; ++ox) {
                    double sigma = sampleToSigma.apply(maxsp);
                    int i = ox + spw * oy + maxsp * this.sps;
                    this.onws[i] = DitherPattern.getWeights(spw, this.we, this.he, maxsp + 1, ox, oy, numSamples, sigma, this.spox, this.spoy);
                }
            }
        }
        Segment ditherVp = new SegmentTemplate(DitherBuffer.class, "dither.vp", new String[0]).instantiate();
        this.progDither = new DefaultShader(ditherVp.getCode(), DitherPattern.makeShader(numSamples));
        Segment stitchVp = new SegmentTemplate(DitherBuffer.class, "stitch.vp", new String[0]).instantiate();
        Segment stichFp = new SegmentTemplate(DitherBuffer.class, "stitch.fp", new String[0]).instantiate();
        this.progStitch = new DefaultShader(stitchVp.getCode(), stichFp.getCode());
        this.dither = new OffScreenFrameBuffer(this.paddedWidth, this.paddedHeight, 32856);
        this.stitch = new OffScreenFrameBuffer(this.paddedWidth, this.paddedHeight, 32856);
    }

    public int numSteps() {
        return this.sps;
    }

    public int effectiveViewportWidth() {
        return this.we;
    }

    public int effectiveViewportHeight() {
        return this.he;
    }

    public Vector2f fragShift(int step) {
        return new Vector2f((float)this.deltaSp(this.spw, this.spox[step], this.we), (float)this.deltaSp(this.spw, this.spoy[step], this.he));
    }

    public Matrix4f ndcTransform(int step) {
        float wvByWe = (float)this.paddedWidth / (float)this.we;
        float hvByHe = (float)this.paddedHeight / (float)this.he;
        return new Matrix4f().scale(1.0f / wvByWe, 1.0f / hvByHe, 1.0f).translate((float)(1 + 2 * this.spox[step]) - wvByWe, (float)(1 + 2 * this.spoy[step]) - hvByHe, 0.0f);
    }

    public void bind(GL3 gl) {
        this.dither.bind(gl, false);
    }

    public void unbind(GL3 gl) {
        this.dither.unbind(gl, false);
    }

    public void dither(GL3 gl, int stepsCompleted, int destWidth, int destHeight) {
        byte[] tmp = new byte[1];
        gl.glGetBooleanv(3042, tmp, 0);
        boolean restoreBlend = tmp[0] != 0;
        JoglGpuContext context = JoglGpuContext.get(gl);
        int maxsp = stepsCompleted - 1;
        this.stitch.bind(gl);
        gl.glDisable(3042);
        gl.glActiveTexture(33984);
        gl.glBindTexture(3553, this.dither.getTexColorBuffer());
        gl.glTexParameteri(3553, 10241, 9728);
        gl.glTexParameteri(3553, 10240, 9728);
        gl.glTexParameteri(3553, 10242, 33071);
        gl.glTexParameteri(3553, 10243, 33071);
        this.progDither.getUniform1i("tex").set(0);
        this.progDither.use(context);
        this.progDither.getUniform2f("spw").set(this.spw, this.spw);
        for (int i = 0; i < this.sps; ++i) {
            DitherPattern.DitherWeights onw = this.onws[this.spox[i] + this.spoy[i] * this.spw + maxsp * this.sps];
            this.progDither.getUniform2f("dsp").set((float)(this.deltaSp(this.spw, this.spox[i], this.we) - 0.5), (float)(this.deltaSp(this.spw, this.spoy[i], this.he) - 0.5));
            float wvByWe = (float)this.paddedWidth / (float)this.we;
            float hvByHe = (float)this.paddedHeight / (float)this.he;
            Matrix4f transform = new Matrix4f().scale(1.0f / wvByWe, 1.0f / hvByHe, 1.0f).translate((float)(1 + 2 * this.spox[i]) - wvByWe, (float)(1 + 2 * this.spoy[i]) - hvByHe, 0.0f);
            this.progDither.getUniformMatrix4f("transform").set((Matrix4fc)transform);
            this.progDither.getUniform2fv("spo").set(onw.spo);
            this.progDither.getUniform1fv("K").set(onw.K);
            this.progDither.setUniforms(context);
            this.quad.draw(gl);
        }
        this.stitch.unbind(gl, false);
        gl.glBindTexture(3553, this.stitch.getTexColorBuffer());
        gl.glTexParameteri(3553, 10241, 9728);
        gl.glTexParameteri(3553, 10240, 9728);
        gl.glTexParameteri(3553, 10242, 33071);
        gl.glTexParameteri(3553, 10243, 33071);
        this.progStitch.getUniform1i("tex").set(0);
        this.progStitch.getUniform2f("viewportScale").set((float)this.paddedWidth / (float)destWidth, (float)this.paddedHeight / (float)destHeight);
        this.progStitch.getUniform2f("spw").set(this.spw, this.spw);
        this.progStitch.getUniform2f("tls").set(this.we, this.he);
        this.progStitch.setUniforms(context);
        this.progStitch.use(context);
        if (restoreBlend) {
            gl.glEnable(3042);
        }
        this.quad.draw(gl);
        gl.glBindTexture(3553, 0);
    }

    private double deltaSp(int sps, int spo, int se) {
        return ((double)spo + 0.5) / (double)sps - 0.5 - (double)(spo * se);
    }

    public OffScreenFrameBuffer getDitherBuffer() {
        return this.dither;
    }

    public OffScreenFrameBuffer getStitchBuffer() {
        return this.stitch;
    }
}

