/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.cache;

public class ImageBlockKey<T> {
    private final T image;
    private final int x;
    private final int y;
    private final int z;
    private final int hashcode;

    public ImageBlockKey(T image, int x, int y, int z) {
        this.image = image;
        this.x = x;
        this.y = y;
        this.z = z;
        int value = image.hashCode();
        value = 31 * value + x;
        value = 31 * value + y;
        this.hashcode = value = 31 * value + z;
    }

    public ImageBlockKey(T image, int[] pos) {
        this(image, pos[0], pos[1], pos[2]);
    }

    public T image() {
        return this.image;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public int[] pos() {
        return this.pos(new int[3]);
    }

    public int[] pos(int[] pos) {
        pos[0] = this.x;
        pos[1] = this.y;
        pos[2] = this.z;
        return pos;
    }

    public int pos(int d) {
        switch (d) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImageBlockKey)) {
            return false;
        }
        ImageBlockKey b = (ImageBlockKey)obj;
        return this.x == b.x && this.y == b.y && this.z == b.z && this.image.equals(b.image);
    }

    public int hashCode() {
        return this.hashcode;
    }
}

