/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.cache;

import bvv.core.backend.Texture;

public class CacheSpec {
    private final int[] blockSize;
    private final int[] paddedBlockSize;
    private final int[] padOffset;
    private final Texture.InternalFormat format;

    public CacheSpec(Texture.InternalFormat format, int blockSizeX, int blockSizeY, int blockSizeZ) {
        this(format, new int[]{blockSizeX, blockSizeY, blockSizeZ});
    }

    public CacheSpec(Texture.InternalFormat format, int[] blockSize) {
        this(format, blockSize, new int[]{blockSize[0] + 2, blockSize[1] + 2, blockSize[2] + 2}, new int[]{1, 1, 1});
    }

    public CacheSpec(Texture.InternalFormat format, int[] blockSize, int[] paddedBlockSize, int[] padOffset) {
        assert (blockSize.length == 3);
        assert (paddedBlockSize.length == 3);
        assert (padOffset.length == 3);
        this.format = format;
        this.blockSize = blockSize;
        this.paddedBlockSize = paddedBlockSize;
        this.padOffset = padOffset;
    }

    public int[] blockSize() {
        return this.blockSize;
    }

    public int[] paddedBlockSize() {
        return this.paddedBlockSize;
    }

    public int[] padOffset() {
        return this.padOffset;
    }

    public Texture.InternalFormat format() {
        return this.format;
    }
}

