/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.blocks;

import bvv.core.blocks.GridDataAccess;
import net.imglib2.RandomAccess;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.volatiles.VolatileArrayDataAccess;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;

public class GridDataAccessImp {
    private GridDataAccessImp() {
    }

    public static class VolatileCells<T, A extends VolatileArrayDataAccess<?>>
    extends AbstractCells<T, A> {
        public VolatileCells(AbstractCellImg<?, A, ? extends Cell<A>, ?> cellImg) {
            super(cellImg);
        }

        @Override
        public T get() {
            VolatileArrayDataAccess data = (VolatileArrayDataAccess)((Cell)this.access.get()).getData();
            return (T)(data.isValid() ? data.getCurrentStorageArray() : null);
        }
    }

    public static class Cells<T, A extends ArrayDataAccess<?>>
    extends AbstractCells<T, A> {
        public Cells(AbstractCellImg<?, A, ? extends Cell<A>, ?> cellImg) {
            super(cellImg);
        }

        @Override
        public T get() {
            return (T)((ArrayDataAccess)((Cell)this.access.get()).getData()).getCurrentStorageArray();
        }
    }

    static abstract class AbstractCells<T, A extends DataAccess>
    implements GridDataAccess<T> {
        final RandomAccess<? extends Cell<A>> access;
        private final CellGrid grid;

        AbstractCells(AbstractCellImg<?, A, ? extends Cell<A>, ?> cellImg) {
            this.access = cellImg.getCells().randomAccess();
            this.grid = cellImg.getCellGrid();
        }

        @Override
        public void fwd(int d) {
            this.access.fwd(d);
        }

        @Override
        public void setPosition(int position, int d) {
            this.access.setPosition(position, d);
        }

        @Override
        public void setPosition(int[] position) {
            this.access.setPosition(position);
        }

        @Override
        public int[] getPosition() {
            return new int[]{this.access.getIntPosition(0), this.access.getIntPosition(1), this.access.getIntPosition(2)};
        }

        @Override
        public int cellSize(int d) {
            return this.grid.cellDimension(d);
        }

        @Override
        public int cellSize(int d, int cellGridPosition) {
            return this.grid.getCellDimension(d, (long)cellGridPosition);
        }

        @Override
        public int imgSize(int d) {
            return (int)this.grid.imgDimension(d);
        }
    }
}

