/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.blockmath;

import bvv.core.multires.ResolutionLevel3D;
import bvv.core.util.MatrixMath;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.algorithm.kdtree.ConvexPolytope;
import net.imglib2.algorithm.kdtree.HyperPlane;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NoFeasibleSolutionException;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class MipmapSizes {
    final Vector3f pNear = new Vector3f();
    final Vector3f pFarMinusNear = new Vector3f();
    private float sn;
    private float sf;
    private float v0x;
    private float v0y;
    private float v0z;
    private float drels;
    private float[] sls;
    private float drelClosestSourcePoint;
    private int baseLevel;
    private boolean isVisible;
    private final Vector3f dir = new Vector3f();

    public void init(Matrix4fc sourceToNDC, int viewportWidth, List<? extends ResolutionLevel3D<?>> resolutions) {
        Matrix4f NDCtoSource = sourceToNDC.invert(new Matrix4f());
        float w = 2.0f / (float)viewportWidth;
        NDCtoSource.transformProject(0.0f, 0.0f, -1.0f, this.pNear);
        Vector3f pFar = NDCtoSource.transformProject(0.0f, 0.0f, 1.0f, new Vector3f());
        this.sn = NDCtoSource.transformProject(w, 0.0f, -1.0f, new Vector3f()).sub((Vector3fc)this.pNear).length();
        this.sf = NDCtoSource.transformProject(w, 0.0f, 1.0f, new Vector3f()).sub((Vector3fc)pFar).length();
        pFar.sub((Vector3fc)this.pNear, this.pFarMinusNear);
        this.pFarMinusNear.normalize(this.dir);
        this.drels = 1.0f / this.pFarMinusNear.lengthSquared();
        this.v0x = (float)Math.sqrt(1.0 - (double)this.dir.dot(1.0f, 0.0f, 0.0f));
        this.v0y = (float)Math.sqrt(1.0 - (double)this.dir.dot(0.0f, 1.0f, 0.0f));
        this.v0z = (float)Math.sqrt(1.0 - (double)this.dir.dot(0.0f, 0.0f, 1.0f));
        this.sls = new float[resolutions.size()];
        for (int i = 0; i < resolutions.size(); ++i) {
            this.sls[i] = this.sl(resolutions.get(i).getR());
        }
        long[] imgSize = new long[3];
        resolutions.get(0).getImage().dimensions(imgSize);
        Matrix4f T = sourceToNDC.transpose(new Matrix4f());
        ConvexPolytope sourceRegion = new ConvexPolytope(new HyperPlane[]{MipmapSizes.sourceHyperPlane((Matrix4fc)T, 1.0, 0.0, 0.0, -1.0), MipmapSizes.sourceHyperPlane((Matrix4fc)T, -1.0, 0.0, 0.0, -1.0), MipmapSizes.sourceHyperPlane((Matrix4fc)T, 0.0, 1.0, 0.0, -1.0), MipmapSizes.sourceHyperPlane((Matrix4fc)T, 0.0, -1.0, 0.0, -1.0), MipmapSizes.sourceHyperPlane((Matrix4fc)T, 0.0, 0.0, 1.0, -1.0), MipmapSizes.sourceHyperPlane((Matrix4fc)T, 0.0, 0.0, -1.0, -1.0), new HyperPlane(new double[]{1.0, 0.0, 0.0, 0.0}), new HyperPlane(new double[]{0.0, 1.0, 0.0, 0.0}), new HyperPlane(new double[]{0.0, 0.0, 1.0, 0.0}), new HyperPlane(new double[]{-1.0, 0.0, 0.0, -imgSize[0]}), new HyperPlane(new double[]{0.0, -1.0, 0.0, -imgSize[1]}), new HyperPlane(new double[]{0.0, 0.0, -1.0, -imgSize[2]})});
        this.pFarMinusNear.mul(this.drels, this.dir);
        LinearObjectiveFunction f = new LinearObjectiveFunction(new double[]{this.dir.x(), this.dir.y(), this.dir.z()}, (double)(-this.dir.dot((Vector3fc)this.pNear)));
        ArrayList<LinearConstraint> constraints = new ArrayList<LinearConstraint>();
        for (HyperPlane plane : sourceRegion.getHyperplanes()) {
            constraints.add(new LinearConstraint(plane.getNormal(), Relationship.GEQ, plane.getDistance()));
        }
        try {
            PointValuePair sln = new SimplexSolver().optimize(new OptimizationData[]{f, new LinearConstraintSet(constraints), GoalType.MINIMIZE});
            this.drelClosestSourcePoint = Math.max(Math.min(((Double)sln.getValue()).floatValue(), 1.0f), 0.0f);
        }
        catch (NoFeasibleSolutionException e) {
            this.isVisible = false;
        }
        this.baseLevel = this.bestLevel(this.drelClosestSourcePoint);
    }

    private static HyperPlane sourceHyperPlane(Matrix4fc sourceToNDCTransposed, double nx, double ny, double nz, double d) {
        return MatrixMath.hyperPlane(new Vector4f((float)nx, (float)ny, (float)nz, (float)(-d)).mul(sourceToNDCTransposed).normalize3());
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public int getBaseLevel() {
        return this.baseLevel;
    }

    private float sl(int[] levelScaleFactors) {
        int x = levelScaleFactors[0];
        int y = levelScaleFactors[1];
        int z = levelScaleFactors[2];
        return Math.max((float)x * this.v0x, Math.max((float)y * this.v0y, (float)z * this.v0z));
    }

    public int bestLevel(Vector3fc x, Vector3f temp) {
        float drel = x.sub((Vector3fc)this.pNear, temp).dot((Vector3fc)this.pFarMinusNear) * this.drels;
        return this.bestLevel(drel);
    }

    private int bestLevel(float drel) {
        float sd = drel * this.sf + (1.0f - drel) * this.sn;
        for (int l = 0; l < this.sls.length; ++l) {
            if (!(sd <= this.sls[l])) continue;
            if (l == 0) {
                return 0;
            }
            return this.sls[l] - sd < sd - this.sls[l - 1] ? l : l - 1;
        }
        return this.sls.length - 1;
    }

    public float getDrel(Vector3fc x, Vector3f temp) {
        float drel = x.sub((Vector3fc)this.pNear, temp).dot((Vector3fc)this.pFarMinusNear) * this.drels;
        return drel;
    }

    public float getSn() {
        return this.sn;
    }

    public float getSf() {
        return this.sf;
    }
}

