/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.blockmath;

import java.util.Iterator;
import net.imglib2.RealLocalizable;
import net.imglib2.algorithm.kdtree.ConvexPolytope;
import net.imglib2.algorithm.kdtree.HyperPlane;
import net.imglib2.util.LinAlgHelpers;

public class GeomUtils {
    public static double signedDistance(HyperPlane plane, double[] point) {
        return LinAlgHelpers.dot((double[])point, (double[])plane.getNormal()) - plane.getDistance();
    }

    public static double signedDistance(HyperPlane plane, RealLocalizable point) {
        int n = plane.numDimensions();
        double[] normal = plane.getNormal();
        double sum = 0.0;
        for (int d = 0; d < n; ++d) {
            sum += normal[d] * point.getDoublePosition(d);
        }
        return sum - plane.getDistance();
    }

    public static boolean isAbove(HyperPlane plane, double[] point) {
        return GeomUtils.signedDistance(plane, point) >= 0.0;
    }

    public static boolean isAbove(HyperPlane plane, RealLocalizable point) {
        return GeomUtils.signedDistance(plane, point) >= 0.0;
    }

    public static boolean isInside(ConvexPolytope poly, double[] point) {
        for (HyperPlane plane : poly.getHyperplanes()) {
            if (GeomUtils.isAbove(plane, point)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInside(ConvexPolytope poly, RealLocalizable point) {
        for (HyperPlane plane : poly.getHyperplanes()) {
            if (GeomUtils.isAbove(plane, point)) continue;
            return false;
        }
        return true;
    }

    public static String toString(HyperPlane plane) {
        StringBuilder sb = new StringBuilder("( ");
        double[] normal = plane.getNormal();
        for (int d = 0; d < normal.length; ++d) {
            sb.append(String.format("%.3f, ", normal[d]));
        }
        sb.append(String.format("%.3f )", plane.getDistance()));
        return sb.toString();
    }

    public static String toString(ConvexPolytope polytope) {
        StringBuilder sb = new StringBuilder("{ ");
        Iterator iter = polytope.getHyperplanes().iterator();
        while (iter.hasNext()) {
            sb.append(GeomUtils.toString((HyperPlane)iter.next()));
            if (!iter.hasNext()) continue;
            sb.append(",\n  ");
        }
        sb.append("}");
        return sb.toString();
    }
}

