/*
 * Decompiled with CFR 0.152.
 */
package bvv.core;

import bdv.BigDataViewer;
import bdv.ViewerImgLoader;
import bdv.cache.CacheControl;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import bdv.tools.InitializeViewerState;
import bdv.tools.PreferencesDialog;
import bdv.tools.bookmarks.Bookmarks;
import bdv.tools.bookmarks.BookmarksEditor;
import bdv.tools.brightness.BrightnessDialog;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.MinMaxGroup;
import bdv.tools.brightness.SetupAssignments;
import bdv.tools.transformation.ManualTransformation;
import bdv.tools.transformation.ManualTransformationEditor;
import bdv.ui.appearance.AppearanceManager;
import bdv.ui.appearance.AppearanceSettingsPage;
import bdv.ui.keymap.Keymap;
import bdv.ui.keymap.KeymapManager;
import bdv.ui.keymap.KeymapSettingsPage;
import bdv.ui.settings.SettingsPage;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.ConverterSetups;
import bdv.viewer.NavigationActions;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerState;
import bvv.core.BigVolumeViewerActions;
import bvv.core.KeyConfigScopes;
import bvv.core.VolumeViewerFrame;
import bvv.core.VolumeViewerOptions;
import bvv.core.VolumeViewerPanel;
import dev.dirs.ProjectDirectories;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.AbstractSpimData;
import net.imglib2.realtransform.AffineTransform3D;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.scijava.Context;
import org.scijava.plugin.PluginService;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionsBuilder;
import org.scijava.ui.behaviour.util.Actions;

public class BigVolumeViewer {
    public static String configDir = ProjectDirectories.from((String)"sc", (String)"fiji", (String)"bigvolumeviewer").configDir;
    private final VolumeViewerFrame viewerFrame;
    private final VolumeViewerPanel viewer;
    private final ManualTransformation manualTransformation;
    private final Bookmarks bookmarks;
    private final SetupAssignments setupAssignments;
    final BrightnessDialog brightnessDialog;
    private final KeymapManager keymapManager;
    private final AppearanceManager appearanceManager;
    final PreferencesDialog preferencesDialog;
    final ManualTransformationEditor manualTransformationEditor;
    final BookmarksEditor bookmarkEditor;
    private final JFileChooser fileChooser;
    private File proposedSettingsFile;

    public BigVolumeViewer(List<ConverterSetup> converterSetups, List<SourceAndConverter<?>> sources, int numTimepoints, CacheControl cacheControl, String windowTitle, VolumeViewerOptions options) {
        KeymapManager optionsKeymapManager = options.values.getKeymapManager();
        AppearanceManager optionsAppearanceManager = options.values.getAppearanceManager();
        this.keymapManager = optionsKeymapManager != null ? optionsKeymapManager : BigVolumeViewer.createDefaultKeymapManager();
        this.appearanceManager = optionsAppearanceManager != null ? optionsAppearanceManager : new AppearanceManager(configDir);
        InputTriggerConfig inputTriggerConfig = options.values.getInputTriggerConfig();
        Keymap keymap = this.keymapManager.getForwardSelectedKeymap();
        if (inputTriggerConfig == null) {
            inputTriggerConfig = keymap.getConfig();
        }
        this.viewerFrame = new VolumeViewerFrame(sources, numTimepoints, cacheControl, options.inputTriggerConfig(inputTriggerConfig));
        if (windowTitle != null) {
            this.viewerFrame.setTitle(windowTitle);
        }
        this.viewer = this.viewerFrame.getViewerPanel();
        this.manualTransformation = new ManualTransformation((AbstractViewerPanel)this.viewer);
        this.manualTransformationEditor = new ManualTransformationEditor((AbstractViewerPanel)this.viewer, this.viewerFrame.getKeybindings());
        this.bookmarks = new Bookmarks();
        this.bookmarkEditor = new BookmarksEditor((AbstractViewerPanel)this.viewer, this.viewerFrame.getKeybindings(), this.bookmarks);
        ConverterSetups setups = this.viewerFrame.getConverterSetups();
        if (converterSetups.size() != sources.size()) {
            System.err.println("WARNING! Constructing BigDataViewer, with converterSetups.size() that is not the same as sources.size().");
        }
        int numSetups = Math.min(converterSetups.size(), sources.size());
        for (int i = 0; i < numSetups; ++i) {
            SourceAndConverter<?> source = sources.get(i);
            ConverterSetup setup = converterSetups.get(i);
            if (setup == null) continue;
            setups.put(source, setup);
        }
        this.setupAssignments = new SetupAssignments(new ArrayList<ConverterSetup>(converterSetups), 0.0, 65535.0);
        if (this.setupAssignments.getMinMaxGroups().size() > 0) {
            MinMaxGroup group = (MinMaxGroup)this.setupAssignments.getMinMaxGroups().get(0);
            for (ConverterSetup setup : this.setupAssignments.getConverterSetups()) {
                this.setupAssignments.moveSetupToGroup(setup, group);
            }
        }
        this.brightnessDialog = new BrightnessDialog((Frame)this.viewerFrame, this.setupAssignments);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "xml files";
            }

            @Override
            public boolean accept(File f) {
                String s;
                int i;
                if (f.isDirectory()) {
                    return true;
                }
                if (f.isFile() && (i = (s = f.getName()).lastIndexOf(46)) > 0 && i < s.length() - 1) {
                    String ext = s.substring(i + 1).toLowerCase();
                    return ext.equals("xml");
                }
                return false;
            }
        });
        this.preferencesDialog = new PreferencesDialog((Frame)this.viewerFrame, keymap, new String[]{"bvv"});
        this.preferencesDialog.addPage((SettingsPage)new AppearanceSettingsPage("Appearance", this.appearanceManager));
        this.preferencesDialog.addPage((SettingsPage)new KeymapSettingsPage("Keymap", this.keymapManager, this.keymapManager.getCommandDescriptions()));
        this.appearanceManager.appearance().updateListeners().add(this.viewerFrame::repaint);
        this.appearanceManager.addLafComponent((Component)this.fileChooser);
        SwingUtilities.invokeLater(() -> this.appearanceManager.updateLookAndFeel());
        Actions navActions = new Actions((KeyStrokeAdder.Factory)inputTriggerConfig, new String[]{"bvv", "navigation"});
        navActions.install(this.viewerFrame.getKeybindings(), "navigation");
        NavigationActions.install((Actions)navActions, (AbstractViewerPanel)this.viewer, (boolean)false);
        Actions bvvActions = new Actions((KeyStrokeAdder.Factory)inputTriggerConfig, new String[]{"bvv"});
        bvvActions.install(this.viewerFrame.getKeybindings(), "bdv");
        BigVolumeViewerActions.install(bvvActions, this);
        keymap.updateListeners().add(() -> {
            navActions.updateKeyConfig(keymap.getConfig());
            bvvActions.updateKeyConfig(keymap.getConfig());
            this.viewerFrame.getTransformBehaviours().updateKeyConfig(keymap.getConfig());
        });
    }

    private static KeymapManager createDefaultKeymapManager() {
        KeymapManager manager = new KeymapManager(configDir);
        CommandDescriptionsBuilder builder = new CommandDescriptionsBuilder();
        Context context = new Context(new Class[]{PluginService.class});
        context.inject((Object)builder);
        builder.discoverProviders(new CommandDescriptionProvider.Scope[]{KeyConfigScopes.BIGVOLUMEVIEWER});
        context.dispose();
        manager.setCommandDescriptions(builder.build());
        return manager;
    }

    public VolumeViewerPanel getViewer() {
        return this.viewer;
    }

    public VolumeViewerFrame getViewerFrame() {
        return this.viewerFrame;
    }

    public ConverterSetups getConverterSetups() {
        return this.viewerFrame.getConverterSetups();
    }

    @Deprecated
    public SetupAssignments getSetupAssignments() {
        return this.setupAssignments;
    }

    public ManualTransformationEditor getManualTransformEditor() {
        return this.manualTransformationEditor;
    }

    public KeymapManager getKeymapManager() {
        return this.keymapManager;
    }

    public AppearanceManager getAppearanceManager() {
        return this.appearanceManager;
    }

    public void loadSettings() {
        this.fileChooser.setSelectedFile(this.proposedSettingsFile);
        int returnVal = this.fileChooser.showOpenDialog(null);
        if (returnVal == 0) {
            this.proposedSettingsFile = this.fileChooser.getSelectedFile();
            try {
                this.loadSettings(this.proposedSettingsFile.getCanonicalPath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void loadSettings(String xmlFilename) throws IOException, JDOMException {
        SAXBuilder sax = new SAXBuilder();
        Document doc = sax.build(xmlFilename);
        Element root = doc.getRootElement();
        this.viewer.stateFromXml(root);
        this.setupAssignments.restoreFromXml(root);
        this.manualTransformation.restoreFromXml(root);
        this.bookmarks.restoreFromXml(root);
        this.viewer.requestRepaint();
    }

    public boolean tryLoadSettings(String xmlFilename) {
        this.proposedSettingsFile = null;
        if (xmlFilename.endsWith(".xml")) {
            String settings = xmlFilename.substring(0, xmlFilename.length() - ".xml".length()) + ".settings.xml";
            this.proposedSettingsFile = new File(settings);
            if (this.proposedSettingsFile.isFile()) {
                try {
                    this.loadSettings(settings);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public void saveSettings() {
        this.fileChooser.setSelectedFile(this.proposedSettingsFile);
        int returnVal = this.fileChooser.showSaveDialog(null);
        if (returnVal == 0) {
            this.proposedSettingsFile = this.fileChooser.getSelectedFile();
            try {
                this.saveSettings(this.proposedSettingsFile.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveSettings(String xmlFilename) throws IOException {
        Element root = new Element("Settings");
        root.addContent((Content)this.viewer.stateToXml());
        root.addContent((Content)this.setupAssignments.toXml());
        root.addContent((Content)this.manualTransformation.toXml());
        root.addContent((Content)this.bookmarks.toXml());
        Document doc = new Document(root);
        XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
        xout.output(doc, (Writer)new FileWriter(xmlFilename));
    }

    public void expandAndFocusCardPanel() {
        this.viewerFrame.getSplitPanel().setCollapsed(false);
        this.viewerFrame.getSplitPanel().getRightComponent().requestFocusInWindow();
    }

    public void collapseCardPanel() {
        this.viewerFrame.getSplitPanel().setCollapsed(true);
        this.viewer.requestFocusInWindow();
    }

    public static void run(String xmlFilename, int windowWidth, int windowHeight, int renderWidth, int renderHeight, int ditherWidth, int numDitherSamples, int cacheBlockSize, int maxCacheSizeInMB, double dCam, double dClip) throws SpimDataException {
        SpimDataMinimal spimData = (SpimDataMinimal)new XmlIoSpimDataMinimal().load(xmlFilename);
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>();
        ArrayList sources = new ArrayList();
        BigDataViewer.initSetups((AbstractSpimData)spimData, converterSetups, sources);
        SequenceDescriptionMinimal seq = (SequenceDescriptionMinimal)spimData.getSequenceDescription();
        int numTimepoints = seq.getTimePoints().size();
        CacheControl cacheControl = ((ViewerImgLoader)seq.getImgLoader()).getCacheControl();
        BigVolumeViewer bvv = new BigVolumeViewer(converterSetups, sources, numTimepoints, cacheControl, new File(xmlFilename).getName(), VolumeViewerOptions.options().width(windowWidth).height(windowHeight).renderWidth(renderWidth).renderHeight(renderHeight).ditherWidth(ditherWidth).numDitherSamples(numDitherSamples).cacheBlockSize(cacheBlockSize).maxCacheSizeInMB(maxCacheSizeInMB).dCam(dCam).dClip(dClip));
        VolumeViewerFrame frame = bvv.viewerFrame;
        VolumeViewerPanel viewer = bvv.viewer;
        AffineTransform3D resetTransform = InitializeViewerState.initTransform((int)windowWidth, (int)windowHeight, (boolean)false, (ViewerState)viewer.state());
        viewer.state().setViewerTransform(resetTransform);
        Actions actions = new Actions((KeyStrokeAdder.Factory)new InputTriggerConfig(), new String[0]);
        actions.install(frame.getKeybindings(), "additional");
        actions.runnableAction(() -> viewer.state().setViewerTransform(resetTransform), "reset transform", new String[]{"R"});
        if (!bvv.tryLoadSettings(xmlFilename)) {
            InitializeViewerState.initBrightness((double)0.001, (double)0.999, (ViewerState)viewer.state(), (ConverterSetups)viewer.getConverterSetups());
        }
        frame.setVisible(true);
    }

    public static void main(String[] args) throws SpimDataException {
        String xmlFilename = "/Users/pietzsch/workspace/data/111010_weber_full.xml";
        int windowWidth = 640;
        int windowHeight = 480;
        int renderWidth = 512;
        int renderHeight = 512;
        int ditherWidth = 8;
        int numDitherSamples = 8;
        int cacheBlockSize = 64;
        int maxCacheSizeInMB = 4000;
        double dCam = 2000.0;
        double dClip = 1000.0;
        BigVolumeViewer.run("/Users/pietzsch/workspace/data/111010_weber_full.xml", 640, 480, 512, 512, 8, 8, 64, 4000, 2000.0, 1000.0);
    }
}

