/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.cache;

import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.cache.N5JsonCacheableContainer;

public class N5JsonCache {
    public static final N5CacheInfo emptyCacheInfo = new N5CacheInfo();
    public static final EmptyJson emptyJson = new EmptyJson();
    protected final N5JsonCacheableContainer container;
    private final HashMap<String, N5CacheInfo> containerPathToCache = new HashMap();

    public N5JsonCache(N5JsonCacheableContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonElement getAttributes(String normalPathKey, String normalCacheKey) {
        N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null) {
            this.addNewCacheInfo(normalPathKey, normalCacheKey, null);
            cacheInfo = this.getCacheInfo(normalPathKey);
        }
        if (cacheInfo == emptyCacheInfo || cacheInfo.getCache(normalCacheKey) == emptyJson) {
            return null;
        }
        N5CacheInfo n5CacheInfo = cacheInfo;
        synchronized (n5CacheInfo) {
            if (!cacheInfo.containsKey(normalCacheKey)) {
                this.updateCacheInfo(normalPathKey, normalCacheKey, null);
            }
        }
        JsonElement output = cacheInfo.getCache(normalCacheKey);
        return output == null ? null : output.deepCopy();
    }

    public boolean isDataset(String normalPathKey, String normalCacheKey) {
        N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null) {
            this.addNewCacheInfo(normalPathKey, normalCacheKey, null);
            cacheInfo = this.getCacheInfo(normalPathKey);
        }
        return cacheInfo.isDataset;
    }

    public boolean isGroup(String normalPathKey, String cacheKey) {
        N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null) {
            this.addNewCacheInfo(normalPathKey, cacheKey, null);
            cacheInfo = this.getCacheInfo(normalPathKey);
        }
        return cacheInfo.isGroup;
    }

    public boolean exists(String normalPathKey, String normalCacheKey) {
        N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null) {
            this.addNewCacheInfo(normalPathKey, normalCacheKey, null);
            cacheInfo = this.getCacheInfo(normalPathKey);
        }
        return cacheInfo != emptyCacheInfo;
    }

    public String[] list(String normalPathKey) {
        N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null) {
            this.addNewCacheInfo(normalPathKey);
            cacheInfo = this.getCacheInfo(normalPathKey);
        }
        if (cacheInfo == emptyCacheInfo) {
            throw new N5Exception.N5IOException(normalPathKey + " is not a valid group");
        }
        if (cacheInfo.children == null) {
            this.addChild(cacheInfo, normalPathKey);
        }
        String[] children = new String[cacheInfo.children.size()];
        int i = 0;
        for (String child : cacheInfo.children) {
            children[i++] = child;
        }
        return children;
    }

    public N5CacheInfo addNewCacheInfo(String normalPathKey, String normalCacheKey, JsonElement uncachedAttributes) {
        N5CacheInfo cacheInfo = this.container.existsFromContainer(normalPathKey, null) ? this.newCacheInfo() : emptyCacheInfo;
        if (cacheInfo != emptyCacheInfo) {
            if (normalCacheKey != null) {
                JsonElement attributes = uncachedAttributes == null ? this.container.getAttributesFromContainer(normalPathKey, normalCacheKey) : uncachedAttributes;
                this.updateCacheAttributes(cacheInfo, normalCacheKey, attributes);
                this.updateCacheIsGroup(cacheInfo, this.container.isGroupFromAttributes(normalCacheKey, attributes));
                this.updateCacheIsDataset(cacheInfo, this.container.isDatasetFromAttributes(normalCacheKey, attributes));
            } else {
                this.updateCacheIsGroup(cacheInfo, this.container.isGroupFromContainer(normalPathKey));
                this.updateCacheIsDataset(cacheInfo, this.container.isDatasetFromContainer(normalPathKey));
            }
        }
        this.updateCache(normalPathKey, cacheInfo);
        return cacheInfo;
    }

    private N5CacheInfo addNewCacheInfo(String normalPathKey) {
        return this.addNewCacheInfo(normalPathKey, null, null);
    }

    private void addChild(N5CacheInfo cacheInfo, String normalPathKey) {
        if (cacheInfo.children == null) {
            cacheInfo.children = new HashSet();
        }
        String[] children = this.container.listFromContainer(normalPathKey);
        Collections.addAll(cacheInfo.children, children);
    }

    protected N5CacheInfo getOrMakeCacheInfo(String normalPathKey) {
        N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null) {
            return this.addNewCacheInfo(normalPathKey, null, null);
        }
        if (cacheInfo == emptyCacheInfo) {
            cacheInfo = this.newCacheInfo();
        }
        return cacheInfo;
    }

    public void updateCacheInfo(String normalPathKey, String normalCacheKey) {
        N5CacheInfo cacheInfo = this.getOrMakeCacheInfo(normalPathKey);
        JsonElement attrs = cacheInfo.attributesCache.get(normalCacheKey);
        this.updateCacheInfo(normalPathKey, normalCacheKey, attrs);
    }

    public void updateCacheInfo(String normalPathKey, String normalCacheKey, JsonElement uncachedAttributes) {
        N5CacheInfo cacheInfo = this.getOrMakeCacheInfo(normalPathKey);
        if (normalCacheKey != null) {
            JsonElement attributesToCache = uncachedAttributes == null ? this.container.getAttributesFromContainer(normalPathKey, normalCacheKey) : uncachedAttributes;
            this.updateCacheAttributes(cacheInfo, normalCacheKey, attributesToCache);
            this.updateCacheIsGroup(cacheInfo, this.container.isGroupFromAttributes(normalCacheKey, attributesToCache));
            this.updateCacheIsDataset(cacheInfo, this.container.isDatasetFromAttributes(normalCacheKey, attributesToCache));
        } else {
            this.updateCacheIsGroup(cacheInfo, this.container.isGroupFromContainer(normalPathKey));
            this.updateCacheIsDataset(cacheInfo, this.container.isDatasetFromContainer(normalPathKey));
        }
        this.updateCache(normalPathKey, cacheInfo);
    }

    public void initializeNonemptyCache(String normalPathKey, String normalCacheKey) {
        N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null || cacheInfo == emptyCacheInfo) {
            N5CacheInfo info = this.newCacheInfo();
            if (normalCacheKey != null) {
                info.attributesCache.put(normalCacheKey, emptyJson);
            }
            this.updateCache(normalPathKey, info);
        }
    }

    public void setAttributes(String normalPathKey, String normalCacheKey, JsonElement attributes) {
        N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        boolean update = false;
        if (cacheInfo == null) {
            return;
        }
        if (cacheInfo == emptyCacheInfo) {
            cacheInfo = this.newCacheInfo();
            update = true;
        }
        this.updateCacheAttributes(cacheInfo, normalCacheKey, attributes);
        if (update) {
            this.updateCache(normalPathKey, cacheInfo);
        }
    }

    public void addChildIfPresent(String parent, String child) {
        N5CacheInfo cacheInfo = this.getCacheInfo(parent);
        if (cacheInfo == null) {
            return;
        }
        if (cacheInfo.children != null) {
            cacheInfo.children.add(child);
        }
    }

    public void addChild(String parent, String child) {
        N5CacheInfo cacheInfo = this.getCacheInfo(parent);
        if (cacheInfo == null) {
            return;
        }
        if (cacheInfo.children == null) {
            cacheInfo.children = new HashSet();
        }
        cacheInfo.children.add(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCache(String normalParentPathKey, String normalPathKey) {
        HashMap<String, N5CacheInfo> hashMap = this.containerPathToCache;
        synchronized (hashMap) {
            this.containerPathToCache.put(normalPathKey, emptyCacheInfo);
            this.containerPathToCache.keySet().stream().filter(x -> x.startsWith(normalPathKey + "/")).forEach(x -> this.containerPathToCache.put((String)x, emptyCacheInfo));
        }
        N5CacheInfo parentCache = this.containerPathToCache.get(normalParentPathKey);
        if (parentCache != null && parentCache.children != null) {
            parentCache.children.remove(normalPathKey.replaceFirst(normalParentPathKey + "/", ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected N5CacheInfo getCacheInfo(String pathKey) {
        HashMap<String, N5CacheInfo> hashMap = this.containerPathToCache;
        synchronized (hashMap) {
            return this.containerPathToCache.get(pathKey);
        }
    }

    protected N5CacheInfo newCacheInfo() {
        return new N5CacheInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCache(String normalPathKey, N5CacheInfo cacheInfo) {
        HashMap<String, N5CacheInfo> hashMap = this.containerPathToCache;
        synchronized (hashMap) {
            this.containerPathToCache.put(normalPathKey, cacheInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCacheAttributes(N5CacheInfo cacheInfo, String normalCacheKey, JsonElement attributes) {
        HashMap<String, JsonElement> hashMap = cacheInfo.attributesCache;
        synchronized (hashMap) {
            cacheInfo.attributesCache.put(normalCacheKey, attributes);
        }
    }

    protected void updateCacheIsGroup(N5CacheInfo cacheInfo, boolean isGroup) {
        cacheInfo.isGroup = isGroup;
    }

    protected void updateCacheIsDataset(N5CacheInfo cacheInfo, boolean isDataset) {
        cacheInfo.isDataset = isDataset;
    }

    protected static class EmptyJson
    extends JsonElement {
        protected EmptyJson() {
        }

        @Override
        public JsonElement deepCopy() {
            throw new N5Exception("Do not copy EmptyJson, you naughty person");
        }
    }

    protected static class N5CacheInfo {
        protected final HashMap<String, JsonElement> attributesCache = new HashMap();
        protected HashSet<String> children = null;
        protected boolean isDataset = false;
        protected boolean isGroup = false;

        protected N5CacheInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JsonElement getCache(String normalCacheKey) {
            HashMap<String, JsonElement> hashMap = this.attributesCache;
            synchronized (hashMap) {
                return this.attributesCache.get(normalCacheKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(String normalCacheKey) {
            HashMap<String, JsonElement> hashMap = this.attributesCache;
            synchronized (hashMap) {
                return this.attributesCache.containsKey(normalCacheKey);
            }
        }

        public boolean isDataset() {
            return this.isDataset;
        }

        public boolean isGroup() {
            return this.isGroup;
        }
    }
}

