/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.janelia.saalfeldlab.n5.CachedGsonKeyValueN5Reader;
import org.janelia.saalfeldlab.n5.GsonKeyValueN5Writer;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;

public interface CachedGsonKeyValueN5Writer
extends CachedGsonKeyValueN5Reader,
GsonKeyValueN5Writer {
    @Override
    default public void setVersion(String path) throws N5Exception {
        N5Reader.Version version = this.getVersion();
        if (!VERSION.isCompatible(version)) {
            throw new N5Exception.N5IOException("Incompatible version " + version + " (this is " + VERSION + ").");
        }
        if (!VERSION.equals(version)) {
            this.setAttribute("/", "n5", VERSION.toString());
        }
    }

    @Override
    default public void createGroup(String path) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath(path);
        if (this.cacheMeta()) {
            if (this.getCache().isGroup(normalPath, "attributes.json")) {
                return;
            }
            if (this.getCache().exists(normalPath, "attributes.json")) {
                throw new N5Exception("Can't make a group on existing path.");
            }
        }
        try {
            this.getKeyValueAccess().createDirectories(this.absoluteGroupPath(normalPath));
        }
        catch (IOException | UncheckedIOException e) {
            throw new N5Exception.N5IOException("Failed to create group " + path, e);
        }
        if (this.cacheMeta()) {
            String[] pathParts = this.getKeyValueAccess().components(normalPath);
            String parent = N5URI.normalizeGroupPath("/");
            if (pathParts.length == 0) {
                pathParts = new String[]{""};
            }
            for (String child : pathParts) {
                String childPath = parent.isEmpty() ? child : parent + "/" + child;
                this.getCache().initializeNonemptyCache(childPath, "attributes.json");
                this.getCache().updateCacheInfo(childPath, "attributes.json");
                if (parent != null && !child.isEmpty()) {
                    this.getCache().addChildIfPresent(parent, child);
                }
                parent = childPath;
            }
        }
    }

    @Override
    default public void writeAttributes(String normalGroupPath, JsonElement attributes) throws N5Exception {
        this.writeAndCacheAttributes(normalGroupPath, attributes);
    }

    default public void writeAndCacheAttributes(String normalGroupPath, JsonElement attributes) throws N5Exception {
        GsonKeyValueN5Writer.super.writeAttributes(normalGroupPath, attributes);
        if (this.cacheMeta()) {
            JsonElement nullRespectingAttributes = attributes;
            if (!this.getGson().serializeNulls()) {
                nullRespectingAttributes = this.getGson().toJsonTree(attributes);
            }
            this.getCache().updateCacheInfo(normalGroupPath, "attributes.json", nullRespectingAttributes);
        }
    }

    @Override
    default public boolean remove(String path) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath(path);
        String groupPath = this.absoluteGroupPath(normalPath);
        try {
            if (this.getKeyValueAccess().isDirectory(groupPath)) {
                this.getKeyValueAccess().delete(groupPath);
            }
        }
        catch (IOException | UncheckedIOException e) {
            throw new N5Exception.N5IOException("Failed to remove " + path, e);
        }
        if (this.cacheMeta()) {
            String parent;
            String[] pathParts = this.getKeyValueAccess().components(normalPath);
            if (pathParts.length <= 1) {
                parent = N5URI.normalizeGroupPath("/");
            } else {
                int parentPathLength = pathParts.length - 1;
                parent = this.getKeyValueAccess().compose(Arrays.copyOf(pathParts, parentPathLength));
            }
            this.getCache().removeCache(parent, normalPath);
        }
        return true;
    }
}

