/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.sequence;

import java.util.Arrays;
import mpicbg.spim.data.sequence.VoxelDimensions;

public final class FinalVoxelDimensions
implements VoxelDimensions {
    private final String unit;
    private final double[] dimensions;

    public FinalVoxelDimensions(String unit, double ... dimensions) {
        this.unit = unit;
        this.dimensions = (double[])dimensions.clone();
    }

    public FinalVoxelDimensions(VoxelDimensions voxelDimensions) {
        this.unit = voxelDimensions.unit();
        this.dimensions = new double[voxelDimensions.numDimensions()];
        Arrays.setAll(this.dimensions, d -> voxelDimensions.dimension(d));
    }

    public int numDimensions() {
        return this.dimensions.length;
    }

    @Override
    public String unit() {
        return this.unit;
    }

    @Override
    public void dimensions(double[] dims) {
        for (int d = 0; d < dims.length; ++d) {
            dims[d] = this.dimensions[d];
        }
    }

    @Override
    public double dimension(int d) {
        return this.dimensions[d];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{unit='").append(this.unit).append('\'');
        sb.append(", dimensions=").append(Arrays.toString(this.dimensions));
        sb.append('}');
        return sb.toString();
    }
}

