/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.generic.sequence;

import java.io.File;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.base.XmlIoEntityMap;
import mpicbg.spim.data.generic.base.XmlIoSingleton;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaders;
import mpicbg.spim.data.generic.sequence.XmlIoBasicImgLoader;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.XmlIoMissingViews;
import mpicbg.spim.data.sequence.XmlIoTimePoints;
import org.jdom2.Content;
import org.jdom2.Element;

public class XmlIoAbstractSequenceDescription<V extends BasicViewSetup, T extends AbstractSequenceDescription<V, ?, ?>>
extends XmlIoSingleton<T> {
    private final XmlIoTimePoints xmlIoTimePoints;
    private final XmlIoEntityMap<V> xmlIoViewSetups;
    private final XmlIoMissingViews xmlIoMissingViews;

    public XmlIoAbstractSequenceDescription(Class<T> klass, XmlIoTimePoints xmlIoTimePoints, XmlIoEntityMap<V> xmlIoViewSetups, XmlIoMissingViews xmlIoMissingViews) {
        super("SequenceDescription", klass);
        this.xmlIoTimePoints = xmlIoTimePoints;
        this.xmlIoViewSetups = xmlIoViewSetups;
        this.xmlIoMissingViews = xmlIoMissingViews;
        this.handledTags.add(xmlIoTimePoints.getTag());
        this.handledTags.add(xmlIoViewSetups.getTag());
        this.handledTags.add(xmlIoMissingViews.getTag());
        this.handledTags.add("ImageLoader");
    }

    public Element toXml(T sequenceDescription, File basePath) throws SpimDataException {
        Element elem = super.toXml();
        Object imgLoader = ((AbstractSequenceDescription)sequenceDescription).getImgLoader();
        if (imgLoader != null) {
            XmlIoBasicImgLoader<?> imgLoaderIo = ImgLoaders.createXmlIoForImgLoaderClass(imgLoader.getClass());
            elem.addContent((Content)XmlIoAbstractSequenceDescription.createImgLoaderElement(imgLoaderIo, imgLoader, basePath));
        }
        elem.addContent((Content)this.xmlIoViewSetups.toXml(((AbstractSequenceDescription)sequenceDescription).getViewSetups()));
        elem.addContent((Content)this.xmlIoTimePoints.toXml(((AbstractSequenceDescription)sequenceDescription).getTimePoints()));
        if (((AbstractSequenceDescription)sequenceDescription).getMissingViews() != null) {
            elem.addContent((Content)this.xmlIoMissingViews.toXml(((AbstractSequenceDescription)sequenceDescription).getMissingViews()));
        }
        return elem;
    }

    public T fromXml(Element elem, File basePath) throws SpimDataException {
        AbstractSequenceDescription sequenceDescription = (AbstractSequenceDescription)super.fromXml(elem);
        Object setups = this.xmlIoViewSetups.fromXml(elem.getChild(this.xmlIoViewSetups.getTag()));
        sequenceDescription.setViewSetups(setups);
        TimePoints timepoints = this.xmlIoTimePoints.fromXml(elem.getChild(this.xmlIoTimePoints.getTag()));
        sequenceDescription.setTimePoints(timepoints);
        Element missingViewElem = elem.getChild(this.xmlIoMissingViews.getTag());
        MissingViews missingViews = missingViewElem == null ? null : this.xmlIoMissingViews.fromXml(missingViewElem);
        sequenceDescription.setMissingViews(missingViews);
        Element imgLoaderElem = elem.getChild("ImageLoader");
        if (imgLoaderElem != null) {
            String format = imgLoaderElem.getAttributeValue("format");
            XmlIoBasicImgLoader<?> imgLoaderIo = ImgLoaders.createXmlIoForFormat(format);
            Object imgLoader = imgLoaderIo.fromXml(imgLoaderElem, basePath, sequenceDescription);
            XmlIoAbstractSequenceDescription.setImgLoader(sequenceDescription, imgLoader);
        } else {
            sequenceDescription.setImgLoader(null);
        }
        return (T)sequenceDescription;
    }

    private static <L extends BasicImgLoader> Element createImgLoaderElement(XmlIoBasicImgLoader<L> imgLoaderIo, BasicImgLoader imgLoader, File basePath) {
        return imgLoaderIo.toXml(imgLoader, basePath);
    }

    private static <L extends BasicImgLoader, T extends AbstractSequenceDescription<?, ?, L>> void setImgLoader(T sequenceDescription, BasicImgLoader imgLoader) {
        sequenceDescription.setImgLoader((BasicImgLoader)imgLoader);
    }
}

