/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.generic.sequence;

import java.util.HashMap;
import java.util.Map;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.base.ViewSetupAttributes;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.util.Intervals;

public class BasicViewSetup
extends Entity {
    private String name;
    private Dimensions size;
    private VoxelDimensions voxelSize;
    private Map<String, Entity> attributes;

    public BasicViewSetup(int id, String name, Dimensions size, VoxelDimensions voxelSize) {
        super(id);
        this.name = name;
        this.size = size;
        this.voxelSize = voxelSize;
        this.attributes = new HashMap<String, Entity>();
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasSize() {
        return this.size != null;
    }

    public Dimensions getSize() {
        return this.size;
    }

    public boolean hasVoxelSize() {
        return this.voxelSize != null;
    }

    public VoxelDimensions getVoxelSize() {
        return this.voxelSize;
    }

    public Map<String, Entity> getAttributes() {
        return this.attributes;
    }

    public <T extends Entity> T getAttribute(Class<T> attributeClass) {
        return (T)this.attributes.get(ViewSetupAttributes.getNameForClass(attributeClass));
    }

    public <T extends Entity> void setAttribute(T attribute) {
        this.attributes.put(ViewSetupAttributes.getNameForClass(attribute.getClass()), attribute);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("BasicViewSetup{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", size=").append(Intervals.toString((Dimensions)this.size));
        sb.append(", voxelSize=").append(this.voxelSize);
        sb.append(", attributes=").append(this.attributes);
        sb.append('}');
        return sb.toString();
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setSize(Dimensions size) {
        assert (size.numDimensions() == 3);
        this.size = size;
    }

    protected void setVoxelSize(VoxelDimensions voxelSize) {
        assert (voxelSize.numDimensions() == 3);
        this.voxelSize = voxelSize;
    }

    protected void setAttributes(Map<String, Entity> attributes) {
        this.attributes = attributes;
    }

    protected BasicViewSetup() {
    }
}

