/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.generic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.SpimDataIOException;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.XmlIoSingleton;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.XmlIoAbstractSequenceDescription;
import mpicbg.spim.data.registration.XmlIoViewRegistrations;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XmlIoAbstractSpimData<S extends AbstractSequenceDescription<?, ?, ?>, T extends AbstractSpimData<S>>
extends XmlIoSingleton<T> {
    private final XmlIoAbstractSequenceDescription<?, S> xmlIoSequenceDescription;
    private final XmlIoViewRegistrations xmlIoViewRegistrations;

    public XmlIoAbstractSpimData(Class<T> klass, XmlIoAbstractSequenceDescription<?, S> xmlIoSequenceDescription, XmlIoViewRegistrations xmlIoViewRegistrations) {
        super("SpimData", klass);
        this.xmlIoSequenceDescription = xmlIoSequenceDescription;
        this.xmlIoViewRegistrations = xmlIoViewRegistrations;
        this.handledTags.add(xmlIoSequenceDescription.getTag());
        this.handledTags.add(xmlIoViewRegistrations.getTag());
        this.handledTags.add("BasePath");
    }

    public T load(String xmlFilename) throws SpimDataException {
        Document doc;
        SAXBuilder sax = new SAXBuilder();
        try {
            File file = new File(xmlFilename);
            doc = file.exists() ? sax.build(file) : sax.build(xmlFilename);
        }
        catch (Exception e) {
            throw new SpimDataIOException(e);
        }
        Element root = doc.getRootElement();
        if (root.getName() != "SpimData") {
            throw new RuntimeException("expected <SpimData> root element. wrong file?");
        }
        return this.fromXml(root, new File(xmlFilename));
    }

    public void save(T spimData, String xmlFilename) throws SpimDataException {
        File xmlFileDirectory = new File(xmlFilename).getParentFile();
        Document doc = new Document(this.toXml(spimData, xmlFileDirectory));
        XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
        try (FileOutputStream outputStream = new FileOutputStream(xmlFilename);){
            xout.output(doc, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new SpimDataIOException(e);
        }
    }

    public String getVersion(Element root) {
        String version;
        String versionAttr = root.getAttributeValue("version");
        if (versionAttr.isEmpty()) {
            System.out.println("<SpimData> does not specify \"version\" attribute.");
            System.out.println("assuming \"0.2\"");
            version = "0.2";
        } else {
            version = versionAttr;
        }
        return version;
    }

    public T fromXml(Element root, File xmlFile) throws SpimDataException {
        AbstractSpimData spimData = (AbstractSpimData)super.fromXml(root);
        File basePath = this.loadBasePath(root, xmlFile);
        spimData.setBasePath(basePath);
        Element elem = root.getChild(this.xmlIoSequenceDescription.getTag());
        if (elem == null) {
            throw new SpimDataIOException("no <" + this.xmlIoSequenceDescription.getTag() + "> element found.");
        }
        spimData.setSequenceDescription(this.xmlIoSequenceDescription.fromXml(elem, basePath));
        elem = root.getChild(this.xmlIoViewRegistrations.getTag());
        if (elem == null) {
            throw new SpimDataIOException("no <" + this.xmlIoViewRegistrations.getTag() + "> element found.");
        }
        spimData.setViewRegistrations(this.xmlIoViewRegistrations.fromXml(elem));
        return (T)spimData;
    }

    protected File loadBasePath(Element root, File xmlFile) {
        File xmlFileParentDirectory = xmlFile.getParentFile();
        if (xmlFileParentDirectory == null) {
            xmlFileParentDirectory = new File(".");
        }
        return XmlHelpers.loadPath(root, "BasePath", ".", xmlFileParentDirectory);
    }

    public Element toXml(T spimData, File xmlFileDirectory) throws SpimDataException {
        Element root = super.toXml();
        root.setAttribute("version", "0.2");
        root.addContent((Content)XmlHelpers.pathElement("BasePath", ((AbstractSpimData)spimData).getBasePath(), xmlFileDirectory));
        root.addContent((Content)this.xmlIoSequenceDescription.toXml(((AbstractSpimData)spimData).getSequenceDescription(), ((AbstractSpimData)spimData).getBasePath()));
        root.addContent((Content)this.xmlIoViewRegistrations.toXml(((AbstractSpimData)spimData).getViewRegistrations()));
        return root;
    }
}

