/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data;

import java.io.File;
import java.io.IOException;
import mpicbg.spim.data.FastIntArrayParser;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import org.jdom2.Element;

public class XmlHelpers {
    public static Element textElement(String name, String text) {
        return new Element(name).addContent(text);
    }

    public static String getText(Element parent, String name) {
        return parent.getChildText(name);
    }

    public static String getText(Element parent, String name, String defaultValue) {
        String text = parent.getChildText(name);
        return text == null ? defaultValue : text;
    }

    public static Element intElement(String name, int value) {
        return new Element(name).addContent(Integer.toString(value));
    }

    public static int getInt(Element parent, String name) {
        return Integer.parseInt(parent.getChildText(name));
    }

    public static int getInt(Element parent, String name, int defaultValue) {
        String text = parent.getChildText(name);
        return text == null ? defaultValue : Integer.parseInt(text);
    }

    public static Element booleanElement(String name, boolean value) {
        return new Element(name).addContent(Boolean.toString(value));
    }

    public static boolean getBoolean(Element parent, String name) {
        return Boolean.parseBoolean(parent.getChildText(name));
    }

    public static boolean getBoolean(Element parent, String name, boolean defaultValue) {
        String text = parent.getChildText(name);
        return text == null ? defaultValue : Boolean.parseBoolean(text);
    }

    public static Element doubleElement(String name, double value) {
        return new Element(name).addContent(Double.toString(value));
    }

    public static double getDouble(Element parent, String name) {
        return Double.parseDouble(parent.getChildText(name));
    }

    public static double getDouble(Element parent, String name, double defaultValue) {
        String text = parent.getChildText(name);
        return text == null ? defaultValue : Double.parseDouble(text);
    }

    public static double getDoubleAttribute(Element parent, String name) {
        return Double.parseDouble(parent.getAttributeValue(name));
    }

    public static Element doubleArrayElement(String name, double[] value) {
        StringBuffer valueString = new StringBuffer();
        if (value.length > 0) {
            valueString.append(value[0]);
            for (int i = 1; i < value.length; ++i) {
                valueString.append(" ");
                valueString.append(value[i]);
            }
        }
        return new Element(name).addContent(valueString.toString());
    }

    public static double[] getDoubleArray(Element parent, String name) {
        String text = parent.getChildText(name);
        String[] entries = text.split("\\s+");
        if (entries.length == 1 && entries[0].isEmpty()) {
            return new double[0];
        }
        double[] array = new double[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            array[i] = Double.parseDouble(entries[i]);
        }
        return array;
    }

    public static double[] getDoubleArray(Element parent, String name, double[] defaultValue) {
        return parent.getChild(name) == null ? defaultValue : XmlHelpers.getDoubleArray(parent, name);
    }

    public static double[] getDoubleArrayAttribute(Element parent, String name) {
        String text = parent.getAttributeValue(name);
        String[] entries = text.split("\\s+");
        double[] array = new double[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            array[i] = Double.parseDouble(entries[i]);
        }
        return array;
    }

    public static int getIntAttribute(Element parent, String name) {
        return Integer.parseInt(parent.getAttributeValue(name));
    }

    public static Element intArrayElement(String name, int[] value) {
        StringBuffer valueString = new StringBuffer();
        if (value.length > 0) {
            valueString.append(value[0]);
            for (int i = 1; i < value.length; ++i) {
                valueString.append(" ");
                valueString.append(value[i]);
            }
        }
        return new Element(name).addContent(valueString.toString());
    }

    public static int[] getIntArray(Element parent, String name) {
        String text = parent.getChildText(name);
        return FastIntArrayParser.toIntArray(text);
    }

    public static int[] getIntArray(Element parent, String name, int[] defaultValue) {
        return parent.getChild(name) == null ? defaultValue : XmlHelpers.getIntArray(parent, name);
    }

    public static Element longArrayElement(String name, long[] value) {
        StringBuffer valueString = new StringBuffer();
        if (value.length > 0) {
            valueString.append(value[0]);
            for (int i = 1; i < value.length; ++i) {
                valueString.append(" ");
                valueString.append(value[i]);
            }
        }
        return new Element(name).addContent(valueString.toString());
    }

    public static long[] getLongArray(Element parent, String name) {
        String text = parent.getChildText(name);
        String[] entries = text.split("\\s+");
        if (entries.length == 1 && entries[0].isEmpty()) {
            return new long[0];
        }
        long[] array = new long[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            array[i] = Long.parseLong(entries[i]);
        }
        return array;
    }

    public static long[] getLongArray(Element parent, String name, long[] defaultValue) {
        return parent.getChild(name) == null ? defaultValue : XmlHelpers.getLongArray(parent, name);
    }

    public static Element dimensionsElement(String name, Dimensions size) {
        long[] array = new long[size.numDimensions()];
        size.dimensions(array);
        return XmlHelpers.longArrayElement(name, array);
    }

    public static Dimensions getDimensions(Element parent, String name) {
        return FinalDimensions.wrap((long[])XmlHelpers.getLongArray(parent, name));
    }

    public static Dimensions getDimensions(Element parent, String name, Dimensions defaultValue) {
        return parent.getChild(name) == null ? defaultValue : XmlHelpers.getDimensions(parent, name);
    }

    public static Element affineTransform3DElement(String name, AffineGet value) {
        assert (value.numDimensions() == 3);
        double[] v = value.getRowPackedCopy();
        return XmlHelpers.doubleArrayElement(name, v);
    }

    public static AffineTransform3D getAffineTransform3D(Element parent, String name) {
        return XmlHelpers.getAffineTransform3D(parent, name, null);
    }

    public static AffineTransform3D getAffineTransform3D(Element parent, String name, AffineTransform3D defaultValue) {
        double[] values = XmlHelpers.getDoubleArray(parent, name, null);
        if (values == null) {
            return defaultValue;
        }
        if (values.length == 12) {
            AffineTransform3D a = new AffineTransform3D();
            a.set(values);
            return a;
        }
        throw new NumberFormatException("Inappropriate parameters for " + AffineTransform3D.class.getCanonicalName());
    }

    public static File loadPath(Element parent, String name, String defaultRelativePath, File basePath) {
        boolean isRelative;
        Element elem = parent.getChild(name);
        String path = elem == null ? defaultRelativePath : elem.getText();
        boolean bl = isRelative = elem == null ? true : elem.getAttributeValue("type").equals("relative");
        if (isRelative) {
            if (basePath == null) {
                return null;
            }
            return new File(basePath + "/" + path);
        }
        return new File(path);
    }

    public static File loadPath(Element parent, String name, File basePath) {
        boolean isRelative;
        Element elem = parent.getChild(name);
        if (elem == null) {
            return null;
        }
        String path = elem.getText();
        String pathType = elem.getAttributeValue("type");
        boolean bl = isRelative = null != pathType && pathType.equals("relative");
        if (isRelative) {
            if (basePath == null) {
                return null;
            }
            return new File(basePath + "/" + path);
        }
        return new File(path);
    }

    public static boolean isPathRelative(Element parent, String name) {
        Element elem = parent.getChild(name);
        if (elem == null) {
            return false;
        }
        String path = elem.getText();
        String pathType = elem.getAttributeValue("type");
        boolean isRelative = null != pathType && pathType.equals("relative");
        return isRelative;
    }

    public static Element pathElement(String name, File path, File basePath) {
        Element e = new Element(name);
        if (basePath == null) {
            e.setAttribute("type", "absolute");
            e.setText(path.getAbsolutePath());
        } else {
            File relativePath = XmlHelpers.getRelativePath(path, basePath);
            if (null == relativePath) {
                e.setAttribute("type", "absolute");
                e.setText(path.getAbsolutePath());
            } else {
                e.setAttribute("type", "relative");
                e.setText(relativePath.getPath());
            }
        }
        return e;
    }

    public static File getRelativePath(File file, File relativeToThis) {
        try {
            return XmlHelpers.getRelativePath(file.getCanonicalFile(), relativeToThis.getCanonicalFile(), "");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static File getRelativePath(File file, File relativeToThis, String relativeInitial) {
        String relative = null;
        for (File parent = file; parent != null; parent = parent.getParentFile()) {
            if (parent.equals(relativeToThis)) {
                return new File(relativeInitial + (relative == null ? "." : relative));
            }
            relative = parent.getName() + (relative == null ? "" : "/" + relative);
        }
        File toParent = relativeToThis.getParentFile();
        if (toParent == null) {
            return null;
        }
        return XmlHelpers.getRelativePath(file, toParent, "../" + relativeInitial);
    }
}

