/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data;

import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.registration.ViewTransformAffine;
import mpicbg.spim.data.registration.XmlIoViewRegistrations;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.Tile;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.TimePointsPattern;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.XmlIoSequenceDescription;
import mpicbg.spim.data.sequence.XmlIoTimePoints;
import mpicbg.spim.data.sequence.XmlIoViewSetups;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.realtransform.AffineTransform3D;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class SpimDataExample2 {
    public static ArrayList<ViewSetup> createSetups() {
        ArrayList<ViewSetup> setups = new ArrayList<ViewSetup>();
        Channel c0 = new Channel(0);
        Angle a0 = new Angle(0, "0", 240.0, new double[]{1.0, 0.0, 0.0});
        Angle a1 = new Angle(1, "120", 120.0, new double[]{1.0, 0.0, 0.0});
        Angle a2 = new Angle(2, "240");
        Illumination i0 = new Illumination(0);
        Tile t0 = new Tile(0, "Tile0", new double[]{0.0, 0.0, 0.0});
        FinalDimensions d0 = new FinalDimensions(new long[]{1000L, 1000L, 300L});
        FinalVoxelDimensions vd0 = new FinalVoxelDimensions("px", 1.0, 1.0, 1.0);
        setups.add(new ViewSetup(0, "setup 0", (Dimensions)d0, vd0, t0, c0, a0, i0));
        setups.add(new ViewSetup(1, "setup 1", (Dimensions)d0, vd0, t0, c0, a1, i0));
        setups.add(new ViewSetup(2, "setup 2", null, null, t0, c0, a2, i0));
        return setups;
    }

    public static TimePoints createTimePoints() throws ParseException {
        TimePointsPattern timepoints = new TimePointsPattern("1-100:20");
        return timepoints;
    }

    public static SequenceDescription createSequenceDescription() throws ParseException {
        TimePoints timepoints = SpimDataExample2.createTimePoints();
        ArrayList<ViewSetup> setups = SpimDataExample2.createSetups();
        ArrayList<ViewId> missing = new ArrayList<ViewId>();
        missing.add(new ViewId(1, 0));
        missing.add(new ViewId(21, 1));
        missing.add(new ViewId(41, 3));
        MissingViews missingViews = new MissingViews(missing);
        SequenceDescription sequence = new SequenceDescription(timepoints, setups, null, missingViews);
        return sequence;
    }

    public static ViewRegistrations createViewRegistrations() {
        HashMap<ViewId, ViewRegistration> registrations = new HashMap<ViewId, ViewRegistration>();
        registrations.put(new ViewId(21, 1), new ViewRegistration(21, 1));
        AffineTransform3D t00 = new AffineTransform3D();
        t00.set(1.0, 0.0, 0.0, 1.3, 0.0, 1.0, 0.0, 1.3, 0.0, 0.0, 1.0, 2.3);
        registrations.put(new ViewId(1, 0), new ViewRegistration(0, 0, t00));
        ArrayList<ViewTransform> list = new ArrayList<ViewTransform>();
        list.add(new ViewTransformAffine(null, t00));
        list.add(new ViewTransformAffine("identity", new AffineTransform3D()));
        registrations.put(new ViewId(41, 1), new ViewRegistration(41, 1, list));
        ViewRegistrations viewRegistrations = new ViewRegistrations(registrations);
        return viewRegistrations;
    }

    public static void exampleViewSetups() throws IOException, SpimDataException {
        XmlIoViewSetups io = new XmlIoViewSetups();
        ArrayList<ViewSetup> setups = SpimDataExample2.createSetups();
        Document doc = new Document(io.toXml(setups));
        new XMLOutputter(Format.getPrettyFormat()).output(doc, (OutputStream)System.out);
        Object fromXml = io.fromXml(doc.getRootElement());
        new XMLOutputter(Format.getPrettyFormat()).output(new Document(new XmlIoViewSetups().toXml(fromXml)), (OutputStream)System.out);
    }

    public static void exampleTimePoints() throws ParseException, IOException, SpimDataException {
        XmlIoTimePoints io = new XmlIoTimePoints();
        TimePoints timepoints = SpimDataExample2.createTimePoints();
        Document doc = new Document(io.toXml(timepoints));
        new XMLOutputter(Format.getPrettyFormat()).output(doc, (OutputStream)System.out);
        TimePoints fromXml = io.fromXml(doc.getRootElement());
        for (TimePoint tp : fromXml.getTimePointsOrdered()) {
            System.out.println(tp.getName());
        }
        new XMLOutputter(Format.getPrettyFormat()).output(new Document(new XmlIoTimePoints().toXml(fromXml)), (OutputStream)System.out);
    }

    public static void exampleSequenceDescription() throws IOException, ParseException, SpimDataException {
        XmlIoSequenceDescription io = new XmlIoSequenceDescription();
        SequenceDescription sequence = SpimDataExample2.createSequenceDescription();
        Document doc = new Document(io.toXml(sequence, null));
        new XMLOutputter(Format.getPrettyFormat()).output(doc, (OutputStream)System.out);
        SequenceDescription fromXml = (SequenceDescription)io.fromXml(doc.getRootElement(), null);
        new XMLOutputter(Format.getPrettyFormat()).output(new Document(new XmlIoSequenceDescription().toXml(fromXml, null)), (OutputStream)System.out);
    }

    public static void exampleViewRegistrations() throws SpimDataException, IOException {
        XmlIoViewRegistrations io = new XmlIoViewRegistrations();
        ViewRegistrations registrations = SpimDataExample2.createViewRegistrations();
        Document doc = new Document(io.toXml(registrations));
        new XMLOutputter(Format.getPrettyFormat()).output(doc, (OutputStream)System.out);
        ViewRegistrations fromXml = io.fromXml(doc.getRootElement());
        new XMLOutputter(Format.getPrettyFormat()).output(new Document(new XmlIoViewRegistrations().toXml(fromXml)), (OutputStream)System.out);
    }

    public static void main(String[] args) throws IOException, SpimDataException, ParseException {
        SpimDataExample2.exampleViewSetups();
        SpimDataExample2.exampleTimePoints();
        SpimDataExample2.exampleViewRegistrations();
        SpimDataExample2.exampleSequenceDescription();
    }
}

