/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.scijava.InstantiableException;
import org.scijava.command.Command;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandModuleItem;
import org.scijava.command.PyModuleCommand;
import org.scijava.module.Module;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public class PyCommandInfo
extends CommandInfo {
    final Supplier<? extends Command> creator;
    private final Map<String, ModuleItem<?>> inputMap = new HashMap();
    private final Map<String, ModuleItem<?>> outputMap = new HashMap();
    private final List<ModuleItem<?>> inputList = new ArrayList();
    private final List<ModuleItem<?>> outputList = new ArrayList();

    public PyCommandInfo(String name, Plugin annotation, Map<String, Class<?>> inputsDefinition, Map<String, Class<?>> outputsDefinition, Map<String, Object> inputsDefaults, Map<String, Object> outputsDefaults, Map<String, Parameter> inputsParameters, Map<String, Parameter> outputsParameters, final Function<Map<String, Object>, Map<String, Object>> command) {
        super(null, name, null, annotation);
        this.creator = () -> {
            PyModuleCommand c = new PyModuleCommand(){

                @Override
                public CommandInfo getInfo() {
                    return PyCommandInfo.this;
                }

                public Object getInput(String name) {
                    return this.inputs.get(name);
                }

                public Object getOutput(String name) {
                    return this.outputs.get(name);
                }

                public void setInput(String name, Object value) {
                    this.inputs.put(name, value);
                }

                public void setOutput(String name, Object value) {
                    this.outputs.put(name, value);
                }

                public void run() {
                    this.outputs = (Map)command.apply(this.inputs);
                }
            };
            c.iniInputs(this);
            return c;
        };
        try {
            Field f = this.creator.get().getClass().getField("dummyContext");
            inputsDefinition.forEach((inputName, clazz) -> {
                PyCommandModuleItem item = new PyCommandModuleItem((ModuleInfo)this, f, clazz, inputsDefaults.get(inputName), (Parameter)inputsParameters.get(inputName), (String)inputName);
                this.inputMap.put((String)inputName, (ModuleItem<?>)item);
                this.inputList.add((ModuleItem<?>)item);
            });
            outputsDefinition.forEach((outputName, clazz) -> {
                PyCommandModuleItem item = new PyCommandModuleItem((ModuleInfo)this, f, clazz, outputsDefaults.get(outputName), (Parameter)outputsParameters.get(outputName), (String)outputName);
                this.outputMap.put((String)outputName, (ModuleItem<?>)item);
                this.outputList.add((ModuleItem<?>)item);
            });
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private static boolean hasParameterlessPublicConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            return true;
        }
        return false;
    }

    public Class<? extends Command> loadClass() throws InstantiableException {
        return this.creator.get().getClass();
    }

    public Command createInstance() throws InstantiableException {
        return this.creator.get();
    }

    public Module createModule() throws ModuleException {
        return (Module)this.creator.get();
    }

    public Iterable<ModuleItem<?>> inputs() {
        return Collections.unmodifiableList(this.inputList);
    }

    public Iterable<ModuleItem<?>> outputs() {
        return Collections.unmodifiableList(this.outputList);
    }

    public CommandModuleItem<?> getInput(String name) {
        return (CommandModuleItem)this.inputMap.get(name);
    }

    public String toString() {
        return super.toString();
    }

    public static class PyCommandModuleItem<T>
    extends CommandModuleItem<T> {
        final Parameter parameter;
        final Class<T> objectClass;
        final T defaultValue;
        final String name;

        public PyCommandModuleItem(ModuleInfo info, Field field, Class<T> objectClass, T defaultValue, Parameter parameter, String name) {
            super(info, field);
            this.parameter = parameter;
            this.objectClass = objectClass;
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public Parameter getParameter() {
            return this.parameter;
        }

        public Class<T> getType() {
            return this.objectClass;
        }

        public Type getGenericType() {
            return this.objectClass;
        }

        public String getName() {
            return this.name;
        }

        public T getDefaultValue() {
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            try {
                if (this.objectClass.equals(Integer.TYPE)) {
                    return (T)Integer.valueOf(0);
                }
                if (this.objectClass.equals(Double.TYPE)) {
                    return (T)Double.valueOf(0.0);
                }
                if (this.objectClass.equals(Float.TYPE)) {
                    return (T)Float.valueOf(0.0f);
                }
                if (this.objectClass.equals(Boolean.TYPE)) {
                    return (T)Boolean.FALSE;
                }
                if (this.objectClass.equals(Integer.class)) {
                    return (T)Integer.valueOf(0);
                }
                if (this.objectClass.equals(Double.class)) {
                    return (T)Double.valueOf(0.0);
                }
                if (this.objectClass.equals(Float.class)) {
                    return (T)Float.valueOf(0.0f);
                }
                if (this.objectClass.equals(Boolean.class)) {
                    return (T)Boolean.FALSE;
                }
                if (PyCommandInfo.hasParameterlessPublicConstructor(this.objectClass)) {
                    T dummy;
                    T value = dummy = this.objectClass.newInstance();
                    return value;
                }
                return null;
            }
            catch (IllegalAccessException | InstantiationException exc) {
                throw new IllegalStateException(exc);
            }
        }
    }
}

