/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.scijava.Context;
import org.scijava.command.Command;
import org.scijava.command.PyCommandInfo;
import org.scijava.command.PyParameterBuilder;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.plugin.SciJavaPlugin;

public class PyCommandBuilder {
    String name;
    String menuPath;
    String label;
    String description = "";
    Map<String, Class<?>> inputsDefinition = new HashMap();
    Map<String, Object> inputsDefaultValue = new HashMap<String, Object>();
    Map<String, Parameter> inputsParameter = new HashMap<String, Parameter>();
    Map<String, Class<?>> outputsDefinition = new HashMap();
    Map<String, Object> outputsDefaultValue = new HashMap<String, Object>();
    Map<String, Parameter> outputsParameter = new HashMap<String, Parameter>();
    Function<Map<String, Object>, Map<String, Object>> command;

    public PyCommandBuilder name(String name) {
        this.name = name;
        return this;
    }

    public PyCommandBuilder input(String name, Class<?> inputClass) {
        this.inputsDefinition.put(name, inputClass);
        this.inputsDefaultValue.put(name, null);
        Parameter p = PyParameterBuilder.defaultInputParameter();
        this.inputsParameter.put(name, p);
        return this;
    }

    public PyCommandBuilder output(String name, Class<?> outputClass) {
        this.outputsDefinition.put(name, outputClass);
        this.outputsDefaultValue.put(name, null);
        Parameter p = PyParameterBuilder.defaultOutputParameter();
        this.outputsParameter.put(name, p);
        return this;
    }

    public PyCommandBuilder input(String name, Class<?> inputClass, Object defaultValue) {
        this.inputsDefinition.put(name, inputClass);
        this.inputsDefaultValue.put(name, defaultValue);
        Parameter p = PyParameterBuilder.defaultInputParameter();
        this.inputsParameter.put(name, p);
        return this;
    }

    public PyCommandBuilder output(String name, Class<?> outputClass, Object defaultValue) {
        this.outputsDefinition.put(name, outputClass);
        this.outputsDefaultValue.put(name, defaultValue);
        Parameter p = PyParameterBuilder.defaultOutputParameter();
        this.outputsParameter.put(name, p);
        return this;
    }

    public PyCommandBuilder input(String name, Class<?> inputClass, Parameter p) {
        this.inputsDefinition.put(name, inputClass);
        this.inputsDefaultValue.put(name, null);
        this.inputsParameter.put(name, p);
        return this;
    }

    public PyCommandBuilder output(String name, Class<?> outputClass, Parameter p) {
        this.outputsDefinition.put(name, outputClass);
        this.outputsDefaultValue.put(name, null);
        this.outputsParameter.put(name, p);
        return this;
    }

    public PyCommandBuilder input(String name, Class<?> inputClass, Object defaultValue, Parameter p) {
        this.inputsDefinition.put(name, inputClass);
        this.inputsDefaultValue.put(name, defaultValue);
        this.inputsParameter.put(name, p);
        return this;
    }

    public PyCommandBuilder output(String name, Class<?> outputClass, Object defaultValue, Parameter p) {
        this.outputsDefinition.put(name, outputClass);
        this.outputsDefaultValue.put(name, defaultValue);
        this.outputsParameter.put(name, p);
        return this;
    }

    public PyCommandBuilder function(Function<Map<String, Object>, Map<String, Object>> command) {
        this.command = command;
        return this;
    }

    public PyCommandBuilder menuPath(String menuPath) {
        this.menuPath = menuPath;
        return this;
    }

    public PyCommandBuilder label(String label) {
        this.label = label;
        return this;
    }

    public PyCommandBuilder description(String description) {
        this.description = description;
        return this;
    }

    public void create(Context ctx) {
        Plugin pluginAnnotation = new Plugin(){

            public Class<? extends Annotation> annotationType() {
                return Plugin.class;
            }

            public Class<? extends SciJavaPlugin> type() {
                return Command.class;
            }

            public String name() {
                return PyCommandBuilder.this.name;
            }

            public String label() {
                return PyCommandBuilder.this.label;
            }

            public String description() {
                return PyCommandBuilder.this.description;
            }

            public String menuPath() {
                return PyCommandBuilder.this.menuPath;
            }

            public Menu[] menu() {
                return new Menu[0];
            }

            public String menuRoot() {
                return "app";
            }

            public String iconPath() {
                return "";
            }

            public double priority() {
                return 0.0;
            }

            public boolean selectable() {
                return false;
            }

            public String selectionGroup() {
                return "";
            }

            public boolean enabled() {
                return true;
            }

            public boolean visible() {
                return true;
            }

            public boolean headless() {
                return false;
            }

            public String initializer() {
                return "";
            }

            public Attr[] attrs() {
                return new Attr[0];
            }
        };
        PyCommandInfo pci = new PyCommandInfo(this.name, pluginAnnotation, this.inputsDefinition, this.outputsDefinition, this.inputsDefaultValue, this.outputsDefaultValue, this.inputsParameter, this.outputsParameter, this.command);
        ((PluginService)ctx.getService(PluginService.class)).addPlugin((PluginInfo)pci);
    }
}

