/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.results;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;
import sc.fiji.coloc.algorithms.Histogram2D;
import sc.fiji.coloc.results.NamedContainer;
import sc.fiji.coloc.results.ResultHandler;
import sc.fiji.coloc.results.ValueResult;
import sc.fiji.coloc.results.Warning;

public class AnalysisResults<T extends RealType<T>>
implements ResultHandler<T> {
    private final List<NamedContainer<RandomAccessibleInterval<? extends RealType<?>>>> listOfImages = new ArrayList();
    private final Map<RandomAccessibleInterval<LongType>, Histogram2D<T>> mapOf2DHistograms = new HashMap<RandomAccessibleInterval<LongType>, Histogram2D<T>>();
    private final List<Warning> warnings = new ArrayList<Warning>();
    private final List<ValueResult> valueResults = new ArrayList<ValueResult>();
    private final Map<Object, String> listOfLUTs = new HashMap<Object, String>();

    public List<NamedContainer<RandomAccessibleInterval<? extends RealType<?>>>> images() {
        return this.listOfImages;
    }

    public Map<RandomAccessibleInterval<LongType>, Histogram2D<T>> histograms() {
        return this.mapOf2DHistograms;
    }

    public List<Warning> warnings() {
        return this.warnings;
    }

    public List<ValueResult> values() {
        return this.valueResults;
    }

    @Override
    public void handleImage(RandomAccessibleInterval<T> image, String name) {
        this.listOfImages.add(new NamedContainer<RandomAccessibleInterval<T>>(image, name));
    }

    @Override
    public void handleHistogram(Histogram2D<T> histogram, String name) {
        this.listOfImages.add(new NamedContainer<RandomAccessibleInterval<LongType>>(histogram.getPlotImage(), name));
        this.mapOf2DHistograms.put(histogram.getPlotImage(), histogram);
        this.listOfLUTs.put(histogram.getPlotImage(), "Fire");
    }

    @Override
    public void handleWarning(Warning warning) {
        this.warnings.add(warning);
    }

    @Override
    public void handleValue(String name, String value) {
        this.valueResults.add(new ValueResult(name, value));
    }

    @Override
    public void handleValue(String name, double value) {
        this.handleValue(name, value, 3);
    }

    @Override
    public void handleValue(String name, double value, int decimals) {
        this.valueResults.add(new ValueResult(name, value, decimals));
    }

    @Override
    public void process() {
    }
}

